/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.HasDefaultViewModelProviderFactory;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavControllerViewModel;
import androidx.navigation.NavDestination;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import java.util.UUID;

public final class NavBackStackEntry
implements LifecycleOwner,
ViewModelStoreOwner,
HasDefaultViewModelProviderFactory,
SavedStateRegistryOwner {
    private final Context mContext;
    private final NavDestination mDestination;
    private Bundle mArgs;
    private final LifecycleRegistry mLifecycle = new LifecycleRegistry((LifecycleOwner)this);
    private final SavedStateRegistryController mSavedStateRegistryController = SavedStateRegistryController.create((SavedStateRegistryOwner)this);
    @NonNull
    final UUID mId;
    private Lifecycle.State mHostLifecycle = Lifecycle.State.CREATED;
    private Lifecycle.State mMaxLifecycle = Lifecycle.State.RESUMED;
    private NavControllerViewModel mNavControllerViewModel;
    private ViewModelProvider.Factory mDefaultFactory;
    private SavedStateHandle mSavedStateHandle;

    NavBackStackEntry(@NonNull Context context, @NonNull NavDestination destination, @Nullable Bundle args, @Nullable LifecycleOwner navControllerLifecycleOwner, @Nullable NavControllerViewModel navControllerViewModel) {
        this(context, destination, args, navControllerLifecycleOwner, navControllerViewModel, UUID.randomUUID(), null);
    }

    NavBackStackEntry(@NonNull Context context, @NonNull NavDestination destination, @Nullable Bundle args, @Nullable LifecycleOwner navControllerLifecycleOwner, @Nullable NavControllerViewModel navControllerViewModel, @NonNull UUID uuid, @Nullable Bundle savedState) {
        this.mContext = context;
        this.mId = uuid;
        this.mDestination = destination;
        this.mArgs = args;
        this.mNavControllerViewModel = navControllerViewModel;
        this.mSavedStateRegistryController.performRestore(savedState);
        if (navControllerLifecycleOwner != null) {
            this.mHostLifecycle = navControllerLifecycleOwner.getLifecycle().getCurrentState();
        }
    }

    @NonNull
    public NavDestination getDestination() {
        return this.mDestination;
    }

    @Nullable
    public Bundle getArguments() {
        return this.mArgs;
    }

    void replaceArguments(@Nullable Bundle newArgs) {
        this.mArgs = newArgs;
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.mLifecycle;
    }

    void setMaxLifecycle(@NonNull Lifecycle.State maxState) {
        this.mMaxLifecycle = maxState;
        this.updateState();
    }

    @NonNull
    Lifecycle.State getMaxLifecycle() {
        return this.mMaxLifecycle;
    }

    void handleLifecycleEvent(@NonNull Lifecycle.Event event) {
        this.mHostLifecycle = NavBackStackEntry.getStateAfter(event);
        this.updateState();
    }

    void updateState() {
        if (this.mHostLifecycle.ordinal() < this.mMaxLifecycle.ordinal()) {
            this.mLifecycle.setCurrentState(this.mHostLifecycle);
        } else {
            this.mLifecycle.setCurrentState(this.mMaxLifecycle);
        }
    }

    @NonNull
    public ViewModelStore getViewModelStore() {
        if (this.mNavControllerViewModel == null) {
            throw new IllegalStateException("You must call setViewModelStore() on your NavHostController before accessing the ViewModelStore of a navigation graph.");
        }
        return this.mNavControllerViewModel.getViewModelStore(this.mId);
    }

    @NonNull
    public ViewModelProvider.Factory getDefaultViewModelProviderFactory() {
        if (this.mDefaultFactory == null) {
            this.mDefaultFactory = new SavedStateViewModelFactory((Application)this.mContext.getApplicationContext(), (SavedStateRegistryOwner)this, this.mArgs);
        }
        return this.mDefaultFactory;
    }

    @NonNull
    public SavedStateRegistry getSavedStateRegistry() {
        return this.mSavedStateRegistryController.getSavedStateRegistry();
    }

    void saveState(@NonNull Bundle outBundle) {
        this.mSavedStateRegistryController.performSave(outBundle);
    }

    @NonNull
    public SavedStateHandle getSavedStateHandle() {
        if (this.mSavedStateHandle == null) {
            this.mSavedStateHandle = ((SavedStateViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new NavResultSavedStateFactory(this, null)).get(SavedStateViewModel.class)).getHandle();
        }
        return this.mSavedStateHandle;
    }

    @NonNull
    private static Lifecycle.State getStateAfter(@NonNull Lifecycle.Event event) {
        switch (event) {
            case ON_CREATE: 
            case ON_STOP: {
                return Lifecycle.State.CREATED;
            }
            case ON_START: 
            case ON_PAUSE: {
                return Lifecycle.State.STARTED;
            }
            case ON_RESUME: {
                return Lifecycle.State.RESUMED;
            }
            case ON_DESTROY: {
                return Lifecycle.State.DESTROYED;
            }
        }
        throw new IllegalArgumentException("Unexpected event value " + event);
    }

    private static class SavedStateViewModel
    extends ViewModel {
        private SavedStateHandle mHandle;

        SavedStateViewModel(SavedStateHandle handle) {
            this.mHandle = handle;
        }

        public SavedStateHandle getHandle() {
            return this.mHandle;
        }
    }

    private static class NavResultSavedStateFactory
    extends AbstractSavedStateViewModelFactory {
        NavResultSavedStateFactory(@NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
            super(owner, defaultArgs);
        }

        @NonNull
        protected <T extends ViewModel> T create(@NonNull String key, @NonNull Class<T> modelClass, @NonNull SavedStateHandle handle) {
            SavedStateViewModel savedStateViewModel = new SavedStateViewModel(handle);
            return (T)((Object)savedStateViewModel);
        }
    }
}

