/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view.menu;

import android.content.Context;
import android.view.MenuItem;
import android.view.SubMenu;
import androidx.appcompat.view.menu.MenuItemWrapperICS;
import androidx.appcompat.view.menu.SubMenuWrapperICS;
import androidx.collection.SimpleArrayMap;
import androidx.core.internal.view.SupportMenuItem;
import androidx.core.internal.view.SupportSubMenu;

abstract class BaseMenuWrapper {
    final Context mContext;
    private SimpleArrayMap<SupportMenuItem, MenuItem> mMenuItems;
    private SimpleArrayMap<SupportSubMenu, SubMenu> mSubMenus;

    BaseMenuWrapper(Context context) {
        this.mContext = context;
    }

    final MenuItem getMenuItemWrapper(MenuItem menuItem) {
        if (menuItem instanceof SupportMenuItem) {
            MenuItem wrappedItem;
            SupportMenuItem supportMenuItem = (SupportMenuItem)menuItem;
            if (this.mMenuItems == null) {
                this.mMenuItems = new SimpleArrayMap();
            }
            if (null == (wrappedItem = (MenuItem)this.mMenuItems.get((Object)menuItem))) {
                wrappedItem = new MenuItemWrapperICS(this.mContext, supportMenuItem);
                this.mMenuItems.put((Object)supportMenuItem, (Object)wrappedItem);
            }
            return wrappedItem;
        }
        return menuItem;
    }

    final SubMenu getSubMenuWrapper(SubMenu subMenu) {
        if (subMenu instanceof SupportSubMenu) {
            SubMenu wrappedMenu;
            SupportSubMenu supportSubMenu = (SupportSubMenu)subMenu;
            if (this.mSubMenus == null) {
                this.mSubMenus = new SimpleArrayMap();
            }
            if (null == (wrappedMenu = (SubMenu)this.mSubMenus.get((Object)supportSubMenu))) {
                wrappedMenu = new SubMenuWrapperICS(this.mContext, supportSubMenu);
                this.mSubMenus.put((Object)supportSubMenu, (Object)wrappedMenu);
            }
            return wrappedMenu;
        }
        return subMenu;
    }

    final void internalClear() {
        if (this.mMenuItems != null) {
            this.mMenuItems.clear();
        }
        if (this.mSubMenus != null) {
            this.mSubMenus.clear();
        }
    }

    final void internalRemoveGroup(int groupId) {
        if (this.mMenuItems == null) {
            return;
        }
        for (int i = 0; i < this.mMenuItems.size(); ++i) {
            if (((SupportMenuItem)this.mMenuItems.keyAt(i)).getGroupId() != groupId) continue;
            this.mMenuItems.removeAt(i);
            --i;
        }
    }

    final void internalRemoveItem(int id2) {
        if (this.mMenuItems == null) {
            return;
        }
        for (int i = 0; i < this.mMenuItems.size(); ++i) {
            if (((SupportMenuItem)this.mMenuItems.keyAt(i)).getItemId() != id2) continue;
            this.mMenuItems.removeAt(i);
            break;
        }
    }
}

