/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

public class ListFragment
extends Fragment {
    static final int INTERNAL_EMPTY_ID = 0xFF0001;
    static final int INTERNAL_PROGRESS_CONTAINER_ID = 0xFF0002;
    static final int INTERNAL_LIST_CONTAINER_ID = 0xFF0003;
    private final Handler mHandler = new Handler();
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            ListFragment.this.mList.focusableViewAvailable((View)ListFragment.this.mList);
        }
    };
    private final AdapterView.OnItemClickListener mOnClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
            ListFragment.this.onListItemClick((ListView)parent, v, position, id2);
        }
    };
    ListAdapter mAdapter;
    ListView mList;
    View mEmptyView;
    TextView mStandardEmptyView;
    View mProgressContainer;
    View mListContainer;
    CharSequence mEmptyText;
    boolean mListShown;

    @Override
    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Context context = this.requireContext();
        FrameLayout root = new FrameLayout(context);
        LinearLayout pframe = new LinearLayout(context);
        pframe.setId(0xFF0002);
        pframe.setOrientation(1);
        pframe.setVisibility(8);
        pframe.setGravity(17);
        ProgressBar progress = new ProgressBar(context, null, 16842874);
        pframe.addView((View)progress, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        root.addView((View)pframe, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout lframe = new FrameLayout(context);
        lframe.setId(0xFF0003);
        TextView tv = new TextView(context);
        tv.setId(0xFF0001);
        tv.setGravity(17);
        lframe.addView((View)tv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        ListView lv = new ListView(context);
        lv.setId(16908298);
        lv.setDrawSelectorOnTop(false);
        lframe.addView((View)lv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        root.addView((View)lframe, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        root.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        return root;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.ensureList();
    }

    @Override
    public void onDestroyView() {
        this.mHandler.removeCallbacks(this.mRequestFocus);
        this.mList = null;
        this.mListShown = false;
        this.mListContainer = null;
        this.mProgressContainer = null;
        this.mEmptyView = null;
        this.mStandardEmptyView = null;
        super.onDestroyView();
    }

    public void onListItemClick(@NonNull ListView l, @NonNull View v, int position, long id2) {
    }

    public void setListAdapter(@Nullable ListAdapter adapter) {
        boolean hadAdapter = this.mAdapter != null;
        this.mAdapter = adapter;
        if (this.mList != null) {
            this.mList.setAdapter(adapter);
            if (!this.mListShown && !hadAdapter) {
                this.setListShown(true, this.requireView().getWindowToken() != null);
            }
        }
    }

    public void setSelection(int position) {
        this.ensureList();
        this.mList.setSelection(position);
    }

    public int getSelectedItemPosition() {
        this.ensureList();
        return this.mList.getSelectedItemPosition();
    }

    public long getSelectedItemId() {
        this.ensureList();
        return this.mList.getSelectedItemId();
    }

    @NonNull
    public ListView getListView() {
        this.ensureList();
        return this.mList;
    }

    public void setEmptyText(@Nullable CharSequence text) {
        this.ensureList();
        if (this.mStandardEmptyView == null) {
            throw new IllegalStateException("Can't be used with a custom content view");
        }
        this.mStandardEmptyView.setText(text);
        if (this.mEmptyText == null) {
            this.mList.setEmptyView((View)this.mStandardEmptyView);
        }
        this.mEmptyText = text;
    }

    public void setListShown(boolean shown) {
        this.setListShown(shown, true);
    }

    public void setListShownNoAnimation(boolean shown) {
        this.setListShown(shown, false);
    }

    private void setListShown(boolean shown, boolean animate) {
        this.ensureList();
        if (this.mProgressContainer == null) {
            throw new IllegalStateException("Can't be used with a custom content view");
        }
        if (this.mListShown == shown) {
            return;
        }
        this.mListShown = shown;
        if (shown) {
            if (animate) {
                this.mProgressContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001));
                this.mListContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000));
            } else {
                this.mProgressContainer.clearAnimation();
                this.mListContainer.clearAnimation();
            }
            this.mProgressContainer.setVisibility(8);
            this.mListContainer.setVisibility(0);
        } else {
            if (animate) {
                this.mProgressContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000));
                this.mListContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001));
            } else {
                this.mProgressContainer.clearAnimation();
                this.mListContainer.clearAnimation();
            }
            this.mProgressContainer.setVisibility(0);
            this.mListContainer.setVisibility(8);
        }
    }

    @Nullable
    public ListAdapter getListAdapter() {
        return this.mAdapter;
    }

    @NonNull
    public final ListAdapter requireListAdapter() {
        ListAdapter listAdapter = this.getListAdapter();
        if (listAdapter == null) {
            throw new IllegalStateException("ListFragment " + this + " does not have a ListAdapter.");
        }
        return listAdapter;
    }

    private void ensureList() {
        if (this.mList != null) {
            return;
        }
        View root = this.getView();
        if (root == null) {
            throw new IllegalStateException("Content view not yet created");
        }
        if (root instanceof ListView) {
            this.mList = (ListView)root;
        } else {
            this.mStandardEmptyView = (TextView)root.findViewById(0xFF0001);
            if (this.mStandardEmptyView == null) {
                this.mEmptyView = root.findViewById(16908292);
            } else {
                this.mStandardEmptyView.setVisibility(8);
            }
            this.mProgressContainer = root.findViewById(0xFF0002);
            this.mListContainer = root.findViewById(0xFF0003);
            View rawListView = root.findViewById(16908298);
            if (!(rawListView instanceof ListView)) {
                if (rawListView == null) {
                    throw new RuntimeException("Your content must have a ListView whose id attribute is 'android.R.id.list'");
                }
                throw new RuntimeException("Content has view with id attribute 'android.R.id.list' that is not a ListView class");
            }
            this.mList = (ListView)rawListView;
            if (this.mEmptyView != null) {
                this.mList.setEmptyView(this.mEmptyView);
            } else if (this.mEmptyText != null) {
                this.mStandardEmptyView.setText(this.mEmptyText);
                this.mList.setEmptyView((View)this.mStandardEmptyView);
            }
        }
        this.mListShown = true;
        this.mList.setOnItemClickListener(this.mOnClickListener);
        if (this.mAdapter != null) {
            ListAdapter adapter = this.mAdapter;
            this.mAdapter = null;
            this.setListAdapter(adapter);
        } else if (this.mProgressContainer != null) {
            this.setListShown(false, false);
        }
        this.mHandler.post(this.mRequestFocus);
    }
}

