/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Property;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import androidx.vectordrawable.graphics.drawable.AnimationUtilsCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;
import java.util.Arrays;

final class LinearIndeterminateDisjointAnimatorDelegate
extends IndeterminateAnimatorDelegate<ObjectAnimator> {
    private static final int TOTAL_DURATION_IN_MS = 1800;
    private static final int[] DURATION_TO_MOVE_SEGMENT_ENDS = new int[]{533, 567, 850, 750};
    private static final int[] DELAY_TO_MOVE_SEGMENT_ENDS = new int[]{1267, 1000, 333, 0};
    private ObjectAnimator animator;
    private final Interpolator[] interpolatorArray;
    private final BaseProgressIndicatorSpec baseSpec;
    private int indicatorColorIndex = 0;
    private boolean dirtyColors;
    private float animationFraction;
    private boolean animatorCompleteEndRequested;
    Animatable2Compat.AnimationCallback animatorCompleteCallback = null;
    private static final Property<LinearIndeterminateDisjointAnimatorDelegate, Float> ANIMATION_FRACTION = new Property<LinearIndeterminateDisjointAnimatorDelegate, Float>(Float.class, "animationFraction"){

        public Float get(LinearIndeterminateDisjointAnimatorDelegate delegate) {
            return Float.valueOf(delegate.getAnimationFraction());
        }

        public void set(LinearIndeterminateDisjointAnimatorDelegate delegate, Float value) {
            delegate.setAnimationFraction(value.floatValue());
        }
    };

    public LinearIndeterminateDisjointAnimatorDelegate(@NonNull Context context, @NonNull LinearProgressIndicatorSpec spec) {
        super(2);
        this.baseSpec = spec;
        this.interpolatorArray = new Interpolator[]{AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line1_head_interpolator), AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line1_tail_interpolator), AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line2_head_interpolator), AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line2_tail_interpolator)};
    }

    @Override
    public void startAnimator() {
        this.maybeInitializeAnimators();
        this.resetPropertiesForNewStart();
        this.animator.start();
    }

    private void maybeInitializeAnimators() {
        if (this.animator == null) {
            this.animator = ObjectAnimator.ofFloat((Object)this, ANIMATION_FRACTION, (float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(1800L);
            this.animator.setInterpolator(null);
            this.animator.setRepeatCount(-1);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator animation) {
                    super.onAnimationRepeat(animation);
                    LinearIndeterminateDisjointAnimatorDelegate.this.indicatorColorIndex = (LinearIndeterminateDisjointAnimatorDelegate.this.indicatorColorIndex + 1) % ((LinearIndeterminateDisjointAnimatorDelegate)LinearIndeterminateDisjointAnimatorDelegate.this).baseSpec.indicatorColors.length;
                    LinearIndeterminateDisjointAnimatorDelegate.this.dirtyColors = true;
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (LinearIndeterminateDisjointAnimatorDelegate.this.animatorCompleteEndRequested) {
                        LinearIndeterminateDisjointAnimatorDelegate.this.animator.setRepeatCount(-1);
                        LinearIndeterminateDisjointAnimatorDelegate.this.animatorCompleteCallback.onAnimationEnd((Drawable)LinearIndeterminateDisjointAnimatorDelegate.this.drawable);
                        LinearIndeterminateDisjointAnimatorDelegate.this.animatorCompleteEndRequested = false;
                    }
                }
            });
        }
    }

    @Override
    public void cancelAnimatorImmediately() {
        if (this.animator != null) {
            this.animator.cancel();
        }
    }

    @Override
    public void requestCancelAnimatorAfterCurrentCycle() {
        if (this.drawable.isVisible()) {
            this.animatorCompleteEndRequested = true;
            this.animator.setRepeatCount(0);
        } else {
            this.cancelAnimatorImmediately();
        }
    }

    @Override
    public void invalidateSpecValues() {
        this.resetPropertiesForNewStart();
    }

    @Override
    public void registerAnimatorsCompleteCallback(@NonNull Animatable2Compat.AnimationCallback callback) {
        this.animatorCompleteCallback = callback;
    }

    @Override
    public void unregisterAnimatorsCompleteCallback() {
        this.animatorCompleteCallback = null;
    }

    private void updateSegmentPositions(int playtime) {
        for (int i = 0; i < 4; ++i) {
            float fraction = this.getFractionInRange(playtime, DELAY_TO_MOVE_SEGMENT_ENDS[i], DURATION_TO_MOVE_SEGMENT_ENDS[i]);
            float segmentPosition = this.interpolatorArray[i].getInterpolation(fraction);
            this.segmentPositions[i] = Math.max(0.0f, Math.min(1.0f, segmentPosition));
        }
    }

    private void maybeUpdateSegmentColors() {
        if (this.dirtyColors) {
            Arrays.fill(this.segmentColors, MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[this.indicatorColorIndex], this.drawable.getAlpha()));
            this.dirtyColors = false;
        }
    }

    @VisibleForTesting
    void resetPropertiesForNewStart() {
        int indicatorColor;
        this.indicatorColorIndex = 0;
        this.segmentColors[0] = indicatorColor = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.drawable.getAlpha());
        this.segmentColors[1] = indicatorColor;
    }

    private float getAnimationFraction() {
        return this.animationFraction;
    }

    @VisibleForTesting
    void setAnimationFraction(float fraction) {
        this.animationFraction = fraction;
        int playtime = (int)(this.animationFraction * 1800.0f);
        this.updateSegmentPositions(playtime);
        this.maybeUpdateSegmentColors();
        this.drawable.invalidateSelf();
    }
}

