/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AdapterView;
import android.widget.Filterable;
import android.widget.ListAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.appcompat.widget.ListPopupWindow;
import com.google.android.material.R;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialAutoCompleteTextView
extends AppCompatAutoCompleteTextView {
    private static final int MAX_ITEMS_MEASURED = 15;
    @NonNull
    private final ListPopupWindow modalListPopup;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    @NonNull
    private final Rect tempRect = new Rect();

    public MaterialAutoCompleteTextView(@NonNull Context context) {
        this(context, null);
    }

    public MaterialAutoCompleteTextView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.autoCompleteTextViewStyle);
    }

    public MaterialAutoCompleteTextView(@NonNull Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attributeSet, defStyleAttr, 0), attributeSet, defStyleAttr);
        int inputType;
        context = this.getContext();
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.MaterialAutoCompleteTextView, defStyleAttr, R.style.Widget_AppCompat_AutoCompleteTextView, new int[0]);
        if (attributes.hasValue(R.styleable.MaterialAutoCompleteTextView_android_inputType) && (inputType = attributes.getInt(R.styleable.MaterialAutoCompleteTextView_android_inputType, 0)) == 0) {
            this.setKeyListener(null);
        }
        this.accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.modalListPopup = new ListPopupWindow(context);
        this.modalListPopup.setModal(true);
        this.modalListPopup.setAnchorView((View)this);
        this.modalListPopup.setInputMethodMode(2);
        this.modalListPopup.setAdapter(this.getAdapter());
        this.modalListPopup.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View selectedView, int position, long id2) {
                Object selectedItem = position < 0 ? MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItem() : MaterialAutoCompleteTextView.this.getAdapter().getItem(position);
                MaterialAutoCompleteTextView.this.updateText(selectedItem);
                AdapterView.OnItemClickListener userOnitemClickListener = MaterialAutoCompleteTextView.this.getOnItemClickListener();
                if (userOnitemClickListener != null) {
                    if (selectedView == null || position < 0) {
                        selectedView = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedView();
                        position = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItemPosition();
                        id2 = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItemId();
                    }
                    userOnitemClickListener.onItemClick((AdapterView)MaterialAutoCompleteTextView.this.modalListPopup.getListView(), selectedView, position, id2);
                }
                MaterialAutoCompleteTextView.this.modalListPopup.dismiss();
            }
        });
        attributes.recycle();
    }

    public void showDropDown() {
        if (this.accessibilityManager != null && this.accessibilityManager.isTouchExplorationEnabled()) {
            this.modalListPopup.show();
        } else {
            super.showDropDown();
        }
    }

    public <T extends ListAdapter & Filterable> void setAdapter(@Nullable T adapter) {
        super.setAdapter(adapter);
        this.modalListPopup.setAdapter(this.getAdapter());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        TextInputLayout layout2 = this.findTextInputLayoutAncestor();
        if (layout2 != null && layout2.isProvidingHint() && super.getHint() == null && ManufacturerUtils.isMeizuDevice()) {
            this.setHint("");
        }
    }

    @Nullable
    public CharSequence getHint() {
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        if (textInputLayout != null && textInputLayout.isProvidingHint()) {
            return textInputLayout.getHint();
        }
        return super.getHint();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == Integer.MIN_VALUE) {
            int measuredWidth = this.getMeasuredWidth();
            this.setMeasuredDimension(Math.min(Math.max(measuredWidth, this.measureContentWidth()), View.MeasureSpec.getSize((int)widthMeasureSpec)), this.getMeasuredHeight());
        }
    }

    private int measureContentWidth() {
        ListAdapter adapter = this.getAdapter();
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        if (adapter == null || textInputLayout == null) {
            return 0;
        }
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0);
        int start = Math.max(0, this.modalListPopup.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        for (int i = start = Math.max(0, end - 15); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, (ViewGroup)textInputLayout)).getLayoutParams() == null) {
                itemView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        Drawable background = this.modalListPopup.getBackground();
        if (background != null) {
            background.getPadding(this.tempRect);
            width += this.tempRect.left + this.tempRect.right;
        }
        int iconWidth = textInputLayout.getEndIconView().getMeasuredWidth();
        return width += iconWidth;
    }

    @Nullable
    private TextInputLayout findTextInputLayoutAncestor() {
        for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TextInputLayout)) continue;
            return (TextInputLayout)parent;
        }
        return null;
    }

    private <T extends ListAdapter & Filterable> void updateText(Object selectedItem) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.setText(this.convertSelectionToString(selectedItem), false);
        } else {
            ListAdapter adapter = this.getAdapter();
            this.setAdapter(null);
            this.setText(this.convertSelectionToString(selectedItem));
            this.setAdapter(adapter);
        }
    }
}

