/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.RelativeCornerSize;

class RadialViewGroup
extends ConstraintLayout {
    private static final String SKIP_TAG = "skip";
    private final Runnable updateLayoutParametersRunnable;
    private int radius;
    private MaterialShapeDrawable background;

    public RadialViewGroup(@NonNull Context context) {
        this(context, null);
    }

    public RadialViewGroup(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RadialViewGroup(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.material_radial_view_group, (ViewGroup)this);
        ViewCompat.setBackground((View)this, (Drawable)this.createBackground());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RadialViewGroup, defStyleAttr, 0);
        this.radius = a.getDimensionPixelSize(R.styleable.RadialViewGroup_materialCircleRadius, 0);
        this.updateLayoutParametersRunnable = new Runnable(){

            @Override
            public void run() {
                RadialViewGroup.this.updateLayoutParams();
            }
        };
        a.recycle();
    }

    private Drawable createBackground() {
        this.background = new MaterialShapeDrawable();
        this.background.setCornerSize(new RelativeCornerSize(0.5f));
        this.background.setFillColor(ColorStateList.valueOf((int)-1));
        return this.background;
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.background.setFillColor(ColorStateList.valueOf((int)color2));
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (child.getId() == -1) {
            child.setId(ViewCompat.generateViewId());
        }
        this.updateLayoutParamsAsync();
    }

    public void onViewRemoved(View view) {
        super.onViewRemoved(view);
        this.updateLayoutParamsAsync();
    }

    private void updateLayoutParamsAsync() {
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.removeCallbacks(this.updateLayoutParametersRunnable);
            handler.post(this.updateLayoutParametersRunnable);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.updateLayoutParams();
    }

    protected void updateLayoutParams() {
        int skippedChildren = 1;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childAt = this.getChildAt(i);
            if (!RadialViewGroup.shouldSkipView(childAt)) continue;
            ++skippedChildren;
        }
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        float currentAngle = 0.0f;
        for (int i = 0; i < childCount; ++i) {
            View childAt = this.getChildAt(i);
            if (childAt.getId() == R.id.circle_center || RadialViewGroup.shouldSkipView(childAt)) continue;
            constraintSet.constrainCircle(childAt.getId(), R.id.circle_center, this.radius, currentAngle);
            currentAngle += 360.0f / (float)(childCount - skippedChildren);
        }
        constraintSet.applyTo((ConstraintLayout)this);
    }

    public void setRadius(@Dimension int radius) {
        this.radius = radius;
        this.updateLayoutParams();
    }

    @Dimension
    public int getRadius() {
        return this.radius;
    }

    private static boolean shouldSkipView(View child) {
        return SKIP_TAG.equals(child.getTag());
    }
}

