/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.SparseArray;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;

public class Barrier
extends ConstraintHelper {
    public static final int LEFT = 0;
    public static final int TOP = 2;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 3;
    public static final int START = 5;
    public static final int END = 6;
    private int mIndicatedType;
    private int mResolvedType;
    private androidx.constraintlayout.core.widgets.Barrier mBarrier;

    public Barrier(Context context) {
        super(context);
        super.setVisibility(8);
    }

    public Barrier(Context context, AttributeSet attrs) {
        super(context, attrs);
        super.setVisibility(8);
    }

    public Barrier(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        super.setVisibility(8);
    }

    public int getType() {
        return this.mIndicatedType;
    }

    public void setType(int type) {
        this.mIndicatedType = type;
    }

    private void updateType(ConstraintWidget widget, int type, boolean isRtl) {
        this.mResolvedType = type;
        if (Build.VERSION.SDK_INT < 17) {
            if (this.mIndicatedType == 5) {
                this.mResolvedType = 0;
            } else if (this.mIndicatedType == 6) {
                this.mResolvedType = 1;
            }
        } else if (isRtl) {
            if (this.mIndicatedType == 5) {
                this.mResolvedType = 1;
            } else if (this.mIndicatedType == 6) {
                this.mResolvedType = 0;
            }
        } else if (this.mIndicatedType == 5) {
            this.mResolvedType = 0;
        } else if (this.mIndicatedType == 6) {
            this.mResolvedType = 1;
        }
        if (widget instanceof androidx.constraintlayout.core.widgets.Barrier) {
            androidx.constraintlayout.core.widgets.Barrier barrier = (androidx.constraintlayout.core.widgets.Barrier)widget;
            barrier.setBarrierType(this.mResolvedType);
        }
    }

    @Override
    public void resolveRtl(ConstraintWidget widget, boolean isRtl) {
        this.updateType(widget, this.mIndicatedType, isRtl);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        this.mBarrier = new androidx.constraintlayout.core.widgets.Barrier();
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.ConstraintLayout_Layout_barrierDirection) {
                    this.setType(a.getInt(attr2, 0));
                    continue;
                }
                if (attr2 == R.styleable.ConstraintLayout_Layout_barrierAllowsGoneWidgets) {
                    this.mBarrier.setAllowsGoneWidget(a.getBoolean(attr2, true));
                    continue;
                }
                if (attr2 != R.styleable.ConstraintLayout_Layout_barrierMargin) continue;
                int margin = a.getDimensionPixelSize(attr2, 0);
                this.mBarrier.setMargin(margin);
            }
            a.recycle();
        }
        this.mHelperWidget = this.mBarrier;
        this.validateParams();
    }

    public void setAllowsGoneWidget(boolean supportGone) {
        this.mBarrier.setAllowsGoneWidget(supportGone);
    }

    @Deprecated
    public boolean allowsGoneWidget() {
        return this.mBarrier.getAllowsGoneWidget();
    }

    public boolean getAllowsGoneWidget() {
        return this.mBarrier.getAllowsGoneWidget();
    }

    public void setDpMargin(int margin) {
        float density = this.getResources().getDisplayMetrics().density;
        int px = (int)(0.5f + (float)margin * density);
        this.mBarrier.setMargin(px);
    }

    public int getMargin() {
        return this.mBarrier.getMargin();
    }

    public void setMargin(int margin) {
        this.mBarrier.setMargin(margin);
    }

    @Override
    public void loadParameters(ConstraintSet.Constraint constraint, HelperWidget child, ConstraintLayout.LayoutParams layoutParams, SparseArray<ConstraintWidget> mapIdToWidget) {
        super.loadParameters(constraint, child, layoutParams, mapIdToWidget);
        if (child instanceof androidx.constraintlayout.core.widgets.Barrier) {
            androidx.constraintlayout.core.widgets.Barrier barrier = (androidx.constraintlayout.core.widgets.Barrier)child;
            ConstraintWidgetContainer container = (ConstraintWidgetContainer)child.getParent();
            boolean isRtl = container.isRtl();
            this.updateType((ConstraintWidget)barrier, constraint.layout.mBarrierDirection, isRtl);
            barrier.setAllowsGoneWidget(constraint.layout.mBarrierAllowsGoneWidgets);
            barrier.setMargin(constraint.layout.mBarrierMargin);
        }
    }
}

