/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.MediaDescription;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.RemoteControlClient;
import android.media.VolumeProvider;
import android.media.session.MediaSession;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.IMediaControllerCallback;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.ParcelableVolumeInfo;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.BundleCompat;
import androidx.media.MediaSessionManager;
import androidx.media.VolumeProviderCompat;
import androidx.media.session.MediaButtonReceiver;
import androidx.versionedparcelable.ParcelUtils;
import androidx.versionedparcelable.VersionedParcelable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MediaSessionCompat {
    static final String TAG = "MediaSessionCompat";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int PENDING_INTENT_FLAG_MUTABLE = Build.VERSION.CODENAME.equals("S") ? 0x2000000 : 0;
    private final MediaSessionImpl mImpl;
    private final MediaControllerCompat mController;
    private final ArrayList<OnActiveChangeListener> mActiveListeners = new ArrayList();
    @Deprecated
    public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    @Deprecated
    public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    public static final int FLAG_HANDLES_QUEUE_COMMANDS = 4;
    public static final String ACTION_FLAG_AS_INAPPROPRIATE = "android.support.v4.media.session.action.FLAG_AS_INAPPROPRIATE";
    public static final String ACTION_SKIP_AD = "android.support.v4.media.session.action.SKIP_AD";
    public static final String ACTION_FOLLOW = "android.support.v4.media.session.action.FOLLOW";
    public static final String ACTION_UNFOLLOW = "android.support.v4.media.session.action.UNFOLLOW";
    public static final String ARGUMENT_MEDIA_ATTRIBUTE = "android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE";
    public static final String ARGUMENT_MEDIA_ATTRIBUTE_VALUE = "android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE_VALUE";
    public static final int MEDIA_ATTRIBUTE_ARTIST = 0;
    public static final int MEDIA_ATTRIBUTE_ALBUM = 1;
    public static final int MEDIA_ATTRIBUTE_PLAYLIST = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_PLAY_FROM_URI = "android.support.v4.media.session.action.PLAY_FROM_URI";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_PREPARE = "android.support.v4.media.session.action.PREPARE";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_PREPARE_FROM_MEDIA_ID = "android.support.v4.media.session.action.PREPARE_FROM_MEDIA_ID";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_PREPARE_FROM_SEARCH = "android.support.v4.media.session.action.PREPARE_FROM_SEARCH";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_PREPARE_FROM_URI = "android.support.v4.media.session.action.PREPARE_FROM_URI";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_SET_CAPTIONING_ENABLED = "android.support.v4.media.session.action.SET_CAPTIONING_ENABLED";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_SET_REPEAT_MODE = "android.support.v4.media.session.action.SET_REPEAT_MODE";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_SET_SHUFFLE_MODE = "android.support.v4.media.session.action.SET_SHUFFLE_MODE";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_SET_RATING = "android.support.v4.media.session.action.SET_RATING";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_SET_PLAYBACK_SPEED = "android.support.v4.media.session.action.SET_PLAYBACK_SPEED";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_MEDIA_ID = "android.support.v4.media.session.action.ARGUMENT_MEDIA_ID";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_QUERY = "android.support.v4.media.session.action.ARGUMENT_QUERY";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_URI = "android.support.v4.media.session.action.ARGUMENT_URI";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_RATING = "android.support.v4.media.session.action.ARGUMENT_RATING";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_PLAYBACK_SPEED = "android.support.v4.media.session.action.ARGUMENT_PLAYBACK_SPEED";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_EXTRAS = "android.support.v4.media.session.action.ARGUMENT_EXTRAS";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_CAPTIONING_ENABLED = "android.support.v4.media.session.action.ARGUMENT_CAPTIONING_ENABLED";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_REPEAT_MODE = "android.support.v4.media.session.action.ARGUMENT_REPEAT_MODE";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_ARGUMENT_SHUFFLE_MODE = "android.support.v4.media.session.action.ARGUMENT_SHUFFLE_MODE";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String KEY_TOKEN = "android.support.v4.media.session.TOKEN";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String KEY_EXTRA_BINDER = "android.support.v4.media.session.EXTRA_BINDER";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String KEY_SESSION2_TOKEN = "android.support.v4.media.session.SESSION_TOKEN2";
    private static final int MAX_BITMAP_SIZE_IN_DP = 320;
    private static final String DATA_CALLING_PACKAGE = "data_calling_pkg";
    private static final String DATA_CALLING_PID = "data_calling_pid";
    private static final String DATA_CALLING_UID = "data_calling_uid";
    private static final String DATA_EXTRAS = "data_extras";
    static int sMaxBitmapSize;

    public MediaSessionCompat(@NonNull Context context, @NonNull String tag) {
        this(context, tag, null, null);
    }

    public MediaSessionCompat(@NonNull Context context, @NonNull String tag, @Nullable ComponentName mbrComponent, @Nullable PendingIntent mbrIntent) {
        this(context, tag, mbrComponent, mbrIntent, null);
    }

    public MediaSessionCompat(@NonNull Context context, @NonNull String tag, @Nullable ComponentName mbrComponent, @Nullable PendingIntent mbrIntent, @Nullable Bundle sessionInfo) {
        this(context, tag, mbrComponent, mbrIntent, sessionInfo, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @SuppressLint(value={"WrongConstant"})
    public MediaSessionCompat(@NonNull Context context, @NonNull String tag, @Nullable ComponentName mbrComponent, @Nullable PendingIntent mbrIntent, @Nullable Bundle sessionInfo, @Nullable VersionedParcelable session2Token) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new IllegalArgumentException("tag must not be null or empty");
        }
        if (mbrComponent == null && (mbrComponent = MediaButtonReceiver.getMediaButtonReceiverComponent(context)) == null) {
            Log.w((String)TAG, (String)"Couldn't find a unique registered media button receiver in the given context.");
        }
        if (mbrComponent != null && mbrIntent == null) {
            Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
            mediaButtonIntent.setComponent(mbrComponent);
            mbrIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)mediaButtonIntent, (int)PENDING_INTENT_FLAG_MUTABLE);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mImpl = Build.VERSION.SDK_INT >= 29 ? new MediaSessionImplApi29(context, tag, session2Token, sessionInfo) : (Build.VERSION.SDK_INT >= 28 ? new MediaSessionImplApi28(context, tag, session2Token, sessionInfo) : (Build.VERSION.SDK_INT >= 22 ? new MediaSessionImplApi22(context, tag, session2Token, sessionInfo) : new MediaSessionImplApi21(context, tag, session2Token, sessionInfo)));
            Handler handler = new Handler(Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper());
            this.setCallback(new Callback(){}, handler);
            this.mImpl.setMediaButtonReceiver(mbrIntent);
        } else {
            this.mImpl = Build.VERSION.SDK_INT >= 19 ? new MediaSessionImplApi19(context, tag, mbrComponent, mbrIntent, session2Token, sessionInfo) : (Build.VERSION.SDK_INT >= 18 ? new MediaSessionImplApi18(context, tag, mbrComponent, mbrIntent, session2Token, sessionInfo) : new MediaSessionImplBase(context, tag, mbrComponent, mbrIntent, session2Token, sessionInfo));
        }
        this.mController = new MediaControllerCompat(context, this);
        if (sMaxBitmapSize == 0) {
            sMaxBitmapSize = (int)(TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
        }
    }

    private MediaSessionCompat(Context context, MediaSessionImpl impl) {
        this.mImpl = impl;
        this.mController = new MediaControllerCompat(context, this);
    }

    public void setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    public void setCallback(Callback callback, Handler handler) {
        if (callback == null) {
            this.mImpl.setCallback(null, null);
        } else {
            this.mImpl.setCallback(callback, handler != null ? handler : new Handler());
        }
    }

    public void setSessionActivity(PendingIntent pi) {
        this.mImpl.setSessionActivity(pi);
    }

    public void setMediaButtonReceiver(PendingIntent mbr) {
        this.mImpl.setMediaButtonReceiver(mbr);
    }

    public void setFlags(int flags) {
        this.mImpl.setFlags(flags);
    }

    public void setPlaybackToLocal(int stream) {
        this.mImpl.setPlaybackToLocal(stream);
    }

    public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        this.mImpl.setPlaybackToRemote(volumeProvider);
    }

    public void setActive(boolean active) {
        this.mImpl.setActive(active);
        for (OnActiveChangeListener listener : this.mActiveListeners) {
            listener.onActiveChanged();
        }
    }

    public boolean isActive() {
        return this.mImpl.isActive();
    }

    public void sendSessionEvent(String event, Bundle extras) {
        if (TextUtils.isEmpty((CharSequence)event)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        this.mImpl.sendSessionEvent(event, extras);
    }

    public void release() {
        this.mImpl.release();
    }

    public Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public MediaControllerCompat getController() {
        return this.mController;
    }

    public void setPlaybackState(PlaybackStateCompat state) {
        this.mImpl.setPlaybackState(state);
    }

    public void setMetadata(MediaMetadataCompat metadata) {
        this.mImpl.setMetadata(metadata);
    }

    public void setQueue(List<QueueItem> queue) {
        if (queue != null) {
            HashSet<Long> set = new HashSet<Long>();
            for (QueueItem item : queue) {
                if (item == null) {
                    throw new IllegalArgumentException("queue shouldn't have null items");
                }
                if (set.contains(item.getQueueId())) {
                    Log.e((String)TAG, (String)("Found duplicate queue id: " + item.getQueueId()), (Throwable)new IllegalArgumentException("id of each queue item should be unique"));
                }
                set.add(item.getQueueId());
            }
        }
        this.mImpl.setQueue(queue);
    }

    public void setQueueTitle(CharSequence title) {
        this.mImpl.setQueueTitle(title);
    }

    public void setRatingType(int type) {
        this.mImpl.setRatingType(type);
    }

    public void setCaptioningEnabled(boolean enabled) {
        this.mImpl.setCaptioningEnabled(enabled);
    }

    public void setRepeatMode(int repeatMode) {
        this.mImpl.setRepeatMode(repeatMode);
    }

    public void setShuffleMode(int shuffleMode) {
        this.mImpl.setShuffleMode(shuffleMode);
    }

    public void setExtras(Bundle extras) {
        this.mImpl.setExtras(extras);
    }

    public Object getMediaSession() {
        return this.mImpl.getMediaSession();
    }

    public Object getRemoteControlClient() {
        return this.mImpl.getRemoteControlClient();
    }

    @NonNull
    public final MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
        return this.mImpl.getCurrentControllerInfo();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getCallingPackage() {
        return this.mImpl.getCallingPackage();
    }

    public void addOnActiveChangeListener(OnActiveChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener may not be null");
        }
        this.mActiveListeners.add(listener);
    }

    public void removeOnActiveChangeListener(OnActiveChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener may not be null");
        }
        this.mActiveListeners.remove(listener);
    }

    public static MediaSessionCompat fromMediaSession(Context context, Object mediaSession) {
        if (Build.VERSION.SDK_INT < 21 || context == null || mediaSession == null) {
            return null;
        }
        MediaSessionImplApi21 impl = Build.VERSION.SDK_INT >= 29 ? new MediaSessionImplApi29(mediaSession) : (Build.VERSION.SDK_INT >= 28 ? new MediaSessionImplApi28(mediaSession) : new MediaSessionImplApi21(mediaSession));
        return new MediaSessionCompat(context, impl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void ensureClassLoader(@Nullable Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MediaSessionCompat.class.getClassLoader());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static Bundle unparcelWithClassLoader(@Nullable Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        MediaSessionCompat.ensureClassLoader(bundle);
        try {
            bundle.isEmpty();
            return bundle;
        }
        catch (BadParcelableException e) {
            Log.e((String)TAG, (String)"Could not unparcel the data.");
            return null;
        }
    }

    static PlaybackStateCompat getStateWithUpdatedPosition(PlaybackStateCompat state, MediaMetadataCompat metadata) {
        long updateTime;
        if (state == null || state.getPosition() == -1L) {
            return state;
        }
        if ((state.getState() == 3 || state.getState() == 4 || state.getState() == 5) && (updateTime = state.getLastPositionUpdateTime()) > 0L) {
            long currentTime = SystemClock.elapsedRealtime();
            long position = (long)(state.getPlaybackSpeed() * (float)(currentTime - updateTime)) + state.getPosition();
            long duration = -1L;
            if (metadata != null && metadata.containsKey("android.media.metadata.DURATION")) {
                duration = metadata.getLong("android.media.metadata.DURATION");
            }
            if (duration >= 0L && position > duration) {
                position = duration;
            } else if (position < 0L) {
                position = 0L;
            }
            return new PlaybackStateCompat.Builder(state).setState(state.getState(), position, state.getPlaybackSpeed(), currentTime).build();
        }
        return state;
    }

    @RequiresApi(value=29)
    static class MediaSessionImplApi29
    extends MediaSessionImplApi28 {
        MediaSessionImplApi29(Context context, String tag, VersionedParcelable session2Token, Bundle sessionInfo) {
            super(context, tag, session2Token, sessionInfo);
        }

        MediaSessionImplApi29(Object mediaSession) {
            super(mediaSession);
            this.mSessionInfo = ((MediaSession)mediaSession).getController().getSessionInfo();
        }

        @Override
        public MediaSession createFwkMediaSession(Context context, String tag, Bundle sessionInfo) {
            return new MediaSession(context, tag, sessionInfo);
        }
    }

    @RequiresApi(value=28)
    static class MediaSessionImplApi28
    extends MediaSessionImplApi22 {
        MediaSessionImplApi28(Context context, String tag, VersionedParcelable session2Token, Bundle sessionInfo) {
            super(context, tag, session2Token, sessionInfo);
        }

        MediaSessionImplApi28(Object mediaSession) {
            super(mediaSession);
        }

        @Override
        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        }

        @Override
        @NonNull
        public final MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
            MediaSessionManager.RemoteUserInfo info = this.mSessionFwk.getCurrentControllerInfo();
            return new MediaSessionManager.RemoteUserInfo(info);
        }
    }

    @RequiresApi(value=22)
    static class MediaSessionImplApi22
    extends MediaSessionImplApi21 {
        MediaSessionImplApi22(Context context, String tag, VersionedParcelable session2Token, Bundle sessionInfo) {
            super(context, tag, session2Token, sessionInfo);
        }

        MediaSessionImplApi22(Object mediaSession) {
            super(mediaSession);
        }

        @Override
        public void setRatingType(int type) {
            this.mSessionFwk.setRatingType(type);
        }
    }

    @RequiresApi(value=21)
    static class MediaSessionImplApi21
    implements MediaSessionImpl {
        final MediaSession mSessionFwk;
        final Token mToken;
        final Object mLock = new Object();
        Bundle mSessionInfo;
        boolean mDestroyed = false;
        final RemoteCallbackList<IMediaControllerCallback> mExtraControllerCallbacks = new RemoteCallbackList();
        PlaybackStateCompat mPlaybackState;
        List<QueueItem> mQueue;
        MediaMetadataCompat mMetadata;
        int mRatingType;
        boolean mCaptioningEnabled;
        int mRepeatMode;
        int mShuffleMode;
        @GuardedBy(value="mLock")
        Callback mCallback;
        @GuardedBy(value="mLock")
        MediaSessionManager.RemoteUserInfo mRemoteUserInfo;

        MediaSessionImplApi21(Context context, String tag, VersionedParcelable session2Token, Bundle sessionInfo) {
            this.mSessionFwk = this.createFwkMediaSession(context, tag, sessionInfo);
            this.mToken = new Token(this.mSessionFwk.getSessionToken(), new ExtraSession(), session2Token);
            this.mSessionInfo = sessionInfo;
            this.setFlags(3);
        }

        MediaSessionImplApi21(Object mediaSession) {
            if (!(mediaSession instanceof MediaSession)) {
                throw new IllegalArgumentException("mediaSession is not a valid MediaSession object");
            }
            this.mSessionFwk = (MediaSession)mediaSession;
            this.mToken = new Token(this.mSessionFwk.getSessionToken(), new ExtraSession());
            this.mSessionInfo = null;
            this.setFlags(3);
        }

        public MediaSession createFwkMediaSession(Context context, String tag, Bundle sessionInfo) {
            return new MediaSession(context, tag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCallback(Callback callback, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCallback = callback;
                this.mSessionFwk.setCallback(callback == null ? null : callback.mCallbackFwk, handler);
                if (callback != null) {
                    callback.setSessionImpl(this, handler);
                }
            }
        }

        @Override
        @SuppressLint(value={"WrongConstant"})
        public void setFlags(int flags) {
            this.mSessionFwk.setFlags(flags | 1 | 2);
        }

        @Override
        public void setPlaybackToLocal(int stream) {
            AudioAttributes.Builder bob = new AudioAttributes.Builder();
            bob.setLegacyStreamType(stream);
            this.mSessionFwk.setPlaybackToLocal(bob.build());
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
            this.mSessionFwk.setPlaybackToRemote((VolumeProvider)volumeProvider.getVolumeProvider());
        }

        @Override
        public void setActive(boolean active) {
            this.mSessionFwk.setActive(active);
        }

        @Override
        public boolean isActive() {
            return this.mSessionFwk.isActive();
        }

        @Override
        public void sendSessionEvent(String event, Bundle extras) {
            if (Build.VERSION.SDK_INT < 23) {
                int size = this.mExtraControllerCallbacks.beginBroadcast();
                for (int i = size - 1; i >= 0; --i) {
                    IMediaControllerCallback cb = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(i);
                    try {
                        cb.onEvent(event, extras);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mExtraControllerCallbacks.finishBroadcast();
            }
            this.mSessionFwk.sendSessionEvent(event, extras);
        }

        @Override
        public void release() {
            this.mDestroyed = true;
            this.mExtraControllerCallbacks.kill();
            if (Build.VERSION.SDK_INT == 27) {
                try {
                    Field callback = this.mSessionFwk.getClass().getDeclaredField("mCallback");
                    callback.setAccessible(true);
                    Handler handler = (Handler)callback.get(this.mSessionFwk);
                    if (handler != null) {
                        handler.removeCallbacksAndMessages(null);
                    }
                }
                catch (Exception e) {
                    Log.w((String)MediaSessionCompat.TAG, (String)"Exception happened while accessing MediaSession.mCallback.", (Throwable)e);
                }
            }
            this.mSessionFwk.setCallback(null);
            this.mSessionFwk.release();
        }

        @Override
        public Token getSessionToken() {
            return this.mToken;
        }

        @Override
        public void setPlaybackState(PlaybackStateCompat state) {
            this.mPlaybackState = state;
            int size = this.mExtraControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onPlaybackStateChanged(state);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mExtraControllerCallbacks.finishBroadcast();
            this.mSessionFwk.setPlaybackState(state == null ? null : (PlaybackState)state.getPlaybackState());
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            return this.mPlaybackState;
        }

        @Override
        public void setMetadata(MediaMetadataCompat metadata) {
            this.mMetadata = metadata;
            this.mSessionFwk.setMetadata(metadata == null ? null : (MediaMetadata)metadata.getMediaMetadata());
        }

        @Override
        public void setSessionActivity(PendingIntent pi) {
            this.mSessionFwk.setSessionActivity(pi);
        }

        @Override
        public void setMediaButtonReceiver(PendingIntent mbr) {
            this.mSessionFwk.setMediaButtonReceiver(mbr);
        }

        @Override
        public void setQueue(List<QueueItem> queue) {
            this.mQueue = queue;
            if (queue == null) {
                this.mSessionFwk.setQueue(null);
                return;
            }
            ArrayList<MediaSession.QueueItem> queueItemFwks = new ArrayList<MediaSession.QueueItem>();
            for (QueueItem item : queue) {
                queueItemFwks.add((MediaSession.QueueItem)item.getQueueItem());
            }
            this.mSessionFwk.setQueue(queueItemFwks);
        }

        @Override
        public void setQueueTitle(CharSequence title) {
            this.mSessionFwk.setQueueTitle(title);
        }

        @Override
        public void setRatingType(int type) {
            this.mRatingType = type;
        }

        @Override
        public void setCaptioningEnabled(boolean enabled) {
            if (this.mCaptioningEnabled != enabled) {
                this.mCaptioningEnabled = enabled;
                int size = this.mExtraControllerCallbacks.beginBroadcast();
                for (int i = size - 1; i >= 0; --i) {
                    IMediaControllerCallback cb = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(i);
                    try {
                        cb.onCaptioningEnabledChanged(enabled);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mExtraControllerCallbacks.finishBroadcast();
            }
        }

        @Override
        public void setRepeatMode(int repeatMode) {
            if (this.mRepeatMode != repeatMode) {
                this.mRepeatMode = repeatMode;
                int size = this.mExtraControllerCallbacks.beginBroadcast();
                for (int i = size - 1; i >= 0; --i) {
                    IMediaControllerCallback cb = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(i);
                    try {
                        cb.onRepeatModeChanged(repeatMode);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mExtraControllerCallbacks.finishBroadcast();
            }
        }

        @Override
        public void setShuffleMode(int shuffleMode) {
            if (this.mShuffleMode != shuffleMode) {
                this.mShuffleMode = shuffleMode;
                int size = this.mExtraControllerCallbacks.beginBroadcast();
                for (int i = size - 1; i >= 0; --i) {
                    IMediaControllerCallback cb = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(i);
                    try {
                        cb.onShuffleModeChanged(shuffleMode);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mExtraControllerCallbacks.finishBroadcast();
            }
        }

        @Override
        public void setExtras(Bundle extras) {
            this.mSessionFwk.setExtras(extras);
        }

        @Override
        public Object getMediaSession() {
            return this.mSessionFwk;
        }

        @Override
        public Object getRemoteControlClient() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteUserInfo = remoteUserInfo;
            }
        }

        @Override
        public String getCallingPackage() {
            if (Build.VERSION.SDK_INT < 24) {
                return null;
            }
            try {
                Method getCallingPackageMethod = this.mSessionFwk.getClass().getMethod("getCallingPackage", new Class[0]);
                return (String)getCallingPackageMethod.invoke((Object)this.mSessionFwk, new Object[0]);
            }
            catch (Exception e) {
                Log.e((String)MediaSessionCompat.TAG, (String)"Cannot execute MediaSession.getCallingPackage()", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mRemoteUserInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Callback getCallback() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mCallback;
            }
        }

        class ExtraSession
        extends IMediaSession.Stub {
            ExtraSession() {
            }

            @Override
            public void sendCommand(String command, Bundle args, ResultReceiverWrapper cb) {
                throw new AssertionError();
            }

            @Override
            public boolean sendMediaButton(KeyEvent mediaButton) {
                throw new AssertionError();
            }

            @Override
            public void registerCallbackListener(IMediaControllerCallback cb) {
                if (!MediaSessionImplApi21.this.mDestroyed) {
                    MediaSessionManager.RemoteUserInfo info = new MediaSessionManager.RemoteUserInfo("android.media.session.MediaController", ExtraSession.getCallingPid(), ExtraSession.getCallingUid());
                    MediaSessionImplApi21.this.mExtraControllerCallbacks.register((IInterface)cb, (Object)info);
                }
            }

            @Override
            public void unregisterCallbackListener(IMediaControllerCallback cb) {
                MediaSessionImplApi21.this.mExtraControllerCallbacks.unregister((IInterface)cb);
            }

            @Override
            public String getPackageName() {
                throw new AssertionError();
            }

            @Override
            public Bundle getSessionInfo() {
                return MediaSessionImplApi21.this.mSessionInfo == null ? null : new Bundle(MediaSessionImplApi21.this.mSessionInfo);
            }

            @Override
            public String getTag() {
                throw new AssertionError();
            }

            @Override
            public PendingIntent getLaunchPendingIntent() {
                throw new AssertionError();
            }

            @Override
            public long getFlags() {
                throw new AssertionError();
            }

            @Override
            public ParcelableVolumeInfo getVolumeAttributes() {
                throw new AssertionError();
            }

            @Override
            public void adjustVolume(int direction, int flags, String packageName) {
                throw new AssertionError();
            }

            @Override
            public void setVolumeTo(int value, int flags, String packageName) {
                throw new AssertionError();
            }

            @Override
            public void prepare() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void prepareFromMediaId(String mediaId, Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void prepareFromSearch(String query, Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void prepareFromUri(Uri uri, Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void play() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void playFromMediaId(String mediaId, Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void playFromSearch(String query, Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void playFromUri(Uri uri, Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void skipToQueueItem(long id2) {
                throw new AssertionError();
            }

            @Override
            public void pause() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void stop() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void next() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void previous() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void fastForward() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void rewind() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void seekTo(long pos) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void rate(RatingCompat rating) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void rateWithExtras(RatingCompat rating, Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void setPlaybackSpeed(float speed) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void setCaptioningEnabled(boolean enabled) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void setRepeatMode(int repeatMode) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void setShuffleModeEnabledRemoved(boolean enabled) throws RemoteException {
            }

            @Override
            public void setShuffleMode(int shuffleMode) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void sendCustomAction(String action, Bundle args) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public MediaMetadataCompat getMetadata() {
                throw new AssertionError();
            }

            @Override
            public PlaybackStateCompat getPlaybackState() {
                return MediaSessionCompat.getStateWithUpdatedPosition(MediaSessionImplApi21.this.mPlaybackState, MediaSessionImplApi21.this.mMetadata);
            }

            @Override
            public List<QueueItem> getQueue() {
                return null;
            }

            @Override
            public void addQueueItem(MediaDescriptionCompat descriptionCompat) {
                throw new AssertionError();
            }

            @Override
            public void addQueueItemAt(MediaDescriptionCompat descriptionCompat, int index) {
                throw new AssertionError();
            }

            @Override
            public void removeQueueItem(MediaDescriptionCompat description) {
                throw new AssertionError();
            }

            @Override
            public void removeQueueItemAt(int index) {
                throw new AssertionError();
            }

            @Override
            public CharSequence getQueueTitle() {
                throw new AssertionError();
            }

            @Override
            public Bundle getExtras() {
                throw new AssertionError();
            }

            @Override
            public int getRatingType() {
                return MediaSessionImplApi21.this.mRatingType;
            }

            @Override
            public boolean isCaptioningEnabled() {
                return MediaSessionImplApi21.this.mCaptioningEnabled;
            }

            @Override
            public int getRepeatMode() {
                return MediaSessionImplApi21.this.mRepeatMode;
            }

            @Override
            public boolean isShuffleModeEnabledRemoved() {
                return false;
            }

            @Override
            public int getShuffleMode() {
                return MediaSessionImplApi21.this.mShuffleMode;
            }

            @Override
            public boolean isTransportControlEnabled() {
                throw new AssertionError();
            }
        }
    }

    @RequiresApi(value=19)
    static class MediaSessionImplApi19
    extends MediaSessionImplApi18 {
        MediaSessionImplApi19(Context context, String tag, ComponentName mbrComponent, PendingIntent mbrIntent, VersionedParcelable session2Token, Bundle sessionInfo) {
            super(context, tag, mbrComponent, mbrIntent, session2Token, sessionInfo);
        }

        @Override
        public void setCallback(Callback callback, Handler handler) {
            super.setCallback(callback, handler);
            if (callback == null) {
                this.mRcc.setMetadataUpdateListener(null);
            } else {
                RemoteControlClient.OnMetadataUpdateListener listener = new RemoteControlClient.OnMetadataUpdateListener(){

                    public void onMetadataUpdate(int key, Object newValue) {
                        if (key == 0x10000001 && newValue instanceof Rating) {
                            this.postToHandler(19, -1, -1, RatingCompat.fromRating(newValue), null);
                        }
                    }
                };
                this.mRcc.setMetadataUpdateListener(listener);
            }
        }

        @Override
        int getRccTransportControlFlagsFromActions(long actions) {
            int transportControlFlags = super.getRccTransportControlFlagsFromActions(actions);
            if ((actions & 0x80L) != 0L) {
                transportControlFlags |= 0x200;
            }
            return transportControlFlags;
        }

        @Override
        RemoteControlClient.MetadataEditor buildRccMetadata(Bundle metadata) {
            long actions;
            RemoteControlClient.MetadataEditor editor = super.buildRccMetadata(metadata);
            long l = actions = this.mState == null ? 0L : this.mState.getActions();
            if ((actions & 0x80L) != 0L) {
                editor.addEditableKey(0x10000001);
            }
            if (metadata == null) {
                return editor;
            }
            if (metadata.containsKey("android.media.metadata.YEAR")) {
                editor.putLong(8, metadata.getLong("android.media.metadata.YEAR"));
            }
            if (metadata.containsKey("android.media.metadata.RATING")) {
                editor.putObject(101, (Object)metadata.getParcelable("android.media.metadata.RATING"));
            }
            if (metadata.containsKey("android.media.metadata.USER_RATING")) {
                editor.putObject(0x10000001, (Object)metadata.getParcelable("android.media.metadata.USER_RATING"));
            }
            return editor;
        }
    }

    @RequiresApi(value=18)
    static class MediaSessionImplApi18
    extends MediaSessionImplBase {
        private static boolean sIsMbrPendingIntentSupported = true;

        MediaSessionImplApi18(Context context, String tag, ComponentName mbrComponent, PendingIntent mbrIntent, VersionedParcelable session2Token, Bundle sessionInfo) {
            super(context, tag, mbrComponent, mbrIntent, session2Token, sessionInfo);
        }

        @Override
        public void setCallback(Callback callback, Handler handler) {
            super.setCallback(callback, handler);
            if (callback == null) {
                this.mRcc.setPlaybackPositionUpdateListener(null);
            } else {
                RemoteControlClient.OnPlaybackPositionUpdateListener listener = new RemoteControlClient.OnPlaybackPositionUpdateListener(){

                    public void onPlaybackPositionUpdate(long newPositionMs) {
                        this.postToHandler(18, -1, -1, newPositionMs, null);
                    }
                };
                this.mRcc.setPlaybackPositionUpdateListener(listener);
            }
        }

        @Override
        void setRccState(PlaybackStateCompat state) {
            long position = state.getPosition();
            float speed = state.getPlaybackSpeed();
            long updateTime = state.getLastPositionUpdateTime();
            long currTime = SystemClock.elapsedRealtime();
            if (state.getState() == 3 && position > 0L) {
                long diff = 0L;
                if (updateTime > 0L) {
                    diff = currTime - updateTime;
                    if (speed > 0.0f && speed != 1.0f) {
                        diff = (long)((float)diff * speed);
                    }
                }
                position += diff;
            }
            this.mRcc.setPlaybackState(this.getRccStateFromState(state.getState()), position, speed);
        }

        @Override
        int getRccTransportControlFlagsFromActions(long actions) {
            int transportControlFlags = super.getRccTransportControlFlagsFromActions(actions);
            if ((actions & 0x100L) != 0L) {
                transportControlFlags |= 0x100;
            }
            return transportControlFlags;
        }

        @Override
        void registerMediaButtonEventReceiver(PendingIntent mbrIntent, ComponentName mbrComponent) {
            if (sIsMbrPendingIntentSupported) {
                try {
                    this.mAudioManager.registerMediaButtonEventReceiver(mbrIntent);
                }
                catch (NullPointerException e) {
                    Log.w((String)MediaSessionCompat.TAG, (String)"Unable to register media button event receiver with PendingIntent, falling back to ComponentName.");
                    sIsMbrPendingIntentSupported = false;
                }
            }
            if (!sIsMbrPendingIntentSupported) {
                super.registerMediaButtonEventReceiver(mbrIntent, mbrComponent);
            }
        }

        @Override
        void unregisterMediaButtonEventReceiver(PendingIntent mbrIntent, ComponentName mbrComponent) {
            if (sIsMbrPendingIntentSupported) {
                this.mAudioManager.unregisterMediaButtonEventReceiver(mbrIntent);
            } else {
                super.unregisterMediaButtonEventReceiver(mbrIntent, mbrComponent);
            }
        }
    }

    static class MediaSessionImplBase
    implements MediaSessionImpl {
        static final int RCC_PLAYSTATE_NONE = 0;
        private final Context mContext;
        private final ComponentName mMediaButtonReceiverComponentName;
        private final PendingIntent mMediaButtonReceiverIntent;
        private final MediaSessionStub mStub;
        private final Token mToken;
        final String mPackageName;
        final Bundle mSessionInfo;
        final String mTag;
        final AudioManager mAudioManager;
        final RemoteControlClient mRcc;
        final Object mLock = new Object();
        final RemoteCallbackList<IMediaControllerCallback> mControllerCallbacks = new RemoteCallbackList();
        private MessageHandler mHandler;
        boolean mDestroyed = false;
        boolean mIsActive = false;
        volatile Callback mCallback;
        private MediaSessionManager.RemoteUserInfo mRemoteUserInfo;
        int mFlags = 3;
        MediaMetadataCompat mMetadata;
        PlaybackStateCompat mState;
        PendingIntent mSessionActivity;
        List<QueueItem> mQueue;
        CharSequence mQueueTitle;
        int mRatingType;
        boolean mCaptioningEnabled;
        int mRepeatMode;
        int mShuffleMode;
        Bundle mExtras;
        int mVolumeType;
        int mLocalStream;
        VolumeProviderCompat mVolumeProvider;
        private VolumeProviderCompat.Callback mVolumeCallback = new VolumeProviderCompat.Callback(){

            @Override
            public void onVolumeChanged(VolumeProviderCompat volumeProvider) {
                if (mVolumeProvider != volumeProvider) {
                    return;
                }
                ParcelableVolumeInfo info = new ParcelableVolumeInfo(mVolumeType, mLocalStream, volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume(), volumeProvider.getCurrentVolume());
                this.sendVolumeInfoChanged(info);
            }
        };

        public MediaSessionImplBase(Context context, String tag, ComponentName mbrComponent, PendingIntent mbrIntent, VersionedParcelable session2Token, Bundle sessionInfo) {
            if (mbrComponent == null) {
                throw new IllegalArgumentException("MediaButtonReceiver component may not be null");
            }
            this.mContext = context;
            this.mPackageName = context.getPackageName();
            this.mSessionInfo = sessionInfo;
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
            this.mTag = tag;
            this.mMediaButtonReceiverComponentName = mbrComponent;
            this.mMediaButtonReceiverIntent = mbrIntent;
            this.mStub = new MediaSessionStub();
            this.mToken = new Token(this.mStub, null, session2Token);
            this.mRatingType = 0;
            this.mVolumeType = 1;
            this.mLocalStream = 3;
            this.mRcc = new RemoteControlClient(mbrIntent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCallback(Callback callback, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHandler != null) {
                    this.mHandler.removeCallbacksAndMessages(null);
                }
                MessageHandler messageHandler = this.mHandler = callback == null || handler == null ? null : new MessageHandler(handler.getLooper());
                if (this.mCallback != callback && this.mCallback != null) {
                    this.mCallback.setSessionImpl(null, null);
                }
                this.mCallback = callback;
                if (this.mCallback != null) {
                    this.mCallback.setSessionImpl(this, handler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void postToHandler(int what, int arg1, int arg2, Object obj, Bundle extras) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHandler != null) {
                    Message msg = this.mHandler.obtainMessage(what, arg1, arg2, obj);
                    Bundle data = new Bundle();
                    int uid = Binder.getCallingUid();
                    data.putInt(MediaSessionCompat.DATA_CALLING_UID, uid);
                    data.putString(MediaSessionCompat.DATA_CALLING_PACKAGE, this.getPackageNameForUid(uid));
                    int pid = Binder.getCallingPid();
                    if (pid > 0) {
                        data.putInt(MediaSessionCompat.DATA_CALLING_PID, pid);
                    } else {
                        data.putInt(MediaSessionCompat.DATA_CALLING_PID, -1);
                    }
                    if (extras != null) {
                        data.putBundle(MediaSessionCompat.DATA_EXTRAS, extras);
                    }
                    msg.setData(data);
                    msg.sendToTarget();
                }
            }
        }

        String getPackageNameForUid(int uid) {
            String result = this.mContext.getPackageManager().getNameForUid(uid);
            if (TextUtils.isEmpty((CharSequence)result)) {
                result = "android.media.session.MediaController";
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFlags(int flags) {
            Object object = this.mLock;
            synchronized (object) {
                this.mFlags = flags | 1 | 2;
            }
        }

        @Override
        public void setPlaybackToLocal(int stream) {
            if (this.mVolumeProvider != null) {
                this.mVolumeProvider.setCallback(null);
            }
            this.mLocalStream = stream;
            this.mVolumeType = 1;
            ParcelableVolumeInfo info = new ParcelableVolumeInfo(this.mVolumeType, this.mLocalStream, 2, this.mAudioManager.getStreamMaxVolume(this.mLocalStream), this.mAudioManager.getStreamVolume(this.mLocalStream));
            this.sendVolumeInfoChanged(info);
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
            if (volumeProvider == null) {
                throw new IllegalArgumentException("volumeProvider may not be null");
            }
            if (this.mVolumeProvider != null) {
                this.mVolumeProvider.setCallback(null);
            }
            this.mVolumeType = 2;
            this.mVolumeProvider = volumeProvider;
            ParcelableVolumeInfo info = new ParcelableVolumeInfo(this.mVolumeType, this.mLocalStream, this.mVolumeProvider.getVolumeControl(), this.mVolumeProvider.getMaxVolume(), this.mVolumeProvider.getCurrentVolume());
            this.sendVolumeInfoChanged(info);
            volumeProvider.setCallback(this.mVolumeCallback);
        }

        @Override
        public void setActive(boolean active) {
            if (active == this.mIsActive) {
                return;
            }
            this.mIsActive = active;
            this.updateMbrAndRcc();
        }

        @Override
        public boolean isActive() {
            return this.mIsActive;
        }

        @Override
        public void sendSessionEvent(String event, Bundle extras) {
            this.sendEvent(event, extras);
        }

        @Override
        public void release() {
            this.mIsActive = false;
            this.mDestroyed = true;
            this.updateMbrAndRcc();
            this.sendSessionDestroyed();
            this.setCallback(null, null);
        }

        @Override
        public Token getSessionToken() {
            return this.mToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPlaybackState(PlaybackStateCompat state) {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = state;
            }
            this.sendState(state);
            if (!this.mIsActive) {
                return;
            }
            if (state == null) {
                this.mRcc.setPlaybackState(0);
                this.mRcc.setTransportControlFlags(0);
            } else {
                this.setRccState(state);
                this.mRcc.setTransportControlFlags(this.getRccTransportControlFlagsFromActions(state.getActions()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PlaybackStateCompat getPlaybackState() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mState;
            }
        }

        void setRccState(PlaybackStateCompat state) {
            this.mRcc.setPlaybackState(this.getRccStateFromState(state.getState()));
        }

        int getRccStateFromState(int state) {
            switch (state) {
                case 6: 
                case 8: {
                    return 8;
                }
                case 7: {
                    return 9;
                }
                case 4: {
                    return 4;
                }
                case 0: {
                    return 0;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 5: {
                    return 5;
                }
                case 9: {
                    return 7;
                }
                case 10: 
                case 11: {
                    return 6;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }

        int getRccTransportControlFlagsFromActions(long actions) {
            int transportControlFlags = 0;
            if ((actions & 1L) != 0L) {
                transportControlFlags |= 0x20;
            }
            if ((actions & 2L) != 0L) {
                transportControlFlags |= 0x10;
            }
            if ((actions & 4L) != 0L) {
                transportControlFlags |= 4;
            }
            if ((actions & 8L) != 0L) {
                transportControlFlags |= 2;
            }
            if ((actions & 0x10L) != 0L) {
                transportControlFlags |= 1;
            }
            if ((actions & 0x20L) != 0L) {
                transportControlFlags |= 0x80;
            }
            if ((actions & 0x40L) != 0L) {
                transportControlFlags |= 0x40;
            }
            if ((actions & 0x200L) != 0L) {
                transportControlFlags |= 8;
            }
            return transportControlFlags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMetadata(MediaMetadataCompat metadata) {
            if (metadata != null) {
                metadata = new MediaMetadataCompat.Builder(metadata, sMaxBitmapSize).build();
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mMetadata = metadata;
            }
            this.sendMetadata(metadata);
            if (!this.mIsActive) {
                return;
            }
            RemoteControlClient.MetadataEditor editor = this.buildRccMetadata(metadata == null ? null : metadata.getBundle());
            editor.apply();
        }

        RemoteControlClient.MetadataEditor buildRccMetadata(Bundle metadata) {
            RemoteControlClient.MetadataEditor editor = this.mRcc.editMetadata(true);
            if (metadata == null) {
                return editor;
            }
            if (metadata.containsKey("android.media.metadata.ART")) {
                Bitmap art = (Bitmap)metadata.getParcelable("android.media.metadata.ART");
                if (art != null) {
                    art = art.copy(art.getConfig(), false);
                }
                editor.putBitmap(100, art);
            } else if (metadata.containsKey("android.media.metadata.ALBUM_ART")) {
                Bitmap art = (Bitmap)metadata.getParcelable("android.media.metadata.ALBUM_ART");
                if (art != null) {
                    art = art.copy(art.getConfig(), false);
                }
                editor.putBitmap(100, art);
            }
            if (metadata.containsKey("android.media.metadata.ALBUM")) {
                editor.putString(1, metadata.getString("android.media.metadata.ALBUM"));
            }
            if (metadata.containsKey("android.media.metadata.ALBUM_ARTIST")) {
                editor.putString(13, metadata.getString("android.media.metadata.ALBUM_ARTIST"));
            }
            if (metadata.containsKey("android.media.metadata.ARTIST")) {
                editor.putString(2, metadata.getString("android.media.metadata.ARTIST"));
            }
            if (metadata.containsKey("android.media.metadata.AUTHOR")) {
                editor.putString(3, metadata.getString("android.media.metadata.AUTHOR"));
            }
            if (metadata.containsKey("android.media.metadata.COMPILATION")) {
                editor.putString(15, metadata.getString("android.media.metadata.COMPILATION"));
            }
            if (metadata.containsKey("android.media.metadata.COMPOSER")) {
                editor.putString(4, metadata.getString("android.media.metadata.COMPOSER"));
            }
            if (metadata.containsKey("android.media.metadata.DATE")) {
                editor.putString(5, metadata.getString("android.media.metadata.DATE"));
            }
            if (metadata.containsKey("android.media.metadata.DISC_NUMBER")) {
                editor.putLong(14, metadata.getLong("android.media.metadata.DISC_NUMBER"));
            }
            if (metadata.containsKey("android.media.metadata.DURATION")) {
                editor.putLong(9, metadata.getLong("android.media.metadata.DURATION"));
            }
            if (metadata.containsKey("android.media.metadata.GENRE")) {
                editor.putString(6, metadata.getString("android.media.metadata.GENRE"));
            }
            if (metadata.containsKey("android.media.metadata.TITLE")) {
                editor.putString(7, metadata.getString("android.media.metadata.TITLE"));
            }
            if (metadata.containsKey("android.media.metadata.TRACK_NUMBER")) {
                editor.putLong(0, metadata.getLong("android.media.metadata.TRACK_NUMBER"));
            }
            if (metadata.containsKey("android.media.metadata.WRITER")) {
                editor.putString(11, metadata.getString("android.media.metadata.WRITER"));
            }
            return editor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSessionActivity(PendingIntent pi) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionActivity = pi;
            }
        }

        @Override
        public void setMediaButtonReceiver(PendingIntent mbr) {
        }

        @Override
        public void setQueue(List<QueueItem> queue) {
            this.mQueue = queue;
            this.sendQueue(queue);
        }

        @Override
        public void setQueueTitle(CharSequence title) {
            this.mQueueTitle = title;
            this.sendQueueTitle(title);
        }

        @Override
        public Object getMediaSession() {
            return null;
        }

        @Override
        public Object getRemoteControlClient() {
            return null;
        }

        @Override
        public String getCallingPackage() {
            return null;
        }

        @Override
        public void setRatingType(int type) {
            this.mRatingType = type;
        }

        @Override
        public void setCaptioningEnabled(boolean enabled) {
            if (this.mCaptioningEnabled != enabled) {
                this.mCaptioningEnabled = enabled;
                this.sendCaptioningEnabled(enabled);
            }
        }

        @Override
        public void setRepeatMode(int repeatMode) {
            if (this.mRepeatMode != repeatMode) {
                this.mRepeatMode = repeatMode;
                this.sendRepeatMode(repeatMode);
            }
        }

        @Override
        public void setShuffleMode(int shuffleMode) {
            if (this.mShuffleMode != shuffleMode) {
                this.mShuffleMode = shuffleMode;
                this.sendShuffleMode(shuffleMode);
            }
        }

        @Override
        public void setExtras(Bundle extras) {
            this.mExtras = extras;
            this.sendExtras(extras);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mRemoteUserInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteUserInfo = remoteUserInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Callback getCallback() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mCallback;
            }
        }

        void updateMbrAndRcc() {
            if (this.mIsActive) {
                this.registerMediaButtonEventReceiver(this.mMediaButtonReceiverIntent, this.mMediaButtonReceiverComponentName);
                this.mAudioManager.registerRemoteControlClient(this.mRcc);
                this.setMetadata(this.mMetadata);
                this.setPlaybackState(this.mState);
            } else {
                this.unregisterMediaButtonEventReceiver(this.mMediaButtonReceiverIntent, this.mMediaButtonReceiverComponentName);
                this.mRcc.setPlaybackState(0);
                this.mAudioManager.unregisterRemoteControlClient(this.mRcc);
            }
        }

        void registerMediaButtonEventReceiver(PendingIntent mbrIntent, ComponentName mbrComponent) {
            this.mAudioManager.registerMediaButtonEventReceiver(mbrComponent);
        }

        void unregisterMediaButtonEventReceiver(PendingIntent mbrIntent, ComponentName mbrComponent) {
            this.mAudioManager.unregisterMediaButtonEventReceiver(mbrComponent);
        }

        void adjustVolume(int direction, int flags) {
            if (this.mVolumeType == 2) {
                if (this.mVolumeProvider != null) {
                    this.mVolumeProvider.onAdjustVolume(direction);
                }
            } else {
                this.mAudioManager.adjustStreamVolume(this.mLocalStream, direction, flags);
            }
        }

        void setVolumeTo(int value, int flags) {
            if (this.mVolumeType == 2) {
                if (this.mVolumeProvider != null) {
                    this.mVolumeProvider.onSetVolumeTo(value);
                }
            } else {
                this.mAudioManager.setStreamVolume(this.mLocalStream, value, flags);
            }
        }

        void sendVolumeInfoChanged(ParcelableVolumeInfo info) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onVolumeInfoChanged(info);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendSessionDestroyed() {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onSessionDestroyed();
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
            this.mControllerCallbacks.kill();
        }

        private void sendEvent(String event, Bundle extras) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onEvent(event, extras);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendState(PlaybackStateCompat state) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onPlaybackStateChanged(state);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendMetadata(MediaMetadataCompat metadata) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onMetadataChanged(metadata);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendQueue(List<QueueItem> queue) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onQueueChanged(queue);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendQueueTitle(CharSequence queueTitle) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onQueueTitleChanged(queueTitle);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendCaptioningEnabled(boolean enabled) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onCaptioningEnabledChanged(enabled);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendRepeatMode(int repeatMode) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onRepeatModeChanged(repeatMode);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendShuffleMode(int shuffleMode) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onShuffleModeChanged(shuffleMode);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendExtras(Bundle extras) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onExtrasChanged(extras);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        class MessageHandler
        extends Handler {
            private static final int MSG_COMMAND = 1;
            private static final int MSG_ADJUST_VOLUME = 2;
            private static final int MSG_PREPARE = 3;
            private static final int MSG_PREPARE_MEDIA_ID = 4;
            private static final int MSG_PREPARE_SEARCH = 5;
            private static final int MSG_PREPARE_URI = 6;
            private static final int MSG_PLAY = 7;
            private static final int MSG_PLAY_MEDIA_ID = 8;
            private static final int MSG_PLAY_SEARCH = 9;
            private static final int MSG_PLAY_URI = 10;
            private static final int MSG_SKIP_TO_ITEM = 11;
            private static final int MSG_PAUSE = 12;
            private static final int MSG_STOP = 13;
            private static final int MSG_NEXT = 14;
            private static final int MSG_PREVIOUS = 15;
            private static final int MSG_FAST_FORWARD = 16;
            private static final int MSG_REWIND = 17;
            private static final int MSG_SEEK_TO = 18;
            private static final int MSG_RATE = 19;
            private static final int MSG_RATE_EXTRA = 31;
            private static final int MSG_SET_PLAYBACK_SPEED = 32;
            private static final int MSG_CUSTOM_ACTION = 20;
            private static final int MSG_MEDIA_BUTTON = 21;
            private static final int MSG_SET_VOLUME = 22;
            private static final int MSG_SET_REPEAT_MODE = 23;
            private static final int MSG_ADD_QUEUE_ITEM = 25;
            private static final int MSG_ADD_QUEUE_ITEM_AT = 26;
            private static final int MSG_REMOVE_QUEUE_ITEM = 27;
            private static final int MSG_REMOVE_QUEUE_ITEM_AT = 28;
            private static final int MSG_SET_CAPTIONING_ENABLED = 29;
            private static final int MSG_SET_SHUFFLE_MODE = 30;
            private static final int KEYCODE_MEDIA_PAUSE = 127;
            private static final int KEYCODE_MEDIA_PLAY = 126;

            public MessageHandler(Looper looper) {
                super(looper);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handleMessage(Message msg) {
                Callback cb = MediaSessionImplBase.this.mCallback;
                if (cb == null) {
                    return;
                }
                Bundle data = msg.getData();
                MediaSessionCompat.ensureClassLoader(data);
                MediaSessionImplBase.this.setCurrentControllerInfo(new MediaSessionManager.RemoteUserInfo(data.getString(MediaSessionCompat.DATA_CALLING_PACKAGE), data.getInt(MediaSessionCompat.DATA_CALLING_PID), data.getInt(MediaSessionCompat.DATA_CALLING_UID)));
                Bundle extras = data.getBundle(MediaSessionCompat.DATA_EXTRAS);
                MediaSessionCompat.ensureClassLoader(extras);
                try {
                    switch (msg.what) {
                        case 1: {
                            Command cmd = (Command)msg.obj;
                            cb.onCommand(cmd.command, cmd.extras, cmd.stub);
                            return;
                        }
                        case 21: {
                            KeyEvent keyEvent = (KeyEvent)msg.obj;
                            Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
                            intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)keyEvent);
                            if (cb.onMediaButtonEvent(intent)) return;
                            this.onMediaButtonEvent(keyEvent, cb);
                            return;
                        }
                        case 3: {
                            cb.onPrepare();
                            return;
                        }
                        case 4: {
                            cb.onPrepareFromMediaId((String)msg.obj, extras);
                            return;
                        }
                        case 5: {
                            cb.onPrepareFromSearch((String)msg.obj, extras);
                            return;
                        }
                        case 6: {
                            cb.onPrepareFromUri((Uri)msg.obj, extras);
                            return;
                        }
                        case 7: {
                            cb.onPlay();
                            return;
                        }
                        case 8: {
                            cb.onPlayFromMediaId((String)msg.obj, extras);
                            return;
                        }
                        case 9: {
                            cb.onPlayFromSearch((String)msg.obj, extras);
                            return;
                        }
                        case 10: {
                            cb.onPlayFromUri((Uri)msg.obj, extras);
                            return;
                        }
                        case 11: {
                            cb.onSkipToQueueItem((Long)msg.obj);
                            return;
                        }
                        case 12: {
                            cb.onPause();
                            return;
                        }
                        case 13: {
                            cb.onStop();
                            return;
                        }
                        case 14: {
                            cb.onSkipToNext();
                            return;
                        }
                        case 15: {
                            cb.onSkipToPrevious();
                            return;
                        }
                        case 16: {
                            cb.onFastForward();
                            return;
                        }
                        case 17: {
                            cb.onRewind();
                            return;
                        }
                        case 18: {
                            cb.onSeekTo((Long)msg.obj);
                            return;
                        }
                        case 19: {
                            cb.onSetRating((RatingCompat)msg.obj);
                            return;
                        }
                        case 31: {
                            cb.onSetRating((RatingCompat)msg.obj, extras);
                            return;
                        }
                        case 32: {
                            cb.onSetPlaybackSpeed(((Float)msg.obj).floatValue());
                            return;
                        }
                        case 20: {
                            cb.onCustomAction((String)msg.obj, extras);
                            return;
                        }
                        case 25: {
                            cb.onAddQueueItem((MediaDescriptionCompat)msg.obj);
                            return;
                        }
                        case 26: {
                            cb.onAddQueueItem((MediaDescriptionCompat)msg.obj, msg.arg1);
                            return;
                        }
                        case 27: {
                            cb.onRemoveQueueItem((MediaDescriptionCompat)msg.obj);
                            return;
                        }
                        case 28: {
                            if (MediaSessionImplBase.this.mQueue == null) return;
                            QueueItem item = msg.arg1 >= 0 && msg.arg1 < MediaSessionImplBase.this.mQueue.size() ? MediaSessionImplBase.this.mQueue.get(msg.arg1) : null;
                            if (item == null) return;
                            cb.onRemoveQueueItem(item.getDescription());
                            return;
                        }
                        case 2: {
                            MediaSessionImplBase.this.adjustVolume(msg.arg1, 0);
                            return;
                        }
                        case 22: {
                            MediaSessionImplBase.this.setVolumeTo(msg.arg1, 0);
                            return;
                        }
                        case 29: {
                            cb.onSetCaptioningEnabled((Boolean)msg.obj);
                            return;
                        }
                        case 23: {
                            cb.onSetRepeatMode(msg.arg1);
                            return;
                        }
                        case 30: {
                            cb.onSetShuffleMode(msg.arg1);
                            return;
                        }
                    }
                    return;
                }
                finally {
                    MediaSessionImplBase.this.setCurrentControllerInfo(null);
                }
            }

            private void onMediaButtonEvent(KeyEvent ke, Callback cb) {
                if (ke == null || ke.getAction() != 0) {
                    return;
                }
                long validActions = MediaSessionImplBase.this.mState == null ? 0L : MediaSessionImplBase.this.mState.getActions();
                switch (ke.getKeyCode()) {
                    case 126: {
                        if ((validActions & 4L) == 0L) break;
                        cb.onPlay();
                        break;
                    }
                    case 127: {
                        if ((validActions & 2L) == 0L) break;
                        cb.onPause();
                        break;
                    }
                    case 87: {
                        if ((validActions & 0x20L) == 0L) break;
                        cb.onSkipToNext();
                        break;
                    }
                    case 88: {
                        if ((validActions & 0x10L) == 0L) break;
                        cb.onSkipToPrevious();
                        break;
                    }
                    case 86: {
                        if ((validActions & 1L) == 0L) break;
                        cb.onStop();
                        break;
                    }
                    case 90: {
                        if ((validActions & 0x40L) == 0L) break;
                        cb.onFastForward();
                        break;
                    }
                    case 89: {
                        if ((validActions & 8L) == 0L) break;
                        cb.onRewind();
                        break;
                    }
                    case 79: 
                    case 85: {
                        Log.w((String)MediaSessionCompat.TAG, (String)"KEYCODE_MEDIA_PLAY_PAUSE and KEYCODE_HEADSETHOOK are handled already");
                    }
                }
            }
        }

        private static final class Command {
            public final String command;
            public final Bundle extras;
            public final ResultReceiver stub;

            public Command(String command, Bundle extras, ResultReceiver stub) {
                this.command = command;
                this.extras = extras;
                this.stub = stub;
            }
        }

        class MediaSessionStub
        extends IMediaSession.Stub {
            MediaSessionStub() {
            }

            @Override
            public void sendCommand(String command, Bundle args, ResultReceiverWrapper cb) {
                this.postToHandler(1, new Command(command, args, cb == null ? null : cb.mResultReceiver));
            }

            @Override
            public boolean sendMediaButton(KeyEvent mediaButton) {
                this.postToHandler(21, mediaButton);
                return true;
            }

            @Override
            public void registerCallbackListener(IMediaControllerCallback cb) {
                if (MediaSessionImplBase.this.mDestroyed) {
                    try {
                        cb.onSessionDestroyed();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                int uid = MediaSessionStub.getCallingUid();
                MediaSessionManager.RemoteUserInfo info = new MediaSessionManager.RemoteUserInfo(MediaSessionImplBase.this.getPackageNameForUid(uid), MediaSessionStub.getCallingPid(), MediaSessionStub.getCallingUid());
                MediaSessionImplBase.this.mControllerCallbacks.register((IInterface)cb, (Object)info);
            }

            @Override
            public void unregisterCallbackListener(IMediaControllerCallback cb) {
                MediaSessionImplBase.this.mControllerCallbacks.unregister((IInterface)cb);
            }

            @Override
            public String getPackageName() {
                return MediaSessionImplBase.this.mPackageName;
            }

            @Override
            public Bundle getSessionInfo() {
                return MediaSessionImplBase.this.mSessionInfo == null ? null : new Bundle(MediaSessionImplBase.this.mSessionInfo);
            }

            @Override
            public String getTag() {
                return MediaSessionImplBase.this.mTag;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent getLaunchPendingIntent() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mSessionActivity;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFlags() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mFlags;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelableVolumeInfo getVolumeAttributes() {
                int current;
                int max;
                int controlType;
                int stream;
                int volumeType;
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    volumeType = MediaSessionImplBase.this.mVolumeType;
                    stream = MediaSessionImplBase.this.mLocalStream;
                    VolumeProviderCompat vp = MediaSessionImplBase.this.mVolumeProvider;
                    if (volumeType == 2) {
                        controlType = vp.getVolumeControl();
                        max = vp.getMaxVolume();
                        current = vp.getCurrentVolume();
                    } else {
                        controlType = 2;
                        max = MediaSessionImplBase.this.mAudioManager.getStreamMaxVolume(stream);
                        current = MediaSessionImplBase.this.mAudioManager.getStreamVolume(stream);
                    }
                }
                return new ParcelableVolumeInfo(volumeType, stream, controlType, max, current);
            }

            @Override
            public void adjustVolume(int direction, int flags, String packageName) {
                MediaSessionImplBase.this.adjustVolume(direction, flags);
            }

            @Override
            public void setVolumeTo(int value, int flags, String packageName) {
                MediaSessionImplBase.this.setVolumeTo(value, flags);
            }

            @Override
            public void prepare() throws RemoteException {
                this.postToHandler(3);
            }

            @Override
            public void prepareFromMediaId(String mediaId, Bundle extras) throws RemoteException {
                this.postToHandler(4, (Object)mediaId, extras);
            }

            @Override
            public void prepareFromSearch(String query, Bundle extras) throws RemoteException {
                this.postToHandler(5, (Object)query, extras);
            }

            @Override
            public void prepareFromUri(Uri uri, Bundle extras) throws RemoteException {
                this.postToHandler(6, (Object)uri, extras);
            }

            @Override
            public void play() throws RemoteException {
                this.postToHandler(7);
            }

            @Override
            public void playFromMediaId(String mediaId, Bundle extras) throws RemoteException {
                this.postToHandler(8, (Object)mediaId, extras);
            }

            @Override
            public void playFromSearch(String query, Bundle extras) throws RemoteException {
                this.postToHandler(9, (Object)query, extras);
            }

            @Override
            public void playFromUri(Uri uri, Bundle extras) throws RemoteException {
                this.postToHandler(10, (Object)uri, extras);
            }

            @Override
            public void skipToQueueItem(long id2) {
                this.postToHandler(11, id2);
            }

            @Override
            public void pause() throws RemoteException {
                this.postToHandler(12);
            }

            @Override
            public void stop() throws RemoteException {
                this.postToHandler(13);
            }

            @Override
            public void next() throws RemoteException {
                this.postToHandler(14);
            }

            @Override
            public void previous() throws RemoteException {
                this.postToHandler(15);
            }

            @Override
            public void fastForward() throws RemoteException {
                this.postToHandler(16);
            }

            @Override
            public void rewind() throws RemoteException {
                this.postToHandler(17);
            }

            @Override
            public void seekTo(long pos) throws RemoteException {
                this.postToHandler(18, pos);
            }

            @Override
            public void rate(RatingCompat rating) throws RemoteException {
                this.postToHandler(19, rating);
            }

            @Override
            public void rateWithExtras(RatingCompat rating, Bundle extras) throws RemoteException {
                this.postToHandler(31, (Object)rating, extras);
            }

            @Override
            public void setPlaybackSpeed(float speed) throws RemoteException {
                this.postToHandler(32, Float.valueOf(speed));
            }

            @Override
            public void setCaptioningEnabled(boolean enabled) throws RemoteException {
                this.postToHandler(29, enabled);
            }

            @Override
            public void setRepeatMode(int repeatMode) throws RemoteException {
                this.postToHandler(23, repeatMode);
            }

            @Override
            public void setShuffleModeEnabledRemoved(boolean enabled) throws RemoteException {
            }

            @Override
            public void setShuffleMode(int shuffleMode) throws RemoteException {
                this.postToHandler(30, shuffleMode);
            }

            @Override
            public void sendCustomAction(String action, Bundle args) throws RemoteException {
                this.postToHandler(20, (Object)action, args);
            }

            @Override
            public MediaMetadataCompat getMetadata() {
                return MediaSessionImplBase.this.mMetadata;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PlaybackStateCompat getPlaybackState() {
                MediaMetadataCompat metadata;
                PlaybackStateCompat state;
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    state = MediaSessionImplBase.this.mState;
                    metadata = MediaSessionImplBase.this.mMetadata;
                }
                return MediaSessionCompat.getStateWithUpdatedPosition(state, metadata);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<QueueItem> getQueue() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mQueue;
                }
            }

            @Override
            public void addQueueItem(MediaDescriptionCompat description) {
                this.postToHandler(25, description);
            }

            @Override
            public void addQueueItemAt(MediaDescriptionCompat description, int index) {
                this.postToHandler(26, (Object)description, index);
            }

            @Override
            public void removeQueueItem(MediaDescriptionCompat description) {
                this.postToHandler(27, description);
            }

            @Override
            public void removeQueueItemAt(int index) {
                this.postToHandler(28, index);
            }

            @Override
            public CharSequence getQueueTitle() {
                return MediaSessionImplBase.this.mQueueTitle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getExtras() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mExtras;
                }
            }

            @Override
            public int getRatingType() {
                return MediaSessionImplBase.this.mRatingType;
            }

            @Override
            public boolean isCaptioningEnabled() {
                return MediaSessionImplBase.this.mCaptioningEnabled;
            }

            @Override
            public int getRepeatMode() {
                return MediaSessionImplBase.this.mRepeatMode;
            }

            @Override
            public boolean isShuffleModeEnabledRemoved() {
                return false;
            }

            @Override
            public int getShuffleMode() {
                return MediaSessionImplBase.this.mShuffleMode;
            }

            @Override
            public boolean isTransportControlEnabled() {
                return true;
            }

            void postToHandler(int what) {
                MediaSessionImplBase.this.postToHandler(what, 0, 0, null, null);
            }

            void postToHandler(int what, int arg1) {
                MediaSessionImplBase.this.postToHandler(what, arg1, 0, null, null);
            }

            void postToHandler(int what, Object obj) {
                MediaSessionImplBase.this.postToHandler(what, 0, 0, obj, null);
            }

            void postToHandler(int what, Object obj, int arg1) {
                MediaSessionImplBase.this.postToHandler(what, arg1, 0, obj, null);
            }

            void postToHandler(int what, Object obj, Bundle extras) {
                MediaSessionImplBase.this.postToHandler(what, 0, 0, obj, extras);
            }
        }
    }

    static interface MediaSessionImpl {
        public void setCallback(Callback var1, Handler var2);

        public void setFlags(int var1);

        public void setPlaybackToLocal(int var1);

        public void setPlaybackToRemote(VolumeProviderCompat var1);

        public void setActive(boolean var1);

        public boolean isActive();

        public void sendSessionEvent(String var1, Bundle var2);

        public void release();

        public Token getSessionToken();

        public void setPlaybackState(PlaybackStateCompat var1);

        public PlaybackStateCompat getPlaybackState();

        public void setMetadata(MediaMetadataCompat var1);

        public void setSessionActivity(PendingIntent var1);

        public void setMediaButtonReceiver(PendingIntent var1);

        public void setQueue(List<QueueItem> var1);

        public void setQueueTitle(CharSequence var1);

        public void setRatingType(int var1);

        public void setCaptioningEnabled(boolean var1);

        public void setRepeatMode(int var1);

        public void setShuffleMode(int var1);

        public void setExtras(Bundle var1);

        public Object getMediaSession();

        public Object getRemoteControlClient();

        public String getCallingPackage();

        public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo();

        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo var1);

        public Callback getCallback();
    }

    public static interface OnActiveChangeListener {
        public void onActiveChanged();
    }

    @SuppressLint(value={"BanParcelableUsage"})
    static final class ResultReceiverWrapper
    implements Parcelable {
        ResultReceiver mResultReceiver;
        public static final Parcelable.Creator<ResultReceiverWrapper> CREATOR = new Parcelable.Creator<ResultReceiverWrapper>(){

            public ResultReceiverWrapper createFromParcel(Parcel p) {
                return new ResultReceiverWrapper(p);
            }

            public ResultReceiverWrapper[] newArray(int size) {
                return new ResultReceiverWrapper[size];
            }
        };

        public ResultReceiverWrapper(@NonNull ResultReceiver resultReceiver) {
            this.mResultReceiver = resultReceiver;
        }

        ResultReceiverWrapper(Parcel in) {
            this.mResultReceiver = (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(in);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.mResultReceiver.writeToParcel(dest, flags);
        }
    }

    @SuppressLint(value={"BanParcelableUsage"})
    public static final class QueueItem
    implements Parcelable {
        public static final int UNKNOWN_ID = -1;
        private final MediaDescriptionCompat mDescription;
        private final long mId;
        private MediaSession.QueueItem mItemFwk;
        public static final Parcelable.Creator<QueueItem> CREATOR = new Parcelable.Creator<QueueItem>(){

            public QueueItem createFromParcel(Parcel p) {
                return new QueueItem(p);
            }

            public QueueItem[] newArray(int size) {
                return new QueueItem[size];
            }
        };

        public QueueItem(MediaDescriptionCompat description, long id2) {
            this(null, description, id2);
        }

        private QueueItem(MediaSession.QueueItem queueItem, MediaDescriptionCompat description, long id2) {
            if (description == null) {
                throw new IllegalArgumentException("Description cannot be null");
            }
            if (id2 == -1L) {
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            this.mDescription = description;
            this.mId = id2;
            this.mItemFwk = queueItem;
        }

        QueueItem(Parcel in) {
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(in);
            this.mId = in.readLong();
        }

        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        public long getQueueId() {
            return this.mId;
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.mDescription.writeToParcel(dest, flags);
            dest.writeLong(this.mId);
        }

        public int describeContents() {
            return 0;
        }

        public Object getQueueItem() {
            if (this.mItemFwk != null || Build.VERSION.SDK_INT < 21) {
                return this.mItemFwk;
            }
            this.mItemFwk = Api21Impl.createQueueItem((MediaDescription)this.mDescription.getMediaDescription(), this.mId);
            return this.mItemFwk;
        }

        public static QueueItem fromQueueItem(Object queueItem) {
            if (queueItem == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            MediaSession.QueueItem queueItemObj = (MediaSession.QueueItem)queueItem;
            MediaDescription descriptionObj = Api21Impl.getDescription(queueItemObj);
            MediaDescriptionCompat description = MediaDescriptionCompat.fromMediaDescription(descriptionObj);
            long id2 = Api21Impl.getQueueId(queueItemObj);
            return new QueueItem(queueItemObj, description, id2);
        }

        public static List<QueueItem> fromQueueItemList(List<?> itemList) {
            if (itemList == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            ArrayList<QueueItem> items = new ArrayList<QueueItem>();
            for (Object itemObj : itemList) {
                items.add(QueueItem.fromQueueItem(itemObj));
            }
            return items;
        }

        public String toString() {
            return "MediaSession.QueueItem {Description=" + this.mDescription + ", Id=" + this.mId + " }";
        }

        @RequiresApi(value=21)
        private static class Api21Impl {
            private Api21Impl() {
            }

            @DoNotInline
            static MediaSession.QueueItem createQueueItem(MediaDescription description, long id2) {
                return new MediaSession.QueueItem(description, id2);
            }

            @DoNotInline
            static MediaDescription getDescription(MediaSession.QueueItem queueItem) {
                return queueItem.getDescription();
            }

            @DoNotInline
            static long getQueueId(MediaSession.QueueItem queueItem) {
                return queueItem.getQueueId();
            }
        }
    }

    @SuppressLint(value={"BanParcelableUsage"})
    public static final class Token
    implements Parcelable {
        private final Object mLock = new Object();
        private final Object mInner;
        @GuardedBy(value="mLock")
        private IMediaSession mExtraBinder;
        @GuardedBy(value="mLock")
        private VersionedParcelable mSession2Token;
        public static final Parcelable.Creator<Token> CREATOR = new Parcelable.Creator<Token>(){

            public Token createFromParcel(Parcel in) {
                Object inner = Build.VERSION.SDK_INT >= 21 ? in.readParcelable(null) : in.readStrongBinder();
                return new Token(inner);
            }

            public Token[] newArray(int size) {
                return new Token[size];
            }
        };

        Token(Object inner) {
            this(inner, null, null);
        }

        Token(Object inner, IMediaSession extraBinder) {
            this(inner, extraBinder, null);
        }

        Token(Object inner, IMediaSession extraBinder, VersionedParcelable session2Token) {
            this.mInner = inner;
            this.mExtraBinder = extraBinder;
            this.mSession2Token = session2Token;
        }

        public static Token fromToken(Object token) {
            return Token.fromToken(token, null);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static Token fromToken(Object token, IMediaSession extraBinder) {
            if (token != null && Build.VERSION.SDK_INT >= 21) {
                if (!(token instanceof MediaSession.Token)) {
                    throw new IllegalArgumentException("token is not a valid MediaSession.Token object");
                }
                return new Token(token, extraBinder);
            }
            return null;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            if (Build.VERSION.SDK_INT >= 21) {
                dest.writeParcelable((Parcelable)this.mInner, flags);
            } else {
                dest.writeStrongBinder((IBinder)this.mInner);
            }
        }

        public int hashCode() {
            if (this.mInner == null) {
                return 0;
            }
            return this.mInner.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Token)) {
                return false;
            }
            Token other = (Token)obj;
            if (this.mInner == null) {
                return other.mInner == null;
            }
            if (other.mInner == null) {
                return false;
            }
            return this.mInner.equals(other.mInner);
        }

        public Object getToken() {
            return this.mInner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public IMediaSession getExtraBinder() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mExtraBinder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public void setExtraBinder(IMediaSession extraBinder) {
            Object object = this.mLock;
            synchronized (object) {
                this.mExtraBinder = extraBinder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public VersionedParcelable getSession2Token() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mSession2Token;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public void setSession2Token(VersionedParcelable session2Token) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSession2Token = session2Token;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putParcelable(MediaSessionCompat.KEY_TOKEN, (Parcelable)this);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExtraBinder != null) {
                    BundleCompat.putBinder((Bundle)bundle, (String)MediaSessionCompat.KEY_EXTRA_BINDER, (IBinder)this.mExtraBinder.asBinder());
                }
                if (this.mSession2Token != null) {
                    ParcelUtils.putVersionedParcelable((Bundle)bundle, (String)MediaSessionCompat.KEY_SESSION2_TOKEN, (VersionedParcelable)this.mSession2Token);
                }
            }
            return bundle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public static Token fromBundle(Bundle tokenBundle) {
            if (tokenBundle == null) {
                return null;
            }
            IMediaSession extraSession = IMediaSession.Stub.asInterface(BundleCompat.getBinder((Bundle)tokenBundle, (String)MediaSessionCompat.KEY_EXTRA_BINDER));
            VersionedParcelable session2Token = ParcelUtils.getVersionedParcelable((Bundle)tokenBundle, (String)MediaSessionCompat.KEY_SESSION2_TOKEN);
            Token token = (Token)tokenBundle.getParcelable(MediaSessionCompat.KEY_TOKEN);
            return token == null ? null : new Token(token.mInner, extraSession, session2Token);
        }
    }

    public static abstract class Callback {
        final Object mLock = new Object();
        final MediaSession.Callback mCallbackFwk = Build.VERSION.SDK_INT >= 21 ? new MediaSessionCallbackApi21() : null;
        private boolean mMediaPlayPausePendingOnHandler;
        @GuardedBy(value="mLock")
        WeakReference<MediaSessionImpl> mSessionImpl = new WeakReference<Object>(null);
        @GuardedBy(value="mLock")
        CallbackHandler mCallbackHandler;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSessionImpl(MediaSessionImpl impl, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionImpl = new WeakReference<MediaSessionImpl>(impl);
                if (this.mCallbackHandler != null) {
                    this.mCallbackHandler.removeCallbacksAndMessages(null);
                }
                this.mCallbackHandler = impl == null || handler == null ? null : new CallbackHandler(handler.getLooper());
            }
        }

        public void onCommand(String command, Bundle extras, ResultReceiver cb) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onMediaButtonEvent(Intent mediaButtonEvent) {
            CallbackHandler callbackHandler;
            MediaSessionImpl impl;
            if (Build.VERSION.SDK_INT >= 27) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                impl = (MediaSessionImpl)this.mSessionImpl.get();
                callbackHandler = this.mCallbackHandler;
            }
            if (impl == null || callbackHandler == null) {
                return false;
            }
            KeyEvent keyEvent = (KeyEvent)mediaButtonEvent.getParcelableExtra("android.intent.extra.KEY_EVENT");
            if (keyEvent == null || keyEvent.getAction() != 0) {
                return false;
            }
            MediaSessionManager.RemoteUserInfo remoteUserInfo = impl.getCurrentControllerInfo();
            int keyCode = keyEvent.getKeyCode();
            switch (keyCode) {
                case 79: 
                case 85: {
                    if (keyEvent.getRepeatCount() == 0) {
                        if (this.mMediaPlayPausePendingOnHandler) {
                            long validActions;
                            callbackHandler.removeMessages(1);
                            this.mMediaPlayPausePendingOnHandler = false;
                            PlaybackStateCompat state = impl.getPlaybackState();
                            long l = validActions = state == null ? 0L : state.getActions();
                            if ((validActions & 0x20L) != 0L) {
                                this.onSkipToNext();
                            }
                        } else {
                            this.mMediaPlayPausePendingOnHandler = true;
                            callbackHandler.sendMessageDelayed(callbackHandler.obtainMessage(1, remoteUserInfo), ViewConfiguration.getDoubleTapTimeout());
                        }
                    } else {
                        this.handleMediaPlayPauseIfPendingOnHandler(impl, callbackHandler);
                    }
                    return true;
                }
            }
            this.handleMediaPlayPauseIfPendingOnHandler(impl, callbackHandler);
            return false;
        }

        void handleMediaPlayPauseIfPendingOnHandler(MediaSessionImpl impl, Handler callbackHandler) {
            boolean canPause;
            if (!this.mMediaPlayPausePendingOnHandler) {
                return;
            }
            this.mMediaPlayPausePendingOnHandler = false;
            callbackHandler.removeMessages(1);
            PlaybackStateCompat state = impl.getPlaybackState();
            long validActions = state == null ? 0L : state.getActions();
            boolean isPlaying = state != null && state.getState() == 3;
            boolean canPlay = (validActions & 0x204L) != 0L;
            boolean bl = canPause = (validActions & 0x202L) != 0L;
            if (isPlaying && canPause) {
                this.onPause();
            } else if (!isPlaying && canPlay) {
                this.onPlay();
            }
        }

        public void onPrepare() {
        }

        public void onPrepareFromMediaId(String mediaId, Bundle extras) {
        }

        public void onPrepareFromSearch(String query, Bundle extras) {
        }

        public void onPrepareFromUri(Uri uri, Bundle extras) {
        }

        public void onPlay() {
        }

        public void onPlayFromMediaId(String mediaId, Bundle extras) {
        }

        public void onPlayFromSearch(String query, Bundle extras) {
        }

        public void onPlayFromUri(Uri uri, Bundle extras) {
        }

        public void onSkipToQueueItem(long id2) {
        }

        public void onPause() {
        }

        public void onSkipToNext() {
        }

        public void onSkipToPrevious() {
        }

        public void onFastForward() {
        }

        public void onRewind() {
        }

        public void onStop() {
        }

        public void onSeekTo(long pos) {
        }

        public void onSetRating(RatingCompat rating) {
        }

        public void onSetRating(RatingCompat rating, Bundle extras) {
        }

        public void onSetPlaybackSpeed(float speed) {
        }

        public void onSetCaptioningEnabled(boolean enabled) {
        }

        public void onSetRepeatMode(int repeatMode) {
        }

        public void onSetShuffleMode(int shuffleMode) {
        }

        public void onCustomAction(String action, Bundle extras) {
        }

        public void onAddQueueItem(MediaDescriptionCompat description) {
        }

        public void onAddQueueItem(MediaDescriptionCompat description, int index) {
        }

        public void onRemoveQueueItem(MediaDescriptionCompat description) {
        }

        @Deprecated
        public void onRemoveQueueItemAt(int index) {
        }

        @RequiresApi(value=21)
        private class MediaSessionCallbackApi21
        extends MediaSession.Callback {
            MediaSessionCallbackApi21() {
            }

            public void onCommand(String command, Bundle extras, ResultReceiver cb) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                try {
                    if (command.equals("android.support.v4.media.session.command.GET_EXTRA_BINDER")) {
                        Bundle result = new Bundle();
                        Token token = sessionImpl.getSessionToken();
                        IMediaSession extraBinder = token.getExtraBinder();
                        BundleCompat.putBinder((Bundle)result, (String)MediaSessionCompat.KEY_EXTRA_BINDER, (IBinder)(extraBinder == null ? null : extraBinder.asBinder()));
                        ParcelUtils.putVersionedParcelable((Bundle)result, (String)MediaSessionCompat.KEY_SESSION2_TOKEN, (VersionedParcelable)token.getSession2Token());
                        cb.send(0, result);
                    } else if (command.equals("android.support.v4.media.session.command.ADD_QUEUE_ITEM")) {
                        Callback.this.onAddQueueItem((MediaDescriptionCompat)extras.getParcelable("android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION"));
                    } else if (command.equals("android.support.v4.media.session.command.ADD_QUEUE_ITEM_AT")) {
                        Callback.this.onAddQueueItem((MediaDescriptionCompat)extras.getParcelable("android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION"), extras.getInt("android.support.v4.media.session.command.ARGUMENT_INDEX"));
                    } else if (command.equals("android.support.v4.media.session.command.REMOVE_QUEUE_ITEM")) {
                        Callback.this.onRemoveQueueItem((MediaDescriptionCompat)extras.getParcelable("android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION"));
                    } else if (command.equals("android.support.v4.media.session.command.REMOVE_QUEUE_ITEM_AT")) {
                        if (sessionImpl.mQueue != null) {
                            QueueItem item;
                            int index = extras.getInt("android.support.v4.media.session.command.ARGUMENT_INDEX", -1);
                            QueueItem queueItem = item = index >= 0 && index < sessionImpl.mQueue.size() ? sessionImpl.mQueue.get(index) : null;
                            if (item != null) {
                                Callback.this.onRemoveQueueItem(item.getDescription());
                            }
                        }
                    } else {
                        Callback.this.onCommand(command, extras, cb);
                    }
                }
                catch (BadParcelableException e) {
                    Log.e((String)MediaSessionCompat.TAG, (String)"Could not unparcel the extra data.");
                }
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public boolean onMediaButtonEvent(Intent mediaButtonIntent) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return false;
                }
                this.setCurrentControllerInfo(sessionImpl);
                boolean result = Callback.this.onMediaButtonEvent(mediaButtonIntent);
                this.clearCurrentControllerInfo(sessionImpl);
                return result || super.onMediaButtonEvent(mediaButtonIntent);
            }

            public void onPlay() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPlay();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onPlayFromMediaId(String mediaId, Bundle extras) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPlayFromMediaId(mediaId, extras);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onPlayFromSearch(String search, Bundle extras) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPlayFromSearch(search, extras);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            @RequiresApi(value=23)
            public void onPlayFromUri(Uri uri, Bundle extras) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPlayFromUri(uri, extras);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onSkipToQueueItem(long id2) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onSkipToQueueItem(id2);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onPause() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPause();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onSkipToNext() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onSkipToNext();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onSkipToPrevious() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onSkipToPrevious();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onFastForward() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onFastForward();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onRewind() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onRewind();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onStop() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onStop();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onSeekTo(long pos) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onSeekTo(pos);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onSetRating(Rating ratingFwk) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onSetRating(RatingCompat.fromRating(ratingFwk));
                this.clearCurrentControllerInfo(sessionImpl);
            }

            public void onSetRating(Rating ratingFwk, Bundle extras) {
            }

            public void onCustomAction(String action, Bundle extras) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                try {
                    if (action.equals(MediaSessionCompat.ACTION_PLAY_FROM_URI)) {
                        Uri uri = (Uri)extras.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_URI);
                        Bundle bundle = extras.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                        MediaSessionCompat.ensureClassLoader(bundle);
                        Callback.this.onPlayFromUri(uri, bundle);
                    } else if (action.equals(MediaSessionCompat.ACTION_PREPARE)) {
                        Callback.this.onPrepare();
                    } else if (action.equals(MediaSessionCompat.ACTION_PREPARE_FROM_MEDIA_ID)) {
                        String mediaId = extras.getString(MediaSessionCompat.ACTION_ARGUMENT_MEDIA_ID);
                        Bundle bundle = extras.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                        MediaSessionCompat.ensureClassLoader(bundle);
                        Callback.this.onPrepareFromMediaId(mediaId, bundle);
                    } else if (action.equals(MediaSessionCompat.ACTION_PREPARE_FROM_SEARCH)) {
                        String query = extras.getString(MediaSessionCompat.ACTION_ARGUMENT_QUERY);
                        Bundle bundle = extras.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                        MediaSessionCompat.ensureClassLoader(bundle);
                        Callback.this.onPrepareFromSearch(query, bundle);
                    } else if (action.equals(MediaSessionCompat.ACTION_PREPARE_FROM_URI)) {
                        Uri uri = (Uri)extras.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_URI);
                        Bundle bundle = extras.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                        MediaSessionCompat.ensureClassLoader(bundle);
                        Callback.this.onPrepareFromUri(uri, bundle);
                    } else if (action.equals(MediaSessionCompat.ACTION_SET_CAPTIONING_ENABLED)) {
                        boolean enabled = extras.getBoolean(MediaSessionCompat.ACTION_ARGUMENT_CAPTIONING_ENABLED);
                        Callback.this.onSetCaptioningEnabled(enabled);
                    } else if (action.equals(MediaSessionCompat.ACTION_SET_REPEAT_MODE)) {
                        int repeatMode = extras.getInt(MediaSessionCompat.ACTION_ARGUMENT_REPEAT_MODE);
                        Callback.this.onSetRepeatMode(repeatMode);
                    } else if (action.equals(MediaSessionCompat.ACTION_SET_SHUFFLE_MODE)) {
                        int shuffleMode = extras.getInt(MediaSessionCompat.ACTION_ARGUMENT_SHUFFLE_MODE);
                        Callback.this.onSetShuffleMode(shuffleMode);
                    } else if (action.equals(MediaSessionCompat.ACTION_SET_RATING)) {
                        RatingCompat rating = (RatingCompat)extras.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_RATING);
                        Bundle bundle = extras.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                        MediaSessionCompat.ensureClassLoader(bundle);
                        Callback.this.onSetRating(rating, bundle);
                    } else if (action.equals(MediaSessionCompat.ACTION_SET_PLAYBACK_SPEED)) {
                        float speed = extras.getFloat(MediaSessionCompat.ACTION_ARGUMENT_PLAYBACK_SPEED, 1.0f);
                        Callback.this.onSetPlaybackSpeed(speed);
                    } else {
                        Callback.this.onCustomAction(action, extras);
                    }
                }
                catch (BadParcelableException e) {
                    Log.e((String)MediaSessionCompat.TAG, (String)"Could not unparcel the data.");
                }
                this.clearCurrentControllerInfo(sessionImpl);
            }

            @RequiresApi(value=24)
            public void onPrepare() {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPrepare();
                this.clearCurrentControllerInfo(sessionImpl);
            }

            @RequiresApi(value=24)
            public void onPrepareFromMediaId(String mediaId, Bundle extras) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPrepareFromMediaId(mediaId, extras);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            @RequiresApi(value=24)
            public void onPrepareFromSearch(String query, Bundle extras) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPrepareFromSearch(query, extras);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            @RequiresApi(value=24)
            public void onPrepareFromUri(Uri uri, Bundle extras) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(extras);
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onPrepareFromUri(uri, extras);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            @RequiresApi(value=29)
            public void onSetPlaybackSpeed(float speed) {
                MediaSessionImplApi21 sessionImpl = this.getSessionImplIfCallbackIsSet();
                if (sessionImpl == null) {
                    return;
                }
                this.setCurrentControllerInfo(sessionImpl);
                Callback.this.onSetPlaybackSpeed(speed);
                this.clearCurrentControllerInfo(sessionImpl);
            }

            private void setCurrentControllerInfo(MediaSessionImpl sessionImpl) {
                if (Build.VERSION.SDK_INT >= 28) {
                    return;
                }
                String packageName = sessionImpl.getCallingPackage();
                if (TextUtils.isEmpty((CharSequence)packageName)) {
                    packageName = "android.media.session.MediaController";
                }
                sessionImpl.setCurrentControllerInfo(new MediaSessionManager.RemoteUserInfo(packageName, -1, -1));
            }

            private void clearCurrentControllerInfo(MediaSessionImpl sessionImpl) {
                sessionImpl.setCurrentControllerInfo(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private MediaSessionImplApi21 getSessionImplIfCallbackIsSet() {
                MediaSessionImplApi21 sessionImpl;
                Object object = Callback.this.mLock;
                synchronized (object) {
                    sessionImpl = (MediaSessionImplApi21)Callback.this.mSessionImpl.get();
                }
                return sessionImpl != null && Callback.this == sessionImpl.getCallback() ? sessionImpl : null;
            }
        }

        private class CallbackHandler
        extends Handler {
            private static final int MSG_MEDIA_PLAY_PAUSE_KEY_DOUBLE_TAP_TIMEOUT = 1;

            CallbackHandler(Looper looper) {
                super(looper);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    CallbackHandler callbackHandler;
                    MediaSessionImpl impl;
                    Object object = Callback.this.mLock;
                    synchronized (object) {
                        impl = (MediaSessionImpl)Callback.this.mSessionImpl.get();
                        callbackHandler = Callback.this.mCallbackHandler;
                    }
                    if (impl == null || Callback.this != impl.getCallback() || callbackHandler == null) {
                        return;
                    }
                    MediaSessionManager.RemoteUserInfo info = (MediaSessionManager.RemoteUserInfo)msg.obj;
                    impl.setCurrentControllerInfo(info);
                    Callback.this.handleMediaPlayPauseIfPendingOnHandler(impl, callbackHandler);
                    impl.setCurrentControllerInfo(null);
                }
            }
        }
    }
}

