/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.circularreveal;

import android.animation.TypeEvaluator;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.Property;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.circularreveal.CircularRevealHelper;
import com.google.android.material.math.MathUtils;

public interface CircularRevealWidget
extends CircularRevealHelper.Delegate {
    public void draw(Canvas var1);

    public boolean isOpaque();

    public void buildCircularRevealCache();

    public void destroyCircularRevealCache();

    @Nullable
    public RevealInfo getRevealInfo();

    public void setRevealInfo(@Nullable RevealInfo var1);

    @ColorInt
    public int getCircularRevealScrimColor();

    public void setCircularRevealScrimColor(@ColorInt int var1);

    @Nullable
    public Drawable getCircularRevealOverlayDrawable();

    public void setCircularRevealOverlayDrawable(@Nullable Drawable var1);

    public static class CircularRevealScrimColorProperty
    extends Property<CircularRevealWidget, Integer> {
        public static final Property<CircularRevealWidget, Integer> CIRCULAR_REVEAL_SCRIM_COLOR = new CircularRevealScrimColorProperty("circularRevealScrimColor");

        private CircularRevealScrimColorProperty(String name) {
            super(Integer.class, name);
        }

        @NonNull
        public Integer get(@NonNull CircularRevealWidget object) {
            return object.getCircularRevealScrimColor();
        }

        public void set(@NonNull CircularRevealWidget object, @NonNull Integer value) {
            object.setCircularRevealScrimColor(value);
        }
    }

    public static class CircularRevealEvaluator
    implements TypeEvaluator<RevealInfo> {
        public static final TypeEvaluator<RevealInfo> CIRCULAR_REVEAL = new CircularRevealEvaluator();
        private final RevealInfo revealInfo = new RevealInfo();

        @NonNull
        public RevealInfo evaluate(float fraction, @NonNull RevealInfo startValue, @NonNull RevealInfo endValue) {
            this.revealInfo.set(MathUtils.lerp(startValue.centerX, endValue.centerX, fraction), MathUtils.lerp(startValue.centerY, endValue.centerY, fraction), MathUtils.lerp(startValue.radius, endValue.radius, fraction));
            return this.revealInfo;
        }
    }

    public static class CircularRevealProperty
    extends Property<CircularRevealWidget, RevealInfo> {
        public static final Property<CircularRevealWidget, RevealInfo> CIRCULAR_REVEAL = new CircularRevealProperty("circularReveal");

        private CircularRevealProperty(String name) {
            super(RevealInfo.class, name);
        }

        @Nullable
        public RevealInfo get(@NonNull CircularRevealWidget object) {
            return object.getRevealInfo();
        }

        public void set(@NonNull CircularRevealWidget object, @Nullable RevealInfo value) {
            object.setRevealInfo(value);
        }
    }

    public static class RevealInfo {
        public static final float INVALID_RADIUS = Float.MAX_VALUE;
        public float centerX;
        public float centerY;
        public float radius;

        private RevealInfo() {
        }

        public RevealInfo(float centerX, float centerY, float radius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
        }

        public RevealInfo(@NonNull RevealInfo other) {
            this(other.centerX, other.centerY, other.radius);
        }

        public void set(float centerX, float centerY, float radius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
        }

        public void set(@NonNull RevealInfo other) {
            this.set(other.centerX, other.centerY, other.radius);
        }

        public boolean isInvalid() {
            return this.radius == Float.MAX_VALUE;
        }
    }
}

