/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.UtcDates;
import java.util.Arrays;

public class DateValidatorPointBackward
implements CalendarConstraints.DateValidator {
    private final long point;
    public static final Parcelable.Creator<DateValidatorPointBackward> CREATOR = new Parcelable.Creator<DateValidatorPointBackward>(){

        @NonNull
        public DateValidatorPointBackward createFromParcel(@NonNull Parcel source) {
            return new DateValidatorPointBackward(source.readLong());
        }

        @NonNull
        public DateValidatorPointBackward[] newArray(int size) {
            return new DateValidatorPointBackward[size];
        }
    };

    private DateValidatorPointBackward(long point) {
        this.point = point;
    }

    @NonNull
    public static DateValidatorPointBackward before(long point) {
        return new DateValidatorPointBackward(point);
    }

    @NonNull
    public static DateValidatorPointBackward now() {
        return DateValidatorPointBackward.before(UtcDates.getTodayCalendar().getTimeInMillis());
    }

    @Override
    public boolean isValid(long date) {
        return date <= this.point;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.point);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateValidatorPointBackward)) {
            return false;
        }
        DateValidatorPointBackward that = (DateValidatorPointBackward)o;
        return this.point == that.point;
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{this.point};
        return Arrays.hashCode(hashedFields);
    }
}

