/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.slider;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.slider.BaseOnChangeListener;
import com.google.android.material.slider.BaseOnSliderTouchListener;
import com.google.android.material.slider.BaseSlider;

public class Slider
extends BaseSlider<Slider, OnChangeListener, OnSliderTouchListener> {
    public Slider(@NonNull Context context) {
        this(context, null);
    }

    public Slider(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sliderStyle);
    }

    public Slider(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{16842788});
        if (a.hasValue(0)) {
            this.setValue(a.getFloat(0, 0.0f));
        }
        a.recycle();
    }

    public float getValue() {
        return this.getValues().get(0).floatValue();
    }

    public void setValue(float value) {
        this.setValues(Float.valueOf(value));
    }

    @Override
    protected boolean pickActiveThumb() {
        if (this.getActiveThumbIndex() != -1) {
            return true;
        }
        this.setActiveThumbIndex(0);
        return true;
    }

    public static interface OnSliderTouchListener
    extends BaseOnSliderTouchListener<Slider> {
    }

    public static interface OnChangeListener
    extends BaseOnChangeListener<Slider> {
    }
}

