/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tabs;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.Pools;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.PointerIconCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.tabs.ElasticTabIndicatorInterpolator;
import com.google.android.material.tabs.TabIndicatorInterpolator;
import com.google.android.material.tabs.TabItem;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

@ViewPager.DecorView
public class TabLayout
extends HorizontalScrollView {
    private static final int DEF_STYLE_RES = R.style.Widget_Design_TabLayout;
    @Dimension(unit=0)
    private static final int DEFAULT_HEIGHT_WITH_TEXT_ICON = 72;
    @Dimension(unit=0)
    static final int DEFAULT_GAP_TEXT_ICON = 8;
    @Dimension(unit=0)
    private static final int DEFAULT_HEIGHT = 48;
    @Dimension(unit=0)
    private static final int TAB_MIN_WIDTH_MARGIN = 56;
    @Dimension(unit=0)
    static final int FIXED_WRAP_GUTTER_MIN = 16;
    private static final int INVALID_WIDTH = -1;
    private static final int ANIMATION_DURATION = 300;
    private static final Pools.Pool<Tab> tabPool = new Pools.SynchronizedPool(16);
    private static final String LOG_TAG = "TabLayout";
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    public static final int MODE_AUTO = 2;
    public static final int TAB_LABEL_VISIBILITY_UNLABELED = 0;
    public static final int TAB_LABEL_VISIBILITY_LABELED = 1;
    public static final int GRAVITY_FILL = 0;
    public static final int GRAVITY_CENTER = 1;
    public static final int GRAVITY_START = 2;
    public static final int INDICATOR_GRAVITY_BOTTOM = 0;
    public static final int INDICATOR_GRAVITY_CENTER = 1;
    public static final int INDICATOR_GRAVITY_TOP = 2;
    public static final int INDICATOR_GRAVITY_STRETCH = 3;
    public static final int INDICATOR_ANIMATION_MODE_LINEAR = 0;
    public static final int INDICATOR_ANIMATION_MODE_ELASTIC = 1;
    private final ArrayList<Tab> tabs = new ArrayList();
    @Nullable
    private Tab selectedTab;
    @NonNull
    final SlidingTabIndicator slidingTabIndicator;
    int tabPaddingStart;
    int tabPaddingTop;
    int tabPaddingEnd;
    int tabPaddingBottom;
    int tabTextAppearance;
    ColorStateList tabTextColors;
    ColorStateList tabIconTint;
    ColorStateList tabRippleColorStateList;
    @NonNull
    Drawable tabSelectedIndicator = new GradientDrawable();
    private int tabSelectedIndicatorColor = 0;
    PorterDuff.Mode tabIconTintMode;
    float tabTextSize;
    float tabTextMultiLineSize;
    final int tabBackgroundResId;
    int tabMaxWidth = Integer.MAX_VALUE;
    private final int requestedTabMinWidth;
    private final int requestedTabMaxWidth;
    private final int scrollableTabMinWidth;
    private int contentInsetStart;
    int tabGravity;
    int tabIndicatorAnimationDuration;
    int tabIndicatorGravity;
    int mode;
    boolean inlineLabel;
    boolean tabIndicatorFullWidth;
    int tabIndicatorAnimationMode;
    boolean unboundedRipple;
    private TabIndicatorInterpolator tabIndicatorInterpolator;
    @Nullable
    private BaseOnTabSelectedListener selectedListener;
    private final ArrayList<BaseOnTabSelectedListener> selectedListeners = new ArrayList();
    @Nullable
    private BaseOnTabSelectedListener currentVpSelectedListener;
    private ValueAnimator scrollAnimator;
    @Nullable
    ViewPager viewPager;
    @Nullable
    private PagerAdapter pagerAdapter;
    private DataSetObserver pagerAdapterObserver;
    private TabLayoutOnPageChangeListener pageChangeListener;
    private AdapterChangeListener adapterChangeListener;
    private boolean setupViewPagerImplicitly;
    private final Pools.Pool<TabView> tabViewPool = new Pools.SimplePool(12);

    public TabLayout(@NonNull Context context) {
        this(context, null);
    }

    public TabLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.tabStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.setHorizontalScrollBarEnabled(false);
        this.slidingTabIndicator = new SlidingTabIndicator(context);
        super.addView((View)this.slidingTabIndicator, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.TabLayout, defStyleAttr, DEF_STYLE_RES, R.styleable.TabLayout_tabTextAppearance);
        if (this.getBackground() instanceof ColorDrawable) {
            ColorDrawable background = (ColorDrawable)this.getBackground();
            MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
            materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)background.getColor()));
            materialShapeDrawable.initializeElevationOverlay(context);
            materialShapeDrawable.setElevation(ViewCompat.getElevation((View)this));
            ViewCompat.setBackground((View)this, (Drawable)materialShapeDrawable);
        }
        this.setSelectedTabIndicator(MaterialResources.getDrawable(context, a, R.styleable.TabLayout_tabIndicator));
        this.setSelectedTabIndicatorColor(a.getColor(R.styleable.TabLayout_tabIndicatorColor, 0));
        this.slidingTabIndicator.setSelectedIndicatorHeight(a.getDimensionPixelSize(R.styleable.TabLayout_tabIndicatorHeight, -1));
        this.setSelectedTabIndicatorGravity(a.getInt(R.styleable.TabLayout_tabIndicatorGravity, 0));
        this.setTabIndicatorFullWidth(a.getBoolean(R.styleable.TabLayout_tabIndicatorFullWidth, true));
        this.setTabIndicatorAnimationMode(a.getInt(R.styleable.TabLayout_tabIndicatorAnimationMode, 0));
        this.tabPaddingEnd = this.tabPaddingBottom = a.getDimensionPixelSize(R.styleable.TabLayout_tabPadding, 0);
        this.tabPaddingTop = this.tabPaddingBottom;
        this.tabPaddingStart = this.tabPaddingBottom;
        this.tabPaddingStart = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingStart, this.tabPaddingStart);
        this.tabPaddingTop = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingTop, this.tabPaddingTop);
        this.tabPaddingEnd = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingEnd, this.tabPaddingEnd);
        this.tabPaddingBottom = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingBottom, this.tabPaddingBottom);
        this.tabTextAppearance = a.getResourceId(R.styleable.TabLayout_tabTextAppearance, R.style.TextAppearance_Design_Tab);
        TypedArray ta = context.obtainStyledAttributes(this.tabTextAppearance, R.styleable.TextAppearance);
        try {
            this.tabTextSize = ta.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
            this.tabTextColors = MaterialResources.getColorStateList(context, ta, R.styleable.TextAppearance_android_textColor);
        }
        finally {
            ta.recycle();
        }
        if (a.hasValue(R.styleable.TabLayout_tabTextColor)) {
            this.tabTextColors = MaterialResources.getColorStateList(context, a, R.styleable.TabLayout_tabTextColor);
        }
        if (a.hasValue(R.styleable.TabLayout_tabSelectedTextColor)) {
            int selected = a.getColor(R.styleable.TabLayout_tabSelectedTextColor, 0);
            this.tabTextColors = TabLayout.createColorStateList(this.tabTextColors.getDefaultColor(), selected);
        }
        this.tabIconTint = MaterialResources.getColorStateList(context, a, R.styleable.TabLayout_tabIconTint);
        this.tabIconTintMode = ViewUtils.parseTintMode(a.getInt(R.styleable.TabLayout_tabIconTintMode, -1), null);
        this.tabRippleColorStateList = MaterialResources.getColorStateList(context, a, R.styleable.TabLayout_tabRippleColor);
        this.tabIndicatorAnimationDuration = a.getInt(R.styleable.TabLayout_tabIndicatorAnimationDuration, 300);
        this.requestedTabMinWidth = a.getDimensionPixelSize(R.styleable.TabLayout_tabMinWidth, -1);
        this.requestedTabMaxWidth = a.getDimensionPixelSize(R.styleable.TabLayout_tabMaxWidth, -1);
        this.tabBackgroundResId = a.getResourceId(R.styleable.TabLayout_tabBackground, 0);
        this.contentInsetStart = a.getDimensionPixelSize(R.styleable.TabLayout_tabContentStart, 0);
        this.mode = a.getInt(R.styleable.TabLayout_tabMode, 1);
        this.tabGravity = a.getInt(R.styleable.TabLayout_tabGravity, 0);
        this.inlineLabel = a.getBoolean(R.styleable.TabLayout_tabInlineLabel, false);
        this.unboundedRipple = a.getBoolean(R.styleable.TabLayout_tabUnboundedRipple, false);
        a.recycle();
        Resources res = this.getResources();
        this.tabTextMultiLineSize = res.getDimensionPixelSize(R.dimen.design_tab_text_size_2line);
        this.scrollableTabMinWidth = res.getDimensionPixelSize(R.dimen.design_tab_scrollable_min_width);
        this.applyModeAndGravity();
    }

    public void setSelectedTabIndicatorColor(@ColorInt int color2) {
        this.tabSelectedIndicatorColor = color2;
    }

    @Deprecated
    public void setSelectedTabIndicatorHeight(int height) {
        this.slidingTabIndicator.setSelectedIndicatorHeight(height);
    }

    public void setScrollPosition(int position, float positionOffset, boolean updateSelectedText) {
        this.setScrollPosition(position, positionOffset, updateSelectedText, true);
    }

    public void setScrollPosition(int position, float positionOffset, boolean updateSelectedText, boolean updateIndicatorPosition) {
        int roundedPosition = Math.round((float)position + positionOffset);
        if (roundedPosition < 0 || roundedPosition >= this.slidingTabIndicator.getChildCount()) {
            return;
        }
        if (updateIndicatorPosition) {
            this.slidingTabIndicator.setIndicatorPositionFromTabPosition(position, positionOffset);
        }
        if (this.scrollAnimator != null && this.scrollAnimator.isRunning()) {
            this.scrollAnimator.cancel();
        }
        this.scrollTo(this.calculateScrollXForTab(position, positionOffset), 0);
        if (updateSelectedText) {
            this.setSelectedTabView(roundedPosition);
        }
    }

    public void addTab(@NonNull Tab tab) {
        this.addTab(tab, this.tabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, int position) {
        this.addTab(tab, position, this.tabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, boolean setSelected) {
        this.addTab(tab, this.tabs.size(), setSelected);
    }

    public void addTab(@NonNull Tab tab, int position, boolean setSelected) {
        if (tab.parent != this) {
            throw new IllegalArgumentException("Tab belongs to a different TabLayout.");
        }
        this.configureTab(tab, position);
        this.addTabView(tab);
        if (setSelected) {
            tab.select();
        }
    }

    private void addTabFromItemView(@NonNull TabItem item) {
        Tab tab = this.newTab();
        if (item.text != null) {
            tab.setText(item.text);
        }
        if (item.icon != null) {
            tab.setIcon(item.icon);
        }
        if (item.customLayout != 0) {
            tab.setCustomView(item.customLayout);
        }
        if (!TextUtils.isEmpty((CharSequence)item.getContentDescription())) {
            tab.setContentDescription(item.getContentDescription());
        }
        this.addTab(tab);
    }

    @Deprecated
    public void setOnTabSelectedListener(@Nullable OnTabSelectedListener listener) {
        this.setOnTabSelectedListener((BaseOnTabSelectedListener)listener);
    }

    @Deprecated
    public void setOnTabSelectedListener(@Nullable BaseOnTabSelectedListener listener) {
        if (this.selectedListener != null) {
            this.removeOnTabSelectedListener(this.selectedListener);
        }
        this.selectedListener = listener;
        if (listener != null) {
            this.addOnTabSelectedListener(listener);
        }
    }

    public void addOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        this.addOnTabSelectedListener((BaseOnTabSelectedListener)listener);
    }

    @Deprecated
    public void addOnTabSelectedListener(@Nullable BaseOnTabSelectedListener listener) {
        if (!this.selectedListeners.contains(listener)) {
            this.selectedListeners.add(listener);
        }
    }

    public void removeOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        this.removeOnTabSelectedListener((BaseOnTabSelectedListener)listener);
    }

    @Deprecated
    public void removeOnTabSelectedListener(@Nullable BaseOnTabSelectedListener listener) {
        this.selectedListeners.remove(listener);
    }

    public void clearOnTabSelectedListeners() {
        this.selectedListeners.clear();
    }

    @NonNull
    public Tab newTab() {
        Tab tab = this.createTabFromPool();
        tab.parent = this;
        tab.view = this.createTabView(tab);
        if (tab.id != -1) {
            tab.view.setId(tab.id);
        }
        return tab;
    }

    protected Tab createTabFromPool() {
        Tab tab = (Tab)tabPool.acquire();
        if (tab == null) {
            tab = new Tab();
        }
        return tab;
    }

    protected boolean releaseFromTabPool(Tab tab) {
        return tabPool.release((Object)tab);
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    @Nullable
    public Tab getTabAt(int index) {
        return index < 0 || index >= this.getTabCount() ? null : this.tabs.get(index);
    }

    public int getSelectedTabPosition() {
        return this.selectedTab != null ? this.selectedTab.getPosition() : -1;
    }

    public void removeTab(@NonNull Tab tab) {
        if (tab.parent != this) {
            throw new IllegalArgumentException("Tab does not belong to this TabLayout.");
        }
        this.removeTabAt(tab.getPosition());
    }

    public void removeTabAt(int position) {
        int selectedTabPosition = this.selectedTab != null ? this.selectedTab.getPosition() : 0;
        this.removeTabViewAt(position);
        Tab removedTab = this.tabs.remove(position);
        if (removedTab != null) {
            removedTab.reset();
            this.releaseFromTabPool(removedTab);
        }
        int newTabCount = this.tabs.size();
        for (int i = position; i < newTabCount; ++i) {
            this.tabs.get(i).setPosition(i);
        }
        if (selectedTabPosition == position) {
            this.selectTab(this.tabs.isEmpty() ? null : this.tabs.get(Math.max(0, position - 1)));
        }
    }

    public void removeAllTabs() {
        for (int i = this.slidingTabIndicator.getChildCount() - 1; i >= 0; --i) {
            this.removeTabViewAt(i);
        }
        Iterator<Tab> i = this.tabs.iterator();
        while (i.hasNext()) {
            Tab tab = i.next();
            i.remove();
            tab.reset();
            this.releaseFromTabPool(tab);
        }
        this.selectedTab = null;
    }

    public void setTabMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.applyModeAndGravity();
        }
    }

    public int getTabMode() {
        return this.mode;
    }

    public void setTabGravity(int gravity) {
        if (this.tabGravity != gravity) {
            this.tabGravity = gravity;
            this.applyModeAndGravity();
        }
    }

    public int getTabGravity() {
        return this.tabGravity;
    }

    public void setSelectedTabIndicatorGravity(int indicatorGravity) {
        if (this.tabIndicatorGravity != indicatorGravity) {
            this.tabIndicatorGravity = indicatorGravity;
            ViewCompat.postInvalidateOnAnimation((View)this.slidingTabIndicator);
        }
    }

    public int getTabIndicatorGravity() {
        return this.tabIndicatorGravity;
    }

    public void setTabIndicatorAnimationMode(int tabIndicatorAnimationMode) {
        this.tabIndicatorAnimationMode = tabIndicatorAnimationMode;
        switch (tabIndicatorAnimationMode) {
            case 0: {
                this.tabIndicatorInterpolator = new TabIndicatorInterpolator();
                break;
            }
            case 1: {
                this.tabIndicatorInterpolator = new ElasticTabIndicatorInterpolator();
                break;
            }
            default: {
                throw new IllegalArgumentException(tabIndicatorAnimationMode + " is not a valid TabIndicatorAnimationMode");
            }
        }
    }

    public int getTabIndicatorAnimationMode() {
        return this.tabIndicatorAnimationMode;
    }

    public void setTabIndicatorFullWidth(boolean tabIndicatorFullWidth) {
        this.tabIndicatorFullWidth = tabIndicatorFullWidth;
        ViewCompat.postInvalidateOnAnimation((View)this.slidingTabIndicator);
    }

    public boolean isTabIndicatorFullWidth() {
        return this.tabIndicatorFullWidth;
    }

    public void setInlineLabel(boolean inline) {
        if (this.inlineLabel != inline) {
            this.inlineLabel = inline;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                if (!(child instanceof TabView)) continue;
                ((TabView)child).updateOrientation();
            }
            this.applyModeAndGravity();
        }
    }

    public void setInlineLabelResource(@BoolRes int inlineResourceId) {
        this.setInlineLabel(this.getResources().getBoolean(inlineResourceId));
    }

    public boolean isInlineLabel() {
        return this.inlineLabel;
    }

    public void setUnboundedRipple(boolean unboundedRipple) {
        if (this.unboundedRipple != unboundedRipple) {
            this.unboundedRipple = unboundedRipple;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                if (!(child instanceof TabView)) continue;
                ((TabView)child).updateBackgroundDrawable(this.getContext());
            }
        }
    }

    public void setUnboundedRippleResource(@BoolRes int unboundedRippleResourceId) {
        this.setUnboundedRipple(this.getResources().getBoolean(unboundedRippleResourceId));
    }

    public boolean hasUnboundedRipple() {
        return this.unboundedRipple;
    }

    public void setTabTextColors(@Nullable ColorStateList textColor) {
        if (this.tabTextColors != textColor) {
            this.tabTextColors = textColor;
            this.updateAllTabs();
        }
    }

    @Nullable
    public ColorStateList getTabTextColors() {
        return this.tabTextColors;
    }

    public void setTabTextColors(int normalColor, int selectedColor) {
        this.setTabTextColors(TabLayout.createColorStateList(normalColor, selectedColor));
    }

    public void setTabIconTint(@Nullable ColorStateList iconTint) {
        if (this.tabIconTint != iconTint) {
            this.tabIconTint = iconTint;
            this.updateAllTabs();
        }
    }

    public void setTabIconTintResource(@ColorRes int iconTintResourceId) {
        this.setTabIconTint(AppCompatResources.getColorStateList((Context)this.getContext(), (int)iconTintResourceId));
    }

    @Nullable
    public ColorStateList getTabIconTint() {
        return this.tabIconTint;
    }

    @Nullable
    public ColorStateList getTabRippleColor() {
        return this.tabRippleColorStateList;
    }

    public void setTabRippleColor(@Nullable ColorStateList color2) {
        if (this.tabRippleColorStateList != color2) {
            this.tabRippleColorStateList = color2;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                if (!(child instanceof TabView)) continue;
                ((TabView)child).updateBackgroundDrawable(this.getContext());
            }
        }
    }

    public void setTabRippleColorResource(@ColorRes int tabRippleColorResourceId) {
        this.setTabRippleColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)tabRippleColorResourceId));
    }

    @NonNull
    public Drawable getTabSelectedIndicator() {
        return this.tabSelectedIndicator;
    }

    public void setSelectedTabIndicator(@Nullable Drawable tabSelectedIndicator) {
        if (this.tabSelectedIndicator != tabSelectedIndicator) {
            this.tabSelectedIndicator = tabSelectedIndicator != null ? tabSelectedIndicator : new GradientDrawable();
        }
    }

    public void setSelectedTabIndicator(@DrawableRes int tabSelectedIndicatorResourceId) {
        if (tabSelectedIndicatorResourceId != 0) {
            this.setSelectedTabIndicator(AppCompatResources.getDrawable((Context)this.getContext(), (int)tabSelectedIndicatorResourceId));
        } else {
            this.setSelectedTabIndicator(null);
        }
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        this.setupWithViewPager(viewPager, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean autoRefresh) {
        this.setupWithViewPager(viewPager, autoRefresh, false);
    }

    private void setupWithViewPager(@Nullable ViewPager viewPager, boolean autoRefresh, boolean implicitSetup) {
        if (this.viewPager != null) {
            if (this.pageChangeListener != null) {
                this.viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
            }
            if (this.adapterChangeListener != null) {
                this.viewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.adapterChangeListener);
            }
        }
        if (this.currentVpSelectedListener != null) {
            this.removeOnTabSelectedListener(this.currentVpSelectedListener);
            this.currentVpSelectedListener = null;
        }
        if (viewPager != null) {
            this.viewPager = viewPager;
            if (this.pageChangeListener == null) {
                this.pageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            this.pageChangeListener.reset();
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
            this.currentVpSelectedListener = new ViewPagerOnTabSelectedListener(viewPager);
            this.addOnTabSelectedListener(this.currentVpSelectedListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.setPagerAdapter(adapter, autoRefresh);
            }
            if (this.adapterChangeListener == null) {
                this.adapterChangeListener = new AdapterChangeListener();
            }
            this.adapterChangeListener.setAutoRefresh(autoRefresh);
            viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.adapterChangeListener);
            this.setScrollPosition(viewPager.getCurrentItem(), 0.0f, true);
        } else {
            this.viewPager = null;
            this.setPagerAdapter(null, false);
        }
        this.setupViewPagerImplicitly = implicitSetup;
    }

    @Deprecated
    public void setTabsFromPagerAdapter(@Nullable PagerAdapter adapter) {
        this.setPagerAdapter(adapter, false);
    }

    public boolean shouldDelayChildPressedState() {
        return this.getTabScrollRange() > 0;
    }

    protected void onAttachedToWindow() {
        ViewParent vp;
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
        if (this.viewPager == null && (vp = this.getParent()) instanceof ViewPager) {
            this.setupWithViewPager((ViewPager)vp, true, true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.setupViewPagerImplicitly) {
            this.setupWithViewPager(null);
            this.setupViewPagerImplicitly = false;
        }
    }

    private int getTabScrollRange() {
        return Math.max(0, this.slidingTabIndicator.getWidth() - this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
    }

    void setPagerAdapter(@Nullable PagerAdapter adapter, boolean addObserver) {
        if (this.pagerAdapter != null && this.pagerAdapterObserver != null) {
            this.pagerAdapter.unregisterDataSetObserver(this.pagerAdapterObserver);
        }
        this.pagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.pagerAdapterObserver == null) {
                this.pagerAdapterObserver = new PagerAdapterObserver();
            }
            adapter.registerDataSetObserver(this.pagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    void populateFromPagerAdapter() {
        this.removeAllTabs();
        if (this.pagerAdapter != null) {
            int curItem;
            int adapterCount = this.pagerAdapter.getCount();
            for (int i = 0; i < adapterCount; ++i) {
                this.addTab(this.newTab().setText(this.pagerAdapter.getPageTitle(i)), false);
            }
            if (this.viewPager != null && adapterCount > 0 && (curItem = this.viewPager.getCurrentItem()) != this.getSelectedTabPosition() && curItem < this.getTabCount()) {
                this.selectTab(this.getTabAt(curItem));
            }
        }
    }

    private void updateAllTabs() {
        int z = this.tabs.size();
        for (int i = 0; i < z; ++i) {
            this.tabs.get(i).updateView();
        }
    }

    @NonNull
    private TabView createTabView(@NonNull Tab tab) {
        TabView tabView;
        TabView tabView2 = tabView = this.tabViewPool != null ? (TabView)((Object)this.tabViewPool.acquire()) : null;
        if (tabView == null) {
            tabView = new TabView(this.getContext());
        }
        tabView.setTab(tab);
        tabView.setFocusable(true);
        tabView.setMinimumWidth(this.getTabMinWidth());
        if (TextUtils.isEmpty((CharSequence)tab.contentDesc)) {
            tabView.setContentDescription(tab.text);
        } else {
            tabView.setContentDescription(tab.contentDesc);
        }
        return tabView;
    }

    private void configureTab(@NonNull Tab tab, int position) {
        tab.setPosition(position);
        this.tabs.add(position, tab);
        int count = this.tabs.size();
        for (int i = position + 1; i < count; ++i) {
            this.tabs.get(i).setPosition(i);
        }
    }

    private void addTabView(@NonNull Tab tab) {
        TabView tabView = tab.view;
        tabView.setSelected(false);
        tabView.setActivated(false);
        this.slidingTabIndicator.addView((View)tabView, tab.getPosition(), (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
    }

    public void addView(View child) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index) {
        this.addViewInternal(child);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    private void addViewInternal(View child) {
        if (!(child instanceof TabItem)) {
            throw new IllegalArgumentException("Only TabItem instances can be added to TabLayout");
        }
        this.addTabFromItemView((TabItem)child);
    }

    @NonNull
    private LinearLayout.LayoutParams createLayoutParamsForTabs() {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -1);
        this.updateTabViewLayoutParams(lp);
        return lp;
    }

    private void updateTabViewLayoutParams(@NonNull LinearLayout.LayoutParams lp) {
        if (this.mode == 1 && this.tabGravity == 0) {
            lp.width = 0;
            lp.weight = 1.0f;
        } else {
            lp.width = -2;
            lp.weight = 0.0f;
        }
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        MaterialShapeUtils.setElevation((View)this, elevation);
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
        infoCompat.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)1, (int)this.getTabCount(), (boolean)false, (int)1));
    }

    protected void onDraw(@NonNull Canvas canvas) {
        for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
            View tabView = this.slidingTabIndicator.getChildAt(i);
            if (!(tabView instanceof TabView)) continue;
            ((TabView)tabView).drawBackground(canvas);
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int idealHeight = Math.round(ViewUtils.dpToPx(this.getContext(), this.getDefaultHeight()));
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: {
                if (this.getChildCount() != 1 || View.MeasureSpec.getSize((int)heightMeasureSpec) < idealHeight) break;
                this.getChildAt(0).setMinimumHeight(idealHeight);
                break;
            }
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(idealHeight + this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000);
                break;
            }
        }
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0) {
            this.tabMaxWidth = this.requestedTabMaxWidth > 0 ? this.requestedTabMaxWidth : (int)((float)specWidth - ViewUtils.dpToPx(this.getContext(), 56));
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() == 1) {
            View child = this.getChildAt(0);
            boolean remeasure = false;
            switch (this.mode) {
                case 0: 
                case 2: {
                    remeasure = child.getMeasuredWidth() < this.getMeasuredWidth();
                    break;
                }
                case 1: {
                    boolean bl = remeasure = child.getMeasuredWidth() != this.getMeasuredWidth();
                }
            }
            if (remeasure) {
                int childHeightMeasureSpec = TabLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)child.getLayoutParams().height);
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private void removeTabViewAt(int position) {
        TabView view = (TabView)this.slidingTabIndicator.getChildAt(position);
        this.slidingTabIndicator.removeViewAt(position);
        if (view != null) {
            view.reset();
            this.tabViewPool.release((Object)view);
        }
        this.requestLayout();
    }

    private void animateToTab(int newPosition) {
        int targetScrollX;
        if (newPosition == -1) {
            return;
        }
        if (this.getWindowToken() == null || !ViewCompat.isLaidOut((View)this) || this.slidingTabIndicator.childrenNeedLayout()) {
            this.setScrollPosition(newPosition, 0.0f, true);
            return;
        }
        int startScrollX = this.getScrollX();
        if (startScrollX != (targetScrollX = this.calculateScrollXForTab(newPosition, 0.0f))) {
            this.ensureScrollAnimator();
            this.scrollAnimator.setIntValues(new int[]{startScrollX, targetScrollX});
            this.scrollAnimator.start();
        }
        this.slidingTabIndicator.animateIndicatorToPosition(newPosition, this.tabIndicatorAnimationDuration);
    }

    private void ensureScrollAnimator() {
        if (this.scrollAnimator == null) {
            this.scrollAnimator = new ValueAnimator();
            this.scrollAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.scrollAnimator.setDuration((long)this.tabIndicatorAnimationDuration);
            this.scrollAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(@NonNull ValueAnimator animator2) {
                    TabLayout.this.scrollTo((Integer)animator2.getAnimatedValue(), 0);
                }
            });
        }
    }

    void setScrollAnimatorListener(Animator.AnimatorListener listener) {
        this.ensureScrollAnimator();
        this.scrollAnimator.addListener(listener);
    }

    private void setSelectedTabView(int position) {
        int tabCount = this.slidingTabIndicator.getChildCount();
        if (position < tabCount) {
            for (int i = 0; i < tabCount; ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                child.setSelected(i == position);
                child.setActivated(i == position);
            }
        }
    }

    public void selectTab(@Nullable Tab tab) {
        this.selectTab(tab, true);
    }

    public void selectTab(@Nullable Tab tab, boolean updateIndicator) {
        Tab currentTab = this.selectedTab;
        if (currentTab == tab) {
            if (currentTab != null) {
                this.dispatchTabReselected(tab);
                this.animateToTab(tab.getPosition());
            }
        } else {
            int newPosition;
            int n = newPosition = tab != null ? tab.getPosition() : -1;
            if (updateIndicator) {
                if ((currentTab == null || currentTab.getPosition() == -1) && newPosition != -1) {
                    this.setScrollPosition(newPosition, 0.0f, true);
                } else {
                    this.animateToTab(newPosition);
                }
                if (newPosition != -1) {
                    this.setSelectedTabView(newPosition);
                }
            }
            this.selectedTab = tab;
            if (currentTab != null) {
                this.dispatchTabUnselected(currentTab);
            }
            if (tab != null) {
                this.dispatchTabSelected(tab);
            }
        }
    }

    private void dispatchTabSelected(@NonNull Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabSelected(tab);
        }
    }

    private void dispatchTabUnselected(@NonNull Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabUnselected(tab);
        }
    }

    private void dispatchTabReselected(@NonNull Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabReselected(tab);
        }
    }

    private int calculateScrollXForTab(int position, float positionOffset) {
        if (this.mode == 0 || this.mode == 2) {
            View selectedChild = this.slidingTabIndicator.getChildAt(position);
            View nextChild = position + 1 < this.slidingTabIndicator.getChildCount() ? this.slidingTabIndicator.getChildAt(position + 1) : null;
            int selectedWidth = selectedChild != null ? selectedChild.getWidth() : 0;
            int nextWidth = nextChild != null ? nextChild.getWidth() : 0;
            int scrollBase = selectedChild.getLeft() + selectedWidth / 2 - this.getWidth() / 2;
            int scrollOffset = (int)((float)(selectedWidth + nextWidth) * 0.5f * positionOffset);
            return ViewCompat.getLayoutDirection((View)this) == 0 ? scrollBase + scrollOffset : scrollBase - scrollOffset;
        }
        return 0;
    }

    private void applyModeAndGravity() {
        int paddingStart = 0;
        if (this.mode == 0 || this.mode == 2) {
            paddingStart = Math.max(0, this.contentInsetStart - this.tabPaddingStart);
        }
        ViewCompat.setPaddingRelative((View)this.slidingTabIndicator, (int)paddingStart, (int)0, (int)0, (int)0);
        switch (this.mode) {
            case 1: 
            case 2: {
                if (this.tabGravity == 2) {
                    Log.w((String)LOG_TAG, (String)"GRAVITY_START is not supported with the current tab mode, GRAVITY_CENTER will be used instead");
                }
                this.slidingTabIndicator.setGravity(1);
                break;
            }
            case 0: {
                this.applyGravityForModeScrollable(this.tabGravity);
            }
        }
        this.updateTabViews(true);
    }

    private void applyGravityForModeScrollable(int tabGravity) {
        switch (tabGravity) {
            case 1: {
                this.slidingTabIndicator.setGravity(1);
                break;
            }
            case 0: {
                Log.w((String)LOG_TAG, (String)"MODE_SCROLLABLE + GRAVITY_FILL is not supported, GRAVITY_START will be used instead");
            }
            case 2: {
                this.slidingTabIndicator.setGravity(0x800003);
                break;
            }
        }
    }

    void updateTabViews(boolean requestLayout) {
        for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
            View child = this.slidingTabIndicator.getChildAt(i);
            child.setMinimumWidth(this.getTabMinWidth());
            this.updateTabViewLayoutParams((LinearLayout.LayoutParams)child.getLayoutParams());
            if (!requestLayout) continue;
            child.requestLayout();
        }
    }

    @NonNull
    private static ColorStateList createColorStateList(int defaultColor, int selectedColor) {
        int[][] states = new int[2][];
        int[] colors = new int[2];
        int i = 0;
        states[i] = SELECTED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = EMPTY_STATE_SET;
        colors[i] = defaultColor;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    @Dimension(unit=0)
    private int getDefaultHeight() {
        boolean hasIconAndText = false;
        int count = this.tabs.size();
        for (int i = 0; i < count; ++i) {
            Tab tab = this.tabs.get(i);
            if (tab == null || tab.getIcon() == null || TextUtils.isEmpty((CharSequence)tab.getText())) continue;
            hasIconAndText = true;
            break;
        }
        return hasIconAndText && !this.inlineLabel ? 72 : 48;
    }

    private int getTabMinWidth() {
        if (this.requestedTabMinWidth != -1) {
            return this.requestedTabMinWidth;
        }
        return this.mode == 0 || this.mode == 2 ? this.scrollableTabMinWidth : 0;
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return this.generateDefaultLayoutParams();
    }

    int getTabMaxWidth() {
        return this.tabMaxWidth;
    }

    private class AdapterChangeListener
    implements ViewPager.OnAdapterChangeListener {
        private boolean autoRefresh;

        AdapterChangeListener() {
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            if (TabLayout.this.viewPager == viewPager) {
                TabLayout.this.setPagerAdapter(newAdapter, this.autoRefresh);
            }
        }

        void setAutoRefresh(boolean autoRefresh) {
            this.autoRefresh = autoRefresh;
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        PagerAdapterObserver() {
        }

        public void onChanged() {
            TabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            TabLayout.this.populateFromPagerAdapter();
        }
    }

    public static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager viewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.viewPager = viewPager;
        }

        @Override
        public void onTabSelected(@NonNull Tab tab) {
            this.viewPager.setCurrentItem(tab.getPosition());
        }

        @Override
        public void onTabUnselected(Tab tab) {
        }

        @Override
        public void onTabReselected(Tab tab) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        @NonNull
        private final WeakReference<TabLayout> tabLayoutRef;
        private int previousScrollState;
        private int scrollState;

        public TabLayoutOnPageChangeListener(TabLayout tabLayout) {
            this.tabLayoutRef = new WeakReference<TabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int state) {
            this.previousScrollState = this.scrollState;
            this.scrollState = state;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            TabLayout tabLayout = (TabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null) {
                boolean updateText = this.scrollState != 2 || this.previousScrollState == 1;
                boolean updateIndicator = this.scrollState != 2 || this.previousScrollState != 0;
                tabLayout.setScrollPosition(position, positionOffset, updateText, updateIndicator);
            }
        }

        public void onPageSelected(int position) {
            TabLayout tabLayout = (TabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != position && position < tabLayout.getTabCount()) {
                boolean updateIndicator = this.scrollState == 0 || this.scrollState == 2 && this.previousScrollState == 0;
                tabLayout.selectTab(tabLayout.getTabAt(position), updateIndicator);
            }
        }

        void reset() {
            this.scrollState = 0;
            this.previousScrollState = 0;
        }
    }

    class SlidingTabIndicator
    extends LinearLayout {
        ValueAnimator indicatorAnimator;
        int selectedPosition;
        float selectionOffset;
        private int layoutDirection;

        SlidingTabIndicator(Context context) {
            super(context);
            this.selectedPosition = -1;
            this.layoutDirection = -1;
            this.setWillNotDraw(false);
        }

        void setSelectedIndicatorHeight(int height) {
            Rect bounds = TabLayout.this.tabSelectedIndicator.getBounds();
            TabLayout.this.tabSelectedIndicator.setBounds(bounds.left, 0, bounds.right, height);
            this.requestLayout();
        }

        boolean childrenNeedLayout() {
            int z = this.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = this.getChildAt(i);
                if (child.getWidth() > 0) continue;
                return true;
            }
            return false;
        }

        void setIndicatorPositionFromTabPosition(int position, float positionOffset) {
            if (this.indicatorAnimator != null && this.indicatorAnimator.isRunning()) {
                this.indicatorAnimator.cancel();
            }
            this.selectedPosition = position;
            this.selectionOffset = positionOffset;
            View selectedTitle = this.getChildAt(this.selectedPosition);
            View nextTitle = this.getChildAt(this.selectedPosition + 1);
            this.tweenIndicatorPosition(selectedTitle, nextTitle, this.selectionOffset);
        }

        float getIndicatorPosition() {
            return (float)this.selectedPosition + this.selectionOffset;
        }

        public void onRtlPropertiesChanged(int layoutDirection) {
            super.onRtlPropertiesChanged(layoutDirection);
            if (Build.VERSION.SDK_INT < 23 && this.layoutDirection != layoutDirection) {
                this.requestLayout();
                this.layoutDirection = layoutDirection;
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000) {
                return;
            }
            if (TabLayout.this.tabGravity == 1 || TabLayout.this.mode == 2) {
                int count = this.getChildCount();
                int largestTabWidth = 0;
                int z = count;
                for (int i = 0; i < z; ++i) {
                    View child = this.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    largestTabWidth = Math.max(largestTabWidth, child.getMeasuredWidth());
                }
                if (largestTabWidth <= 0) {
                    return;
                }
                int gutter = (int)ViewUtils.dpToPx(this.getContext(), 16);
                boolean remeasure = false;
                if (largestTabWidth * count <= this.getMeasuredWidth() - gutter * 2) {
                    for (int i = 0; i < count; ++i) {
                        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getChildAt(i).getLayoutParams();
                        if (lp.width == largestTabWidth && lp.weight == 0.0f) continue;
                        lp.width = largestTabWidth;
                        lp.weight = 0.0f;
                        remeasure = true;
                    }
                } else {
                    TabLayout.this.tabGravity = 0;
                    TabLayout.this.updateTabViews(false);
                    remeasure = true;
                }
                if (remeasure) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.indicatorAnimator != null && this.indicatorAnimator.isRunning()) {
                this.updateOrRecreateIndicatorAnimation(false, this.selectedPosition, -1);
            } else {
                this.jumpIndicatorToSelectedPosition();
            }
        }

        private void jumpIndicatorToSelectedPosition() {
            View currentView = this.getChildAt(this.selectedPosition);
            TabLayout.this.tabIndicatorInterpolator.setIndicatorBoundsForTab(TabLayout.this, currentView, TabLayout.this.tabSelectedIndicator);
        }

        private void tweenIndicatorPosition(View startTitle, View endTitle, float fraction) {
            boolean hasVisibleTitle;
            boolean bl = hasVisibleTitle = startTitle != null && startTitle.getWidth() > 0;
            if (hasVisibleTitle) {
                TabLayout.this.tabIndicatorInterpolator.setIndicatorBoundsForOffset(TabLayout.this, startTitle, endTitle, fraction, TabLayout.this.tabSelectedIndicator);
            } else {
                TabLayout.this.tabSelectedIndicator.setBounds(-1, TabLayout.this.tabSelectedIndicator.getBounds().top, -1, TabLayout.this.tabSelectedIndicator.getBounds().bottom);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }

        void animateIndicatorToPosition(int position, int duration) {
            if (this.indicatorAnimator != null && this.indicatorAnimator.isRunning()) {
                this.indicatorAnimator.cancel();
            }
            this.updateOrRecreateIndicatorAnimation(true, position, duration);
        }

        private void updateOrRecreateIndicatorAnimation(boolean recreateAnimation, final int position, int duration) {
            final View currentView = this.getChildAt(this.selectedPosition);
            final View targetView = this.getChildAt(position);
            if (targetView == null) {
                this.jumpIndicatorToSelectedPosition();
                return;
            }
            ValueAnimator.AnimatorUpdateListener updateListener = new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(@NonNull ValueAnimator valueAnimator) {
                    SlidingTabIndicator.this.tweenIndicatorPosition(currentView, targetView, valueAnimator.getAnimatedFraction());
                }
            };
            if (recreateAnimation) {
                ValueAnimator animator2 = this.indicatorAnimator = new ValueAnimator();
                animator2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                animator2.setDuration((long)duration);
                animator2.setFloatValues(new float[]{0.0f, 1.0f});
                animator2.addUpdateListener(updateListener);
                animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationStart(Animator animator2) {
                        SlidingTabIndicator.this.selectedPosition = position;
                    }

                    public void onAnimationEnd(Animator animator2) {
                        SlidingTabIndicator.this.selectedPosition = position;
                    }
                });
                animator2.start();
            } else {
                this.indicatorAnimator.removeAllUpdateListeners();
                this.indicatorAnimator.addUpdateListener(updateListener);
            }
        }

        public void draw(@NonNull Canvas canvas) {
            int indicatorHeight = TabLayout.this.tabSelectedIndicator.getBounds().height();
            if (indicatorHeight < 0) {
                indicatorHeight = TabLayout.this.tabSelectedIndicator.getIntrinsicHeight();
            }
            int indicatorTop = 0;
            int indicatorBottom = 0;
            switch (TabLayout.this.tabIndicatorGravity) {
                case 0: {
                    indicatorTop = this.getHeight() - indicatorHeight;
                    indicatorBottom = this.getHeight();
                    break;
                }
                case 1: {
                    indicatorTop = (this.getHeight() - indicatorHeight) / 2;
                    indicatorBottom = (this.getHeight() + indicatorHeight) / 2;
                    break;
                }
                case 2: {
                    indicatorTop = 0;
                    indicatorBottom = indicatorHeight;
                    break;
                }
                case 3: {
                    indicatorTop = 0;
                    indicatorBottom = this.getHeight();
                    break;
                }
            }
            if (TabLayout.this.tabSelectedIndicator.getBounds().width() > 0) {
                Rect indicatorBounds = TabLayout.this.tabSelectedIndicator.getBounds();
                TabLayout.this.tabSelectedIndicator.setBounds(indicatorBounds.left, indicatorTop, indicatorBounds.right, indicatorBottom);
                Drawable indicator = TabLayout.this.tabSelectedIndicator;
                if (TabLayout.this.tabSelectedIndicatorColor != 0) {
                    indicator = DrawableCompat.wrap((Drawable)indicator);
                    if (Build.VERSION.SDK_INT == 21) {
                        indicator.setColorFilter(TabLayout.this.tabSelectedIndicatorColor, PorterDuff.Mode.SRC_IN);
                    } else {
                        DrawableCompat.setTint((Drawable)indicator, (int)TabLayout.this.tabSelectedIndicatorColor);
                    }
                }
                indicator.draw(canvas);
            }
            super.draw(canvas);
        }
    }

    public final class TabView
    extends LinearLayout {
        private Tab tab;
        private TextView textView;
        private ImageView iconView;
        @Nullable
        private View badgeAnchorView;
        @Nullable
        private BadgeDrawable badgeDrawable;
        @Nullable
        private View customView;
        @Nullable
        private TextView customTextView;
        @Nullable
        private ImageView customIconView;
        @Nullable
        private Drawable baseBackgroundDrawable;
        private int defaultMaxLines;

        public TabView(Context context) {
            super(context);
            this.defaultMaxLines = 2;
            this.updateBackgroundDrawable(context);
            ViewCompat.setPaddingRelative((View)this, (int)TabLayout.this.tabPaddingStart, (int)TabLayout.this.tabPaddingTop, (int)TabLayout.this.tabPaddingEnd, (int)TabLayout.this.tabPaddingBottom);
            this.setGravity(17);
            this.setOrientation(TabLayout.this.inlineLabel ? 0 : 1);
            this.setClickable(true);
            ViewCompat.setPointerIcon((View)this, (PointerIconCompat)PointerIconCompat.getSystemIcon((Context)this.getContext(), (int)1002));
        }

        private void updateBackgroundDrawable(Context context) {
            GradientDrawable background;
            if (TabLayout.this.tabBackgroundResId != 0) {
                this.baseBackgroundDrawable = AppCompatResources.getDrawable((Context)context, (int)TabLayout.this.tabBackgroundResId);
                if (this.baseBackgroundDrawable != null && this.baseBackgroundDrawable.isStateful()) {
                    this.baseBackgroundDrawable.setState(this.getDrawableState());
                }
            } else {
                this.baseBackgroundDrawable = null;
            }
            GradientDrawable contentDrawable = new GradientDrawable();
            contentDrawable.setColor(0);
            if (TabLayout.this.tabRippleColorStateList != null) {
                GradientDrawable maskDrawable = new GradientDrawable();
                maskDrawable.setCornerRadius(1.0E-5f);
                maskDrawable.setColor(-1);
                ColorStateList rippleColor = RippleUtils.convertToRippleDrawableColor(TabLayout.this.tabRippleColorStateList);
                if (Build.VERSION.SDK_INT >= 21) {
                    background = new RippleDrawable(rippleColor, (Drawable)(TabLayout.this.unboundedRipple ? null : contentDrawable), (Drawable)(TabLayout.this.unboundedRipple ? null : maskDrawable));
                } else {
                    Drawable rippleDrawable = DrawableCompat.wrap((Drawable)maskDrawable);
                    DrawableCompat.setTintList((Drawable)rippleDrawable, (ColorStateList)rippleColor);
                    background = new LayerDrawable(new Drawable[]{contentDrawable, rippleDrawable});
                }
            } else {
                background = contentDrawable;
            }
            ViewCompat.setBackground((View)this, (Drawable)background);
            TabLayout.this.invalidate();
        }

        private void drawBackground(@NonNull Canvas canvas) {
            if (this.baseBackgroundDrawable != null) {
                this.baseBackgroundDrawable.setBounds(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
                this.baseBackgroundDrawable.draw(canvas);
            }
        }

        protected void drawableStateChanged() {
            super.drawableStateChanged();
            boolean changed = false;
            int[] state = this.getDrawableState();
            if (this.baseBackgroundDrawable != null && this.baseBackgroundDrawable.isStateful()) {
                changed |= this.baseBackgroundDrawable.setState(state);
            }
            if (changed) {
                this.invalidate();
                TabLayout.this.invalidate();
            }
        }

        public boolean performClick() {
            boolean handled = super.performClick();
            if (this.tab != null) {
                if (!handled) {
                    this.playSoundEffect(0);
                }
                this.tab.select();
                return true;
            }
            return handled;
        }

        public void setSelected(boolean selected) {
            boolean changed = this.isSelected() != selected;
            super.setSelected(selected);
            if (changed && selected && Build.VERSION.SDK_INT < 16) {
                this.sendAccessibilityEvent(4);
            }
            if (this.textView != null) {
                this.textView.setSelected(selected);
            }
            if (this.iconView != null) {
                this.iconView.setSelected(selected);
            }
            if (this.customView != null) {
                this.customView.setSelected(selected);
            }
        }

        public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(info);
            if (this.badgeDrawable != null && this.badgeDrawable.isVisible()) {
                CharSequence customContentDescription = this.getContentDescription();
                info.setContentDescription((CharSequence)(customContentDescription + ", " + this.badgeDrawable.getContentDescription()));
            }
            AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
            infoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)this.tab.getPosition(), (int)1, (boolean)false, (boolean)this.isSelected()));
            if (this.isSelected()) {
                infoCompat.setClickable(false);
                infoCompat.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
            }
            infoCompat.setRoleDescription((CharSequence)this.getResources().getString(R.string.item_view_role_description));
        }

        public void onMeasure(int origWidthMeasureSpec, int origHeightMeasureSpec) {
            int specWidthSize = View.MeasureSpec.getSize((int)origWidthMeasureSpec);
            int specWidthMode = View.MeasureSpec.getMode((int)origWidthMeasureSpec);
            int maxWidth = TabLayout.this.getTabMaxWidth();
            int heightMeasureSpec = origHeightMeasureSpec;
            int widthMeasureSpec = maxWidth > 0 && (specWidthMode == 0 || specWidthSize > maxWidth) ? View.MeasureSpec.makeMeasureSpec((int)TabLayout.this.tabMaxWidth, (int)Integer.MIN_VALUE) : origWidthMeasureSpec;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.textView != null) {
                float textSize = TabLayout.this.tabTextSize;
                int maxLines = this.defaultMaxLines;
                if (this.iconView != null && this.iconView.getVisibility() == 0) {
                    maxLines = 1;
                } else if (this.textView != null && this.textView.getLineCount() > 1) {
                    textSize = TabLayout.this.tabTextMultiLineSize;
                }
                float curTextSize = this.textView.getTextSize();
                int curLineCount = this.textView.getLineCount();
                int curMaxLines = TextViewCompat.getMaxLines((TextView)this.textView);
                if (textSize != curTextSize || curMaxLines >= 0 && maxLines != curMaxLines) {
                    Layout layout2;
                    boolean updateTextView = true;
                    if (TabLayout.this.mode == 1 && textSize > curTextSize && curLineCount == 1 && ((layout2 = this.textView.getLayout()) == null || this.approximateLineWidth(layout2, 0, textSize) > (float)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()))) {
                        updateTextView = false;
                    }
                    if (updateTextView) {
                        this.textView.setTextSize(0, textSize);
                        this.textView.setMaxLines(maxLines);
                        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    }
                }
            }
        }

        void setTab(@Nullable Tab tab) {
            if (tab != this.tab) {
                this.tab = tab;
                this.update();
            }
        }

        void reset() {
            this.setTab(null);
            this.setSelected(false);
        }

        final void update() {
            View custom;
            Tab tab = this.tab;
            View view = custom = tab != null ? tab.getCustomView() : null;
            if (custom != null) {
                ViewParent customParent = custom.getParent();
                if (customParent != this) {
                    if (customParent != null) {
                        ((ViewGroup)customParent).removeView(custom);
                    }
                    this.addView(custom);
                }
                this.customView = custom;
                if (this.textView != null) {
                    this.textView.setVisibility(8);
                }
                if (this.iconView != null) {
                    this.iconView.setVisibility(8);
                    this.iconView.setImageDrawable(null);
                }
                this.customTextView = (TextView)custom.findViewById(16908308);
                if (this.customTextView != null) {
                    this.defaultMaxLines = TextViewCompat.getMaxLines((TextView)this.customTextView);
                }
                this.customIconView = (ImageView)custom.findViewById(16908294);
            } else {
                if (this.customView != null) {
                    this.removeView(this.customView);
                    this.customView = null;
                }
                this.customTextView = null;
                this.customIconView = null;
            }
            if (this.customView == null) {
                Drawable icon;
                if (this.iconView == null) {
                    this.inflateAndAddDefaultIconView();
                }
                Drawable drawable2 = icon = tab != null && tab.getIcon() != null ? DrawableCompat.wrap((Drawable)tab.getIcon()).mutate() : null;
                if (icon != null) {
                    DrawableCompat.setTintList((Drawable)icon, (ColorStateList)TabLayout.this.tabIconTint);
                    if (TabLayout.this.tabIconTintMode != null) {
                        DrawableCompat.setTintMode((Drawable)icon, (PorterDuff.Mode)TabLayout.this.tabIconTintMode);
                    }
                }
                if (this.textView == null) {
                    this.inflateAndAddDefaultTextView();
                    this.defaultMaxLines = TextViewCompat.getMaxLines((TextView)this.textView);
                }
                TextViewCompat.setTextAppearance((TextView)this.textView, (int)TabLayout.this.tabTextAppearance);
                if (TabLayout.this.tabTextColors != null) {
                    this.textView.setTextColor(TabLayout.this.tabTextColors);
                }
                this.updateTextAndIcon(this.textView, this.iconView);
                this.tryUpdateBadgeAnchor();
                this.addOnLayoutChangeListener((View)this.iconView);
                this.addOnLayoutChangeListener((View)this.textView);
            } else if (this.customTextView != null || this.customIconView != null) {
                this.updateTextAndIcon(this.customTextView, this.customIconView);
            }
            if (tab != null && !TextUtils.isEmpty((CharSequence)tab.contentDesc)) {
                this.setContentDescription(tab.contentDesc);
            }
            this.setSelected(tab != null && tab.isSelected());
        }

        private void inflateAndAddDefaultIconView() {
            TabView iconViewParent = this;
            if (BadgeUtils.USE_COMPAT_PARENT) {
                iconViewParent = this.createPreApi18BadgeAnchorRoot();
                this.addView((View)iconViewParent, 0);
            }
            this.iconView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_icon, (ViewGroup)iconViewParent, false);
            iconViewParent.addView((View)this.iconView, 0);
        }

        private void inflateAndAddDefaultTextView() {
            TabView textViewParent = this;
            if (BadgeUtils.USE_COMPAT_PARENT) {
                textViewParent = this.createPreApi18BadgeAnchorRoot();
                this.addView((View)textViewParent);
            }
            this.textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_text, (ViewGroup)textViewParent, false);
            textViewParent.addView((View)this.textView);
        }

        @NonNull
        private FrameLayout createPreApi18BadgeAnchorRoot() {
            FrameLayout frameLayout = new FrameLayout(this.getContext());
            FrameLayout.LayoutParams layoutparams = new FrameLayout.LayoutParams(-2, -2);
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutparams);
            return frameLayout;
        }

        @NonNull
        private BadgeDrawable getOrCreateBadge() {
            if (this.badgeDrawable == null) {
                this.badgeDrawable = BadgeDrawable.create(this.getContext());
            }
            this.tryUpdateBadgeAnchor();
            if (this.badgeDrawable == null) {
                throw new IllegalStateException("Unable to create badge");
            }
            return this.badgeDrawable;
        }

        @Nullable
        private BadgeDrawable getBadge() {
            return this.badgeDrawable;
        }

        private void removeBadge() {
            if (this.badgeAnchorView != null) {
                this.tryRemoveBadgeFromAnchor();
            }
            this.badgeDrawable = null;
        }

        private void addOnLayoutChangeListener(final @Nullable View view) {
            if (view == null) {
                return;
            }
            view.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (view.getVisibility() == 0) {
                        TabView.this.tryUpdateBadgeDrawableBounds(view);
                    }
                }
            });
        }

        private void tryUpdateBadgeAnchor() {
            if (!this.hasBadgeDrawable()) {
                return;
            }
            if (this.customView != null) {
                this.tryRemoveBadgeFromAnchor();
            } else if (this.iconView != null && this.tab != null && this.tab.getIcon() != null) {
                if (this.badgeAnchorView != this.iconView) {
                    this.tryRemoveBadgeFromAnchor();
                    this.tryAttachBadgeToAnchor((View)this.iconView);
                } else {
                    this.tryUpdateBadgeDrawableBounds((View)this.iconView);
                }
            } else if (this.textView != null && this.tab != null && this.tab.getTabLabelVisibility() == 1) {
                if (this.badgeAnchorView != this.textView) {
                    this.tryRemoveBadgeFromAnchor();
                    this.tryAttachBadgeToAnchor((View)this.textView);
                } else {
                    this.tryUpdateBadgeDrawableBounds((View)this.textView);
                }
            } else {
                this.tryRemoveBadgeFromAnchor();
            }
        }

        private void tryAttachBadgeToAnchor(@Nullable View anchorView) {
            if (!this.hasBadgeDrawable()) {
                return;
            }
            if (anchorView != null) {
                this.clipViewToPaddingForBadge(false);
                BadgeUtils.attachBadgeDrawable(this.badgeDrawable, anchorView, this.getCustomParentForBadge(anchorView));
                this.badgeAnchorView = anchorView;
            }
        }

        private void tryRemoveBadgeFromAnchor() {
            if (!this.hasBadgeDrawable()) {
                return;
            }
            this.clipViewToPaddingForBadge(true);
            if (this.badgeAnchorView != null) {
                BadgeUtils.detachBadgeDrawable(this.badgeDrawable, this.badgeAnchorView);
                this.badgeAnchorView = null;
            }
        }

        private void clipViewToPaddingForBadge(boolean flag) {
            this.setClipChildren(flag);
            this.setClipToPadding(flag);
            ViewGroup parent = (ViewGroup)this.getParent();
            if (parent != null) {
                parent.setClipChildren(flag);
                parent.setClipToPadding(flag);
            }
        }

        final void updateOrientation() {
            this.setOrientation(TabLayout.this.inlineLabel ? 0 : 1);
            if (this.customTextView != null || this.customIconView != null) {
                this.updateTextAndIcon(this.customTextView, this.customIconView);
            } else {
                this.updateTextAndIcon(this.textView, this.iconView);
            }
        }

        private void updateTextAndIcon(@Nullable TextView textView, @Nullable ImageView iconView) {
            CharSequence contentDesc;
            boolean hasText;
            CharSequence text;
            Drawable icon = this.tab != null && this.tab.getIcon() != null ? DrawableCompat.wrap((Drawable)this.tab.getIcon()).mutate() : null;
            CharSequence charSequence = text = this.tab != null ? this.tab.getText() : null;
            if (iconView != null) {
                if (icon != null) {
                    iconView.setImageDrawable(icon);
                    iconView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    iconView.setVisibility(8);
                    iconView.setImageDrawable(null);
                }
            }
            boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
            if (textView != null) {
                if (hasText) {
                    textView.setText(text);
                    if (this.tab.labelVisibilityMode == 1) {
                        textView.setVisibility(0);
                    } else {
                        textView.setVisibility(8);
                    }
                    this.setVisibility(0);
                } else {
                    textView.setVisibility(8);
                    textView.setText(null);
                }
            }
            if (iconView != null) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)iconView.getLayoutParams();
                int iconMargin = 0;
                if (hasText && iconView.getVisibility() == 0) {
                    iconMargin = (int)ViewUtils.dpToPx(this.getContext(), 8);
                }
                if (TabLayout.this.inlineLabel) {
                    if (iconMargin != MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp)) {
                        MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)lp, (int)iconMargin);
                        lp.bottomMargin = 0;
                        iconView.setLayoutParams((ViewGroup.LayoutParams)lp);
                        iconView.requestLayout();
                    }
                } else if (iconMargin != lp.bottomMargin) {
                    lp.bottomMargin = iconMargin;
                    MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)lp, (int)0);
                    iconView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    iconView.requestLayout();
                }
            }
            CharSequence charSequence2 = contentDesc = this.tab != null ? this.tab.contentDesc : null;
            if (Build.VERSION.SDK_INT < 21 || Build.VERSION.SDK_INT > 23) {
                TooltipCompat.setTooltipText((View)this, (CharSequence)(hasText ? text : contentDesc));
            }
        }

        private void tryUpdateBadgeDrawableBounds(@NonNull View anchor) {
            if (this.hasBadgeDrawable() && anchor == this.badgeAnchorView) {
                BadgeUtils.setBadgeDrawableBounds(this.badgeDrawable, anchor, this.getCustomParentForBadge(anchor));
            }
        }

        private boolean hasBadgeDrawable() {
            return this.badgeDrawable != null;
        }

        @Nullable
        private FrameLayout getCustomParentForBadge(@NonNull View anchor) {
            if (anchor != this.iconView && anchor != this.textView) {
                return null;
            }
            return BadgeUtils.USE_COMPAT_PARENT ? (FrameLayout)anchor.getParent() : null;
        }

        int getContentWidth() {
            boolean initialized = false;
            int left = 0;
            int right = 0;
            for (View view : new View[]{this.textView, this.iconView, this.customView}) {
                if (view == null || view.getVisibility() != 0) continue;
                left = initialized ? Math.min(left, view.getLeft()) : view.getLeft();
                right = initialized ? Math.max(right, view.getRight()) : view.getRight();
                initialized = true;
            }
            return right - left;
        }

        int getContentHeight() {
            boolean initialized = false;
            int top = 0;
            int bottom = 0;
            for (View view : new View[]{this.textView, this.iconView, this.customView}) {
                if (view == null || view.getVisibility() != 0) continue;
                top = initialized ? Math.min(top, view.getTop()) : view.getTop();
                bottom = initialized ? Math.max(bottom, view.getBottom()) : view.getBottom();
                initialized = true;
            }
            return bottom - top;
        }

        @Nullable
        public Tab getTab() {
            return this.tab;
        }

        private float approximateLineWidth(@NonNull Layout layout2, int line, float textSize) {
            return layout2.getLineWidth(line) * (textSize / layout2.getPaint().getTextSize());
        }
    }

    public static class Tab {
        public static final int INVALID_POSITION = -1;
        @Nullable
        private Object tag;
        @Nullable
        private Drawable icon;
        @Nullable
        private CharSequence text;
        @Nullable
        private CharSequence contentDesc;
        private int position = -1;
        @Nullable
        private View customView;
        @LabelVisibility
        private int labelVisibilityMode = 1;
        @Nullable
        public TabLayout parent;
        @NonNull
        public TabView view;
        private int id = -1;

        @Nullable
        public Object getTag() {
            return this.tag;
        }

        @NonNull
        public Tab setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        @NonNull
        public Tab setId(int id2) {
            this.id = id2;
            if (this.view != null) {
                this.view.setId(id2);
            }
            return this;
        }

        public int getId() {
            return this.id;
        }

        @Nullable
        public View getCustomView() {
            return this.customView;
        }

        @NonNull
        public Tab setCustomView(@Nullable View view) {
            this.customView = view;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setCustomView(@LayoutRes int resId) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.view.getContext());
            return this.setCustomView(inflater.inflate(resId, (ViewGroup)this.view, false));
        }

        @Nullable
        public Drawable getIcon() {
            return this.icon;
        }

        public int getPosition() {
            return this.position;
        }

        void setPosition(int position) {
            this.position = position;
        }

        @Nullable
        public CharSequence getText() {
            return this.text;
        }

        @NonNull
        public Tab setIcon(@Nullable Drawable icon) {
            this.icon = icon;
            if (this.parent.tabGravity == 1 || this.parent.mode == 2) {
                this.parent.updateTabViews(true);
            }
            this.updateView();
            if (BadgeUtils.USE_COMPAT_PARENT && this.view.hasBadgeDrawable() && this.view.badgeDrawable.isVisible()) {
                this.view.invalidate();
            }
            return this;
        }

        @NonNull
        public Tab setIcon(@DrawableRes int resId) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setIcon(AppCompatResources.getDrawable((Context)this.parent.getContext(), (int)resId));
        }

        @NonNull
        public Tab setText(@Nullable CharSequence text) {
            if (TextUtils.isEmpty((CharSequence)this.contentDesc) && !TextUtils.isEmpty((CharSequence)text)) {
                this.view.setContentDescription(text);
            }
            this.text = text;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setText(@StringRes int resId) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setText(this.parent.getResources().getText(resId));
        }

        @NonNull
        public BadgeDrawable getOrCreateBadge() {
            return this.view.getOrCreateBadge();
        }

        public void removeBadge() {
            this.view.removeBadge();
        }

        @Nullable
        public BadgeDrawable getBadge() {
            return this.view.getBadge();
        }

        @NonNull
        public Tab setTabLabelVisibility(@LabelVisibility int mode) {
            this.labelVisibilityMode = mode;
            if (this.parent.tabGravity == 1 || this.parent.mode == 2) {
                this.parent.updateTabViews(true);
            }
            this.updateView();
            if (BadgeUtils.USE_COMPAT_PARENT && this.view.hasBadgeDrawable() && this.view.badgeDrawable.isVisible()) {
                this.view.invalidate();
            }
            return this;
        }

        @LabelVisibility
        public int getTabLabelVisibility() {
            return this.labelVisibilityMode;
        }

        public void select() {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            this.parent.selectTab(this);
        }

        public boolean isSelected() {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.parent.getSelectedTabPosition() == this.position;
        }

        @NonNull
        public Tab setContentDescription(@StringRes int resId) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setContentDescription(this.parent.getResources().getText(resId));
        }

        @NonNull
        public Tab setContentDescription(@Nullable CharSequence contentDesc) {
            this.contentDesc = contentDesc;
            this.updateView();
            return this;
        }

        @Nullable
        public CharSequence getContentDescription() {
            return this.view == null ? null : this.view.getContentDescription();
        }

        void updateView() {
            if (this.view != null) {
                this.view.update();
            }
        }

        void reset() {
            this.parent = null;
            this.view = null;
            this.tag = null;
            this.icon = null;
            this.id = -1;
            this.text = null;
            this.contentDesc = null;
            this.position = -1;
            this.customView = null;
        }
    }

    @Deprecated
    public static interface BaseOnTabSelectedListener<T extends Tab> {
        public void onTabSelected(T var1);

        public void onTabUnselected(T var1);

        public void onTabReselected(T var1);
    }

    public static interface OnTabSelectedListener
    extends BaseOnTabSelectedListener<Tab> {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TabIndicatorAnimationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TabIndicatorGravity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TabGravity {
    }

    public static @interface LabelVisibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Mode {
    }
}

