/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import com.google.android.material.R;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class TextInputEditText
extends AppCompatEditText {
    private final Rect parentRect = new Rect();
    private boolean textInputLayoutFocusedRectEnabled;

    public TextInputEditText(@NonNull Context context) {
        this(context, null);
    }

    public TextInputEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.editTextStyle);
    }

    public TextInputEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, 0), attrs, defStyleAttr);
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.TextInputEditText, defStyleAttr, R.style.Widget_Design_TextInputEditText, new int[0]);
        this.setTextInputLayoutFocusedRectEnabled(attributes.getBoolean(R.styleable.TextInputEditText_textInputLayoutFocusedRectEnabled, false));
        attributes.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        TextInputLayout layout2 = this.getTextInputLayout();
        if (layout2 != null && layout2.isProvidingHint() && super.getHint() == null && ManufacturerUtils.isMeizuDevice()) {
            this.setHint("");
        }
    }

    @Nullable
    public CharSequence getHint() {
        TextInputLayout layout2 = this.getTextInputLayout();
        if (layout2 != null && layout2.isProvidingHint()) {
            return layout2.getHint();
        }
        return super.getHint();
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        InputConnection ic = super.onCreateInputConnection(outAttrs);
        if (ic != null && outAttrs.hintText == null) {
            outAttrs.hintText = this.getHintFromLayout();
        }
        return ic;
    }

    @Nullable
    private TextInputLayout getTextInputLayout() {
        ViewParent parent = this.getParent();
        while (parent instanceof View) {
            if (parent instanceof TextInputLayout) {
                return (TextInputLayout)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    private CharSequence getHintFromLayout() {
        TextInputLayout layout2 = this.getTextInputLayout();
        return layout2 != null ? layout2.getHint() : null;
    }

    public void setTextInputLayoutFocusedRectEnabled(boolean textInputLayoutFocusedRectEnabled) {
        this.textInputLayoutFocusedRectEnabled = textInputLayoutFocusedRectEnabled;
    }

    public boolean isTextInputLayoutFocusedRectEnabled() {
        return this.textInputLayoutFocusedRectEnabled;
    }

    public void getFocusedRect(@Nullable Rect r) {
        super.getFocusedRect(r);
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (textInputLayout != null && this.textInputLayoutFocusedRectEnabled && r != null) {
            textInputLayout.getFocusedRect(this.parentRect);
            r.bottom = this.parentRect.bottom;
        }
    }

    public boolean getGlobalVisibleRect(@Nullable Rect r, @Nullable Point globalOffset) {
        boolean result = super.getGlobalVisibleRect(r, globalOffset);
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (textInputLayout != null && this.textInputLayoutFocusedRectEnabled && r != null) {
            textInputLayout.getGlobalVisibleRect(this.parentRect, globalOffset);
            r.bottom = this.parentRect.bottom;
        }
        return result;
    }

    public boolean requestRectangleOnScreen(@Nullable Rect rectangle) {
        boolean result = super.requestRectangleOnScreen(rectangle);
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (textInputLayout != null && this.textInputLayoutFocusedRectEnabled) {
            this.parentRect.set(0, textInputLayout.getHeight() - this.getResources().getDimensionPixelOffset(R.dimen.mtrl_edittext_rectangle_top_offset), textInputLayout.getWidth(), textInputLayout.getHeight());
            textInputLayout.requestRectangleOnScreen(this.parentRect, true);
        }
        return result;
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        TextInputLayout layout2 = this.getTextInputLayout();
        if (Build.VERSION.SDK_INT < 23 && layout2 != null) {
            info.setText((CharSequence)this.getAccessibilityNodeInfoText(layout2));
        }
    }

    @NonNull
    private String getAccessibilityNodeInfoText(@NonNull TextInputLayout layout2) {
        String hint;
        boolean hasHint;
        Editable inputText = this.getText();
        CharSequence hintText = layout2.getHint();
        boolean showingText = !TextUtils.isEmpty((CharSequence)inputText);
        boolean bl = hasHint = !TextUtils.isEmpty((CharSequence)hintText);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setLabelFor(R.id.textinput_helper_text);
        }
        String string2 = hint = hasHint ? hintText.toString() : "";
        if (showingText) {
            return inputText + (!TextUtils.isEmpty((CharSequence)hint) ? ", " + hint : "");
        }
        if (!TextUtils.isEmpty((CharSequence)hint)) {
            return hint;
        }
        return "";
    }
}

