/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.text.Editable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.timepicker.ChipTextInputComboView;
import com.google.android.material.timepicker.TimeModel;

class TimePickerTextInputKeyController
implements TextView.OnEditorActionListener,
View.OnKeyListener {
    private final ChipTextInputComboView hourLayoutComboView;
    private final ChipTextInputComboView minuteLayoutComboView;
    private final TimeModel time;
    private boolean keyListenerRunning = false;

    TimePickerTextInputKeyController(ChipTextInputComboView hourLayoutComboView, ChipTextInputComboView minuteLayoutComboView, TimeModel time) {
        this.hourLayoutComboView = hourLayoutComboView;
        this.minuteLayoutComboView = minuteLayoutComboView;
        this.time = time;
    }

    public void bind() {
        TextInputLayout hourLayout = this.hourLayoutComboView.getTextInput();
        TextInputLayout minuteLayout = this.minuteLayoutComboView.getTextInput();
        EditText hourEditText = hourLayout.getEditText();
        EditText minuteEditText = minuteLayout.getEditText();
        hourEditText.setImeOptions(0x10000005);
        minuteEditText.setImeOptions(0x10000006);
        hourEditText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        hourEditText.setOnKeyListener((View.OnKeyListener)this);
        minuteEditText.setOnKeyListener((View.OnKeyListener)this);
    }

    private void moveSelection(int selection) {
        this.minuteLayoutComboView.setChecked(selection == 12);
        this.hourLayoutComboView.setChecked(selection == 10);
        this.time.selection = selection;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        boolean actionNext;
        boolean bl = actionNext = actionId == 5;
        if (actionNext) {
            this.moveSelection(12);
        }
        return actionNext;
    }

    public boolean onKey(View view, int keyCode, KeyEvent event) {
        if (this.keyListenerRunning) {
            return false;
        }
        this.keyListenerRunning = true;
        EditText editText = (EditText)view;
        boolean ret = this.time.selection == 12 ? this.onMinuteKeyPress(keyCode, event, editText) : this.onHourKeyPress(keyCode, event, editText);
        this.keyListenerRunning = false;
        return ret;
    }

    private boolean onMinuteKeyPress(int keyCode, KeyEvent event, EditText editText) {
        boolean switchFocus;
        boolean bl = switchFocus = keyCode == 67 && event.getAction() == 0 && TextUtils.isEmpty((CharSequence)editText.getText());
        if (switchFocus) {
            this.moveSelection(10);
            return true;
        }
        return false;
    }

    private boolean onHourKeyPress(int keyCode, KeyEvent event, EditText editText) {
        boolean switchFocus;
        Editable text = editText.getText();
        if (text == null) {
            return false;
        }
        boolean bl = switchFocus = keyCode >= 7 && keyCode <= 16 && event.getAction() == 1 && editText.getSelectionStart() == 2 && text.length() == 2;
        if (switchFocus) {
            this.moveSelection(12);
            return true;
        }
        return false;
    }
}

