/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition.platform;

import android.app.Activity;
import android.app.SharedElementCallback;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcelable;
import android.transition.Transition;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import com.google.android.material.R;
import com.google.android.material.internal.ContextUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.transition.platform.MaterialContainerTransform;
import com.google.android.material.transition.platform.TransitionListenerAdapter;
import com.google.android.material.transition.platform.TransitionUtils;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
public class MaterialContainerTransformSharedElementCallback
extends SharedElementCallback {
    @Nullable
    private static WeakReference<View> capturedSharedElement;
    private boolean entering = true;
    private boolean transparentWindowBackgroundEnabled = true;
    private boolean sharedElementReenterTransitionEnabled = false;
    @Nullable
    private Rect returnEndBounds;
    @Nullable
    private ShapeProvider shapeProvider = new ShapeableViewShapeProvider();

    @Nullable
    public Parcelable onCaptureSharedElementSnapshot(@NonNull View sharedElement, @NonNull Matrix viewToGlobalMatrix, @NonNull RectF screenBounds) {
        capturedSharedElement = new WeakReference<View>(sharedElement);
        return super.onCaptureSharedElementSnapshot(sharedElement, viewToGlobalMatrix, screenBounds);
    }

    @Nullable
    public View onCreateSnapshotView(@NonNull Context context, @Nullable Parcelable snapshot) {
        ShapeAppearanceModel shapeAppearanceModel;
        View sharedElement;
        View snapshotView = super.onCreateSnapshotView(context, snapshot);
        if (snapshotView != null && capturedSharedElement != null && this.shapeProvider != null && (sharedElement = (View)capturedSharedElement.get()) != null && (shapeAppearanceModel = this.shapeProvider.provideShape(sharedElement)) != null) {
            snapshotView.setTag(R.id.mtrl_motion_snapshot_view, (Object)shapeAppearanceModel);
        }
        return snapshotView;
    }

    public void onMapSharedElements(@NonNull List<String> names, @NonNull Map<String, View> sharedElements) {
        Activity activity;
        View sharedElement;
        if (!names.isEmpty() && !sharedElements.isEmpty() && (sharedElement = sharedElements.get(names.get(0))) != null && (activity = ContextUtils.getActivity(sharedElement.getContext())) != null) {
            Window window = activity.getWindow();
            if (this.entering) {
                this.setUpEnterTransform(window);
            } else {
                this.setUpReturnTransform(activity, window);
            }
        }
    }

    public void onSharedElementStart(@NonNull List<String> sharedElementNames, @NonNull List<View> sharedElements, @NonNull List<View> sharedElementSnapshots) {
        if (!sharedElements.isEmpty() && !sharedElementSnapshots.isEmpty()) {
            sharedElements.get(0).setTag(R.id.mtrl_motion_snapshot_view, (Object)sharedElementSnapshots.get(0));
        }
        if (!this.entering && !sharedElements.isEmpty() && this.returnEndBounds != null) {
            View sharedElement = sharedElements.get(0);
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.returnEndBounds.width(), (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.returnEndBounds.height(), (int)0x40000000);
            sharedElement.measure(widthSpec, heightSpec);
            sharedElement.layout(this.returnEndBounds.left, this.returnEndBounds.top, this.returnEndBounds.right, this.returnEndBounds.bottom);
        }
    }

    public void onSharedElementEnd(@NonNull List<String> sharedElementNames, @NonNull List<View> sharedElements, @NonNull List<View> sharedElementSnapshots) {
        if (!sharedElements.isEmpty() && sharedElements.get(0).getTag(R.id.mtrl_motion_snapshot_view) instanceof View) {
            sharedElements.get(0).setTag(R.id.mtrl_motion_snapshot_view, null);
        }
        if (!this.entering && !sharedElements.isEmpty()) {
            this.returnEndBounds = TransitionUtils.getRelativeBoundsRect(sharedElements.get(0));
        }
        this.entering = false;
    }

    @Nullable
    public ShapeProvider getShapeProvider() {
        return this.shapeProvider;
    }

    public void setShapeProvider(@Nullable ShapeProvider shapeProvider) {
        this.shapeProvider = shapeProvider;
    }

    public boolean isTransparentWindowBackgroundEnabled() {
        return this.transparentWindowBackgroundEnabled;
    }

    public void setTransparentWindowBackgroundEnabled(boolean transparentWindowBackgroundEnabled) {
        this.transparentWindowBackgroundEnabled = transparentWindowBackgroundEnabled;
    }

    public boolean isSharedElementReenterTransitionEnabled() {
        return this.sharedElementReenterTransitionEnabled;
    }

    public void setSharedElementReenterTransitionEnabled(boolean sharedElementReenterTransitionEnabled) {
        this.sharedElementReenterTransitionEnabled = sharedElementReenterTransitionEnabled;
    }

    private void setUpEnterTransform(final Window window) {
        Transition transition = window.getSharedElementEnterTransition();
        if (transition instanceof MaterialContainerTransform) {
            MaterialContainerTransform transform = (MaterialContainerTransform)transition;
            if (!this.sharedElementReenterTransitionEnabled) {
                window.setSharedElementReenterTransition(null);
            }
            if (this.transparentWindowBackgroundEnabled) {
                MaterialContainerTransformSharedElementCallback.updateBackgroundFadeDuration(window, transform);
                transform.addListener(new TransitionListenerAdapter(){

                    @Override
                    public void onTransitionStart(Transition transition) {
                        MaterialContainerTransformSharedElementCallback.removeWindowBackground(window);
                    }

                    @Override
                    public void onTransitionEnd(Transition transition) {
                        MaterialContainerTransformSharedElementCallback.restoreWindowBackground(window);
                    }
                });
            }
        }
    }

    private void setUpReturnTransform(final Activity activity, final Window window) {
        Transition transition = window.getSharedElementReturnTransition();
        if (transition instanceof MaterialContainerTransform) {
            MaterialContainerTransform transform = (MaterialContainerTransform)transition;
            transform.setHoldAtEndEnabled(true);
            transform.addListener(new TransitionListenerAdapter(){

                @Override
                public void onTransitionEnd(Transition transition) {
                    View sharedElement;
                    if (capturedSharedElement != null && (sharedElement = (View)capturedSharedElement.get()) != null) {
                        sharedElement.setAlpha(1.0f);
                        capturedSharedElement = null;
                    }
                    activity.finish();
                    activity.overridePendingTransition(0, 0);
                }
            });
            if (this.transparentWindowBackgroundEnabled) {
                MaterialContainerTransformSharedElementCallback.updateBackgroundFadeDuration(window, transform);
                transform.addListener(new TransitionListenerAdapter(){

                    @Override
                    public void onTransitionStart(Transition transition) {
                        MaterialContainerTransformSharedElementCallback.removeWindowBackground(window);
                    }
                });
            }
        }
    }

    private static void removeWindowBackground(Window window) {
        window.getDecorView().getBackground().mutate().setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)0, (BlendModeCompat)BlendModeCompat.CLEAR));
    }

    private static void restoreWindowBackground(Window window) {
        window.getDecorView().getBackground().mutate().clearColorFilter();
    }

    private static void updateBackgroundFadeDuration(Window window, MaterialContainerTransform transform) {
        if (transform.getDuration() >= 0L) {
            window.setTransitionBackgroundFadeDuration(transform.getDuration());
        }
    }

    public static class ShapeableViewShapeProvider
    implements ShapeProvider {
        @Override
        @Nullable
        public ShapeAppearanceModel provideShape(@NonNull View sharedElement) {
            return sharedElement instanceof Shapeable ? ((Shapeable)sharedElement).getShapeAppearanceModel() : null;
        }
    }

    public static interface ShapeProvider {
        @Nullable
        public ShapeAppearanceModel provideShape(@NonNull View var1);
    }
}

