/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.media.MediaDescription;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.media.session.MediaSessionCompat;
import android.text.TextUtils;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;

@SuppressLint(value={"BanParcelableUsage"})
public final class MediaDescriptionCompat
implements Parcelable {
    private static final String TAG = "MediaDescriptionCompat";
    public static final String EXTRA_BT_FOLDER_TYPE = "android.media.extra.BT_FOLDER_TYPE";
    public static final long BT_FOLDER_TYPE_MIXED = 0L;
    public static final long BT_FOLDER_TYPE_TITLES = 1L;
    public static final long BT_FOLDER_TYPE_ALBUMS = 2L;
    public static final long BT_FOLDER_TYPE_ARTISTS = 3L;
    public static final long BT_FOLDER_TYPE_GENRES = 4L;
    public static final long BT_FOLDER_TYPE_PLAYLISTS = 5L;
    public static final long BT_FOLDER_TYPE_YEARS = 6L;
    public static final String EXTRA_DOWNLOAD_STATUS = "android.media.extra.DOWNLOAD_STATUS";
    public static final long STATUS_NOT_DOWNLOADED = 0L;
    public static final long STATUS_DOWNLOADING = 1L;
    public static final long STATUS_DOWNLOADED = 2L;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String DESCRIPTION_KEY_MEDIA_URI = "android.support.v4.media.description.MEDIA_URI";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String DESCRIPTION_KEY_NULL_BUNDLE_FLAG = "android.support.v4.media.description.NULL_BUNDLE_FLAG";
    private final String mMediaId;
    private final CharSequence mTitle;
    private final CharSequence mSubtitle;
    private final CharSequence mDescription;
    private final Bitmap mIcon;
    private final Uri mIconUri;
    private final Bundle mExtras;
    private final Uri mMediaUri;
    private MediaDescription mDescriptionFwk;
    public static final Parcelable.Creator<MediaDescriptionCompat> CREATOR = new Parcelable.Creator<MediaDescriptionCompat>(){

        public MediaDescriptionCompat createFromParcel(Parcel in) {
            if (Build.VERSION.SDK_INT < 21) {
                return new MediaDescriptionCompat(in);
            }
            return MediaDescriptionCompat.fromMediaDescription(MediaDescription.CREATOR.createFromParcel(in));
        }

        public MediaDescriptionCompat[] newArray(int size) {
            return new MediaDescriptionCompat[size];
        }
    };

    MediaDescriptionCompat(String mediaId, CharSequence title, CharSequence subtitle, CharSequence description, Bitmap icon, Uri iconUri, Bundle extras, Uri mediaUri) {
        this.mMediaId = mediaId;
        this.mTitle = title;
        this.mSubtitle = subtitle;
        this.mDescription = description;
        this.mIcon = icon;
        this.mIconUri = iconUri;
        this.mExtras = extras;
        this.mMediaUri = mediaUri;
    }

    MediaDescriptionCompat(Parcel in) {
        this.mMediaId = in.readString();
        this.mTitle = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mSubtitle = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mDescription = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        ClassLoader loader = this.getClass().getClassLoader();
        this.mIcon = (Bitmap)in.readParcelable(loader);
        this.mIconUri = (Uri)in.readParcelable(loader);
        this.mExtras = in.readBundle(loader);
        this.mMediaUri = (Uri)in.readParcelable(loader);
    }

    @Nullable
    public String getMediaId() {
        return this.mMediaId;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @Nullable
    public CharSequence getDescription() {
        return this.mDescription;
    }

    @Nullable
    public Bitmap getIconBitmap() {
        return this.mIcon;
    }

    @Nullable
    public Uri getIconUri() {
        return this.mIconUri;
    }

    @Nullable
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Nullable
    public Uri getMediaUri() {
        return this.mMediaUri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (Build.VERSION.SDK_INT < 21) {
            dest.writeString(this.mMediaId);
            TextUtils.writeToParcel((CharSequence)this.mTitle, (Parcel)dest, (int)flags);
            TextUtils.writeToParcel((CharSequence)this.mSubtitle, (Parcel)dest, (int)flags);
            TextUtils.writeToParcel((CharSequence)this.mDescription, (Parcel)dest, (int)flags);
            dest.writeParcelable((Parcelable)this.mIcon, flags);
            dest.writeParcelable((Parcelable)this.mIconUri, flags);
            dest.writeBundle(this.mExtras);
            dest.writeParcelable((Parcelable)this.mMediaUri, flags);
        } else {
            ((MediaDescription)this.getMediaDescription()).writeToParcel(dest, flags);
        }
    }

    public String toString() {
        return this.mTitle + ", " + this.mSubtitle + ", " + this.mDescription;
    }

    public Object getMediaDescription() {
        if (this.mDescriptionFwk != null || Build.VERSION.SDK_INT < 21) {
            return this.mDescriptionFwk;
        }
        MediaDescription.Builder bob = Api21Impl.createBuilder();
        Api21Impl.setMediaId(bob, this.mMediaId);
        Api21Impl.setTitle(bob, this.mTitle);
        Api21Impl.setSubtitle(bob, this.mSubtitle);
        Api21Impl.setDescription(bob, this.mDescription);
        Api21Impl.setIconBitmap(bob, this.mIcon);
        Api21Impl.setIconUri(bob, this.mIconUri);
        Bundle extras = this.mExtras;
        if (Build.VERSION.SDK_INT < 23 && this.mMediaUri != null) {
            if (extras == null) {
                extras = new Bundle();
                extras.putBoolean(DESCRIPTION_KEY_NULL_BUNDLE_FLAG, true);
            }
            extras.putParcelable(DESCRIPTION_KEY_MEDIA_URI, (Parcelable)this.mMediaUri);
        }
        Api21Impl.setExtras(bob, extras);
        if (Build.VERSION.SDK_INT >= 23) {
            Api23Impl.setMediaUri(bob, this.mMediaUri);
        }
        this.mDescriptionFwk = Api21Impl.build(bob);
        return this.mDescriptionFwk;
    }

    public static MediaDescriptionCompat fromMediaDescription(Object descriptionObj) {
        if (descriptionObj != null && Build.VERSION.SDK_INT >= 21) {
            Builder bob = new Builder();
            MediaDescription description = (MediaDescription)descriptionObj;
            bob.setMediaId(Api21Impl.getMediaId(description));
            bob.setTitle(Api21Impl.getTitle(description));
            bob.setSubtitle(Api21Impl.getSubtitle(description));
            bob.setDescription(Api21Impl.getDescription(description));
            bob.setIconBitmap(Api21Impl.getIconBitmap(description));
            bob.setIconUri(Api21Impl.getIconUri(description));
            Bundle extras = Api21Impl.getExtras(description);
            if (extras != null) {
                extras = MediaSessionCompat.unparcelWithClassLoader(extras);
            }
            Uri mediaUri = null;
            if (extras != null) {
                mediaUri = (Uri)extras.getParcelable(DESCRIPTION_KEY_MEDIA_URI);
            }
            if (mediaUri != null) {
                if (extras.containsKey(DESCRIPTION_KEY_NULL_BUNDLE_FLAG) && extras.size() == 2) {
                    extras = null;
                } else {
                    extras.remove(DESCRIPTION_KEY_MEDIA_URI);
                    extras.remove(DESCRIPTION_KEY_NULL_BUNDLE_FLAG);
                }
            }
            bob.setExtras(extras);
            if (mediaUri != null) {
                bob.setMediaUri(mediaUri);
            } else if (Build.VERSION.SDK_INT >= 23) {
                bob.setMediaUri(Api23Impl.getMediaUri(description));
            }
            MediaDescriptionCompat descriptionCompat = bob.build();
            descriptionCompat.mDescriptionFwk = description;
            return descriptionCompat;
        }
        return null;
    }

    @RequiresApi(value=23)
    private static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static void setMediaUri(MediaDescription.Builder builder, @Nullable Uri mediaUri) {
            builder.setMediaUri(mediaUri);
        }

        @DoNotInline
        @Nullable
        static Uri getMediaUri(MediaDescription description) {
            return description.getMediaUri();
        }
    }

    @RequiresApi(value=21)
    private static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static MediaDescription.Builder createBuilder() {
            return new MediaDescription.Builder();
        }

        @DoNotInline
        static void setMediaId(MediaDescription.Builder builder, @Nullable String mediaId) {
            builder.setMediaId(mediaId);
        }

        @DoNotInline
        static void setTitle(MediaDescription.Builder builder, @Nullable CharSequence title) {
            builder.setTitle(title);
        }

        @DoNotInline
        static void setSubtitle(MediaDescription.Builder builder, @Nullable CharSequence subtitle) {
            builder.setSubtitle(subtitle);
        }

        @DoNotInline
        static void setDescription(MediaDescription.Builder builder, @Nullable CharSequence description) {
            builder.setDescription(description);
        }

        @DoNotInline
        static void setIconBitmap(MediaDescription.Builder builder, @Nullable Bitmap icon) {
            builder.setIconBitmap(icon);
        }

        @DoNotInline
        static void setIconUri(MediaDescription.Builder builder, @Nullable Uri iconUri) {
            builder.setIconUri(iconUri);
        }

        @DoNotInline
        static void setExtras(MediaDescription.Builder builder, @Nullable Bundle extras) {
            builder.setExtras(extras);
        }

        @DoNotInline
        static MediaDescription build(MediaDescription.Builder builder) {
            return builder.build();
        }

        @DoNotInline
        @Nullable
        static String getMediaId(MediaDescription description) {
            return description.getMediaId();
        }

        @DoNotInline
        @Nullable
        static CharSequence getTitle(MediaDescription description) {
            return description.getTitle();
        }

        @DoNotInline
        @Nullable
        static CharSequence getSubtitle(MediaDescription description) {
            return description.getSubtitle();
        }

        @DoNotInline
        @Nullable
        static CharSequence getDescription(MediaDescription description) {
            return description.getDescription();
        }

        @DoNotInline
        @Nullable
        static Bitmap getIconBitmap(MediaDescription description) {
            return description.getIconBitmap();
        }

        @DoNotInline
        @Nullable
        static Uri getIconUri(MediaDescription description) {
            return description.getIconUri();
        }

        @DoNotInline
        @Nullable
        static Bundle getExtras(MediaDescription description) {
            return description.getExtras();
        }
    }

    public static final class Builder {
        private String mMediaId;
        private CharSequence mTitle;
        private CharSequence mSubtitle;
        private CharSequence mDescription;
        private Bitmap mIcon;
        private Uri mIconUri;
        private Bundle mExtras;
        private Uri mMediaUri;

        public Builder setMediaId(@Nullable String mediaId) {
            this.mMediaId = mediaId;
            return this;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        public Builder setDescription(@Nullable CharSequence description) {
            this.mDescription = description;
            return this;
        }

        public Builder setIconBitmap(@Nullable Bitmap icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder setIconUri(@Nullable Uri iconUri) {
            this.mIconUri = iconUri;
            return this;
        }

        public Builder setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public Builder setMediaUri(@Nullable Uri mediaUri) {
            this.mMediaUri = mediaUri;
            return this;
        }

        public MediaDescriptionCompat build() {
            return new MediaDescriptionCompat(this.mMediaId, this.mTitle, this.mSubtitle, this.mDescription, this.mIcon, this.mIconUri, this.mExtras, this.mMediaUri);
        }
    }
}

