﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class AccountDetailsForm : Form
    {
        public AccountDetailsForm()
        {
            InitializeComponent();
            using (var context = new FinanceModel())
            {
                
                var query = context.AccountDetails.ToList();
                AccountsListBox.DataSource = query;
                AccountsListBox.DisplayMember = "Name";
            }
        }

        private void AddAccountBtn_Click(object sender, EventArgs e)
        {
            AddOrEditAccountDetailsForm editAccountDetailsForm = new AddOrEditAccountDetailsForm(AddOrEditAccountDetailsForm.AddOrEdit.Add, this);
            editAccountDetailsForm.Show();

        }

        private void UpdateAccountsBtn_Click(object sender, EventArgs e)
        {
            AccountDetailsEntry.UpdateAccounts();
        }
        

        private void EditAccountBtn_Click(object sender, EventArgs e)
        {
            if (this.AccountsListBox.SelectedItem != null)
            {
                AccountDetailsEntry selectedAccount = (AccountDetailsEntry)this.AccountsListBox.SelectedItem;
                AddOrEditAccountDetailsForm editAccountForm = new AddOrEditAccountDetailsForm(selectedAccount, this);
                editAccountForm.Show();
            }
            
        }
    }
}
