﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class AddEarningsEntryForm : Form
    {
        public bool IsYTD { get; set; }
        public AddEarningsEntryForm()
        {
            InitializeComponent();
            this.IsYTD = false;
            TotalEarnedLbl.Visible = false;
            TotalEarnedTextBox.Visible = false;
        }
        public AddEarningsEntryForm(bool isYTD)
        {
            InitializeComponent();
            this.IsYTD = isYTD;
            if (isYTD )
            {
                this.Text = "Add YTD Earnings Entry";
                UberLbl.Visible = false;
                UberTextBox.Visible = false;
                LyftLbl.Visible = false;
                LyftTextBox.Visible = false;
                StripeLbl.Visible = false;
                StripeTextBox.Visible = false;
                GrubHubLbl.Visible = false;
                GrubHubTextBox.Visible = false;
                DoorDashLbl.Visible = false;
                DoorDashTextBox.Visible = false;
                VenmoLbl.Visible = false;
                VenmoTextBox.Visible = false;
                CashAppLbl.Visible = false;
                CashAppTextBox.Visible = false;
                FiverrLbl.Visible = false;
                FiverrTextBox.Visible = false;
            }
            else
            {
                TotalEarnedLbl.Visible = false;
                TotalEarnedTextBox.Visible = false;
            }
        }
        public void NumberTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsControl(e.KeyChar) && !char.IsDigit(e.KeyChar) && (e.KeyChar != '.'))
            {
                e.Handled = true;
            }

            // only allow one decimal point
            if ((e.KeyChar == '.') && ((sender as TextBox).Text.IndexOf('.') > -1))
            {
                e.Handled = true;
            }
        }

        private void SubmitBtn_Click(object sender, EventArgs e)
        {
            decimal uber;
            decimal lyft;
            decimal stripe;
            decimal grubhub;
            decimal doordash;
            decimal venmo;
            decimal cashapp;
            decimal fiverr;
            decimal total;

            decimal ytdMiles;



            DateOnly now = DateOnly.FromDateTime(DateTime.Now);

            
            

            



            using (var context = new FinanceModel())
            {
                if (this.IsYTD)
                {
                    if (!Decimal.TryParse(YTDMilesTextBox.Text, out ytdMiles)) return;
                    if (!Decimal.TryParse(TotalEarnedTextBox.Text, out total)) return;

                    YTDEarningsEntry entry = new YTDEarningsEntry()
                    {
                        Date = now,
                        Miles = ytdMiles,
                        TotalEarned = total
                    };
                    context.YTDEarnings.Add(entry);
                }
                else
                {
                    if (!Decimal.TryParse(UberTextBox.Text, out uber)) return;
                    if (!Decimal.TryParse(LyftTextBox.Text, out lyft)) return;
                    if (!Decimal.TryParse(StripeTextBox.Text, out stripe)) return;
                    if (!Decimal.TryParse(GrubHubTextBox.Text, out grubhub)) return;
                    if (!Decimal.TryParse(DoorDashTextBox.Text, out doordash)) return;
                    if (!Decimal.TryParse(VenmoTextBox.Text, out venmo)) return;
                    if (!Decimal.TryParse(CashAppTextBox.Text, out cashapp)) return;
                    if (!Decimal.TryParse(FiverrTextBox.Text, out fiverr)) return;

                    if (!Decimal.TryParse(YTDMilesTextBox.Text, out ytdMiles)) return;
                    total = uber + lyft + stripe + grubhub + doordash + venmo + cashapp + fiverr;

                    EarningsEntry entry = new EarningsEntry()
                    {
                        Date = now,
                        Uber = uber,
                        Lyft = lyft,
                        Stripe = stripe,
                        GrubHub = grubhub,
                        DoorDash = doordash,
                        Venmo = venmo,
                        CashApp = cashapp,
                        Fiverr = fiverr,
                        YTDMiles = ytdMiles,
                        Total = total
                    };
                    context.Earnings.Add(entry);
                }
 
                SaveResult saveResult = new();
                try
                {
                    context.SaveChanges();
                    saveResult.Message = "Save successful.";
                    saveResult.Title = "Save Successful";
                    saveResult.ShowDialog();
                }
                catch (Exception ex)
                {
                    saveResult.Message = ex.InnerException.ToString();
                    saveResult.ShowDialog();
                    System.Diagnostics.Debug.WriteLine("Trevor Exception: " + ex.Message + Environment.NewLine + ex.InnerException);
                }
            }
        }
    }
}
