﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Reflection.Metadata.Ecma335;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class AddOrEditAccountDetailsForm : Form
    {
        public AccountDetailsForm prnt;
        public enum AddOrEdit { Add, Edit }
        public AddOrEdit addOrEdit { get; }
        public AccountDetailsEntry entry { get; set; }
        public AddOrEditAccountDetailsForm(AddOrEdit addOrEdit, AccountDetailsForm prnt)
        {
            InitializeComponent();
            this.addOrEdit = addOrEdit;
            this.prnt = prnt;
        }
        public AddOrEditAccountDetailsForm(AccountDetailsForm prnt)
        {
            InitializeComponent();
            this.addOrEdit = AddOrEdit.Add;
            this.prnt = prnt;
        }
        public AddOrEditAccountDetailsForm(AccountDetailsEntry entry, AccountDetailsForm prnt)
        {
            InitializeComponent();
            this.addOrEdit = AddOrEdit.Edit;
            this.prnt = prnt;
            this.entry = entry;
            AccountNameTextBox.Text = entry.Name;
            if (this.entry.IsSubscription) { IsSubscriptionRadio.Checked = true; }
            if (this.entry.IsCredit) { IsCreditRadio.Checked = true; }
            if (this.entry.IsLoan) { IsLoanRadio.Checked = true; }
            if (this.entry.IsPlan) { IsPlanRadio.Checked = true; }
            if (this.entry.IsSubscription)
            {
                MonthlyPaymentTextBox.Text = this.entry.MonthlyPayment.ToString();
                FirstMonthlyPaymentDateTimePicker.Value = new DateTime(this.entry.NextPaymentDate.Year, this.entry.NextPaymentDate.Month, this.entry.NextPaymentDate.Day);
            }
            if (this.entry.IsCredit || this.entry.IsLoan)
            {
                MonthlyPaymentTextBox.Text = this.entry.MonthlyPayment.ToString();
                FirstMonthlyPaymentDateTimePicker.Value = new DateTime(this.entry.NextPaymentDate.Year, this.entry.NextPaymentDate.Month, this.entry.NextPaymentDate.Day);
                LastStatementBalanceTextBox.Text = (this.entry.LastStatementAmount * -1).ToString();
                LastStatementDateTimePicker.Value = new DateTime(((DateOnly)this.entry.LastStatementDate!).Year, ((DateOnly)this.entry.LastStatementDate).Month, ((DateOnly)this.entry.LastStatementDate).Day);
                AbsoluteMinimumMonthlyTextBox.Text = this.entry.AbsoluteMinimumPayment.ToString();
                PercentMinimumMonthlyTextBox.Text = this.entry.MinimumPercent.ToString();
                InterestRateTextBox.Text = this.entry.InterestRate.ToString();
                IncludeInterestToMinPayCheckBox.Checked = (bool)this.entry.IncludeInterestInMinimumPercent!;
                UseSecondMonthlyPaymentCheckBox.Checked = this.entry.NextPaymentDate2 != null ? true : false;
                if (this.entry.NextPaymentDate2 != null)
                {
                    UseSecondMonthlyPaymentCheckBox.Checked = true;
                    SecondMonthlyPaymentDateTImePicker.Value = new DateTime(((DateOnly)this.entry.NextPaymentDate2).Year, ((DateOnly)this.entry.NextPaymentDate2).Month, ((DateOnly)this.entry.NextPaymentDate2).Day);
                }

            }
            if(this.entry.IsPlan)
            {
                MonthlyPaymentTextBox.Text = this.entry.MonthlyPayment.ToString();
                FirstMonthlyPaymentDateTimePicker.Value = new DateTime(this.entry.NextPaymentDate.Year, this.entry.NextPaymentDate.Month, this.entry.NextPaymentDate.Day);
                LastStatementDateTimePicker.Value = new DateTime(this.entry.LastPaymentDate.Year, this.entry.LastPaymentDate.Month, this.entry.LastPaymentDate.Day);
            }
        }

        private void AccountTypeRadio_CheckedChanged(object sender, EventArgs e)
        {
            if (IsCreditRadio.Checked || IsLoanRadio.Checked)
            {
                LastStatementBalanceTextBox.Enabled = true;
                MonthlyPaymentTextBox.Enabled = true;
                AbsoluteMinimumMonthlyTextBox.Enabled = true;
                PercentMinimumMonthlyTextBox.Enabled= true;
                InterestRateTextBox.Enabled = true;
                LastStatementDateTimePicker.Enabled = true;
                FirstMonthlyPaymentDateTimePicker.Enabled = true;
                UseSecondMonthlyPaymentCheckBox.Enabled = true;
                if (UseSecondMonthlyPaymentCheckBox.Checked)
                {
                   SecondMonthlyPaymentDateTImePicker.Enabled = true;
                }
            }
            else if (IsSubscriptionRadio.Checked)
            {
                LastStatementBalanceTextBox.Enabled = false;
                MonthlyPaymentTextBox.Enabled = true;
                AbsoluteMinimumMonthlyTextBox.Enabled = false;
                PercentMinimumMonthlyTextBox.Enabled = false;
                InterestRateTextBox.Enabled = false; 
                LastStatementDateTimePicker.Enabled = false;
                FirstMonthlyPaymentDateTimePicker.Enabled = true;
                UseSecondMonthlyPaymentCheckBox.Enabled = false;
                SecondMonthlyPaymentDateTImePicker.Enabled = false;
            }
            else if (IsPlanRadio.Checked)
            {
                LastStatementBalanceTextBox.Enabled = false;
                MonthlyPaymentTextBox.Enabled = true;
                AbsoluteMinimumMonthlyTextBox.Enabled = false;
                PercentMinimumMonthlyTextBox.Enabled = false;
                InterestRateTextBox.Enabled = false;
                LastStatementDateTimePicker.Enabled = true;
                FirstMonthlyPaymentDateTimePicker.Enabled = true;
                UseSecondMonthlyPaymentCheckBox.Enabled = false;
                SecondMonthlyPaymentDateTImePicker.Enabled = false;
            }
        }

        private void UseSecondMonthlyPaymentCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (UseSecondMonthlyPaymentCheckBox.Checked == true)
            {
                SecondMonthlyPaymentDateTImePicker.Enabled = true;
            }
            else if (UseSecondMonthlyPaymentCheckBox.Checked == false)
            {
                SecondMonthlyPaymentDateTImePicker.Enabled = false;
            }

        }
        private void NumberTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsControl(e.KeyChar) && !char.IsDigit(e.KeyChar) && (e.KeyChar != '.'))
            {
                e.Handled = true;
            }

            // only allow one decimal point
            if ((e.KeyChar == '.') && ((sender as TextBox).Text.IndexOf('.') > -1))
            {
                e.Handled = true;
            }
        }
        private void SubmitBtn_Click(object sender, EventArgs e)
        {
            if (this.addOrEdit == AddOrEdit.Add)
            {
                AddAccount();
            }
            if (this.addOrEdit == AddOrEdit.Edit) 
            {
                EditAccount();
            }
        }
        private bool AddAccount()
        {
            SaveResult saveResult = new SaveResult();
            using (var context = new FinanceModel())
            {
                decimal tmpDec = 0;
                AccountDetailsEntry entry = new AccountDetailsEntry();
                entry.Name = AccountNameTextBox.Text;
                entry.IsSubscription = IsSubscriptionRadio.Checked;
                entry.IsCredit = IsCreditRadio.Checked;
                entry.IsLoan = IsLoanRadio.Checked;
                entry.IsPlan = IsPlanRadio.Checked;
                if(!(entry.IsLoan || entry.IsCredit || entry.IsSubscription || entry.IsPlan)) { return false; }
                if (entry.IsSubscription)
                {
                    if (Decimal.TryParse(MonthlyPaymentTextBox.Text, out tmpDec)) entry.MonthlyPayment = tmpDec;
                    else return false;
                    entry.NextPaymentDate = DateOnly.FromDateTime(FirstMonthlyPaymentDateTimePicker.Value);
                    entry.LastPaymentDate = entry.NextPaymentDate.AddMonths(-1);
                    entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                    entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                    context.AccountDetails.Add(entry);
                }
                else if (entry.IsCredit || entry.IsLoan)
                {
                    if (Decimal.TryParse(MonthlyPaymentTextBox.Text, out tmpDec)) entry.MonthlyPayment = tmpDec;
                    else return false;
                    if (Decimal.TryParse(AbsoluteMinimumMonthlyTextBox.Text, out tmpDec)) entry.AbsoluteMinimumPayment = tmpDec;
                    else return false;
                    if (Decimal.TryParse(PercentMinimumMonthlyTextBox.Text, out tmpDec)) entry.MinimumPercent = tmpDec;
                    else return false;
                    if (Decimal.TryParse(InterestRateTextBox.Text, out tmpDec)) entry.InterestRate = tmpDec;
                    else return false;
                    if (Decimal.TryParse(LastStatementBalanceTextBox.Text, out tmpDec)) entry.LastStatementAmount = -tmpDec;
                    else return false;
                    if (UseSecondMonthlyPaymentCheckBox.Checked)
                    {
                        entry.NextPaymentDate2 = DateOnly.FromDateTime(SecondMonthlyPaymentDateTImePicker.Value);
                        entry.LastPaymentDate2 = ((DateOnly)entry.NextPaymentDate2).AddMonths(-1);
                    }
                    
                    entry.LastStatementDate = DateOnly.FromDateTime(LastStatementDateTimePicker.Value);
                    entry.NextPaymentDate = DateOnly.FromDateTime(FirstMonthlyPaymentDateTimePicker.Value);
                    entry.LastPaymentDate = entry.NextPaymentDate.AddMonths(-1);
                    entry.IncludeInterestInMinimumPercent = IncludeInterestToMinPayCheckBox.Checked;
                    


                    //Calculate From User Entries
                    //InterestAccum = LastStatement * (((1+(APR/365))^#DaysPassed)-1)
                    entry.InterestAccumulated = (decimal?)entry.LastStatementAmount * ((decimal?)Math.Pow((1 + ((double)entry.InterestRate / 36500)), DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastStatementDate).DayNumber) - 1);

                    //Calculate Payment Accumulated
                    if (entry.MonthlyPayment < entry.AbsoluteMinimumPayment)
                    {
                        entry.PaymentAccumulated = (decimal)entry.AbsoluteMinimumPayment;
                    }
                    else entry.PaymentAccumulated = entry.MonthlyPayment;
                    if ((bool)entry.IncludeInterestInMinimumPercent)
                    {
                        decimal minPay_PercPlusInt = (decimal)-(
                            (entry.LastStatementAmount * entry.MinimumPercent / 100) + 
                            (entry.LastStatementAmount * (
                                (decimal)Math.Pow(
                                    1 + (double)(entry.InterestRate / 36500), 
                                    DateTime.DaysInMonth(
                                        ((DateOnly)entry.LastStatementDate).Year,
                                        ((DateOnly)entry.LastStatementDate).Month)
                                    ) - 1
                                )
                            )
                        );

                        if (entry.PaymentAccumulated < minPay_PercPlusInt) entry.PaymentAccumulated = -minPay_PercPlusInt;
                    }
                    else if (entry.PaymentAccumulated < -entry.LastStatementAmount * entry.MinimumPercent / 100) 
                        entry.PaymentAccumulated = (decimal)entry.LastStatementAmount * (decimal)entry.MinimumPercent / 100;
                    if (entry.NextPaymentDate2 != null)
                    {
                        entry.PaymentAccumulated2 = entry.PaymentAccumulated;
                    }
                    entry.PaymentAccumulated = entry.PaymentAccumulated * 
                        (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / 
                        (decimal)DateTime.DaysInMonth(
                            DateTime.Now.AddMonths(-1).Year, 
                            DateTime.Now.AddMonths(-1).Month);
                    if (entry.NextPaymentDate2 != null)
                    {
                        entry.PaymentAccumulated /= 2;
                        entry.PaymentAccumulated2 = entry.PaymentAccumulated2 * (DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastPaymentDate2).DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                        entry.PaymentAccumulated2 /= 2;
                        entry.PaymentAccumulated2 = Math.Round((decimal)entry.PaymentAccumulated2!, 2);
                    }

                    entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                    entry.InterestAccumulated = Math.Round((decimal)entry.InterestAccumulated, 2);
                    entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    context.AccountDetails.Add(entry);
                }
                else if (entry.IsPlan)
                {
                    if (Decimal.TryParse(MonthlyPaymentTextBox.Text, out tmpDec)) entry.MonthlyPayment = tmpDec;
                    else return false;
                    entry.NextPaymentDate = DateOnly.FromDateTime(FirstMonthlyPaymentDateTimePicker.Value);
                    entry.LastPaymentDate = DateOnly.FromDateTime(LastStatementDateTimePicker.Value);
                    entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (entry.NextPaymentDate.DayNumber - entry.LastPaymentDate.DayNumber);
                    entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                    context.AccountDetails.Add(entry);

                }
                try
                {
                    context.SaveChanges();
                    saveResult.Message = "Save successful.";
                    saveResult.Title = "Save Successful";
                    saveResult.ShowDialog();
                }
                catch (Exception ex)
                {
                    saveResult.Message = ex.InnerException.ToString();
                    saveResult.ShowDialog();
                    Debug.WriteLine("Trevor Exception: " + ex.Message + Environment.NewLine + ex.InnerException);
                }
                prnt.AccountsListBox.DataSource = context.AccountDetails.ToList();
                prnt.AccountsListBox.DisplayMember = "Name";
                return true;
            }
        }
        private bool EditAccount()
        {
            SaveResult saveResult = new SaveResult();
            using (var context = new FinanceModel())
            {
                decimal tmpDec = 0;
                AccountDetailsEntry entry = context.AccountDetails.Where(e => e.Name == this.entry.Name).ToList()[0];
                entry.Name = AccountNameTextBox.Text;
                entry.IsSubscription = IsSubscriptionRadio.Checked;
                entry.IsCredit = IsCreditRadio.Checked;
                entry.IsLoan = IsLoanRadio.Checked;
                if (!(entry.IsLoan || entry.IsCredit || entry.IsSubscription || entry.IsPlan)) { return false; }
                if (entry.IsSubscription)
                {
                    if (Decimal.TryParse(MonthlyPaymentTextBox.Text, out tmpDec)) entry.MonthlyPayment = tmpDec;
                    else return false;
                    entry.NextPaymentDate = DateOnly.FromDateTime(FirstMonthlyPaymentDateTimePicker.Value);
                    entry.LastPaymentDate = entry.NextPaymentDate.AddMonths(-1);
                    entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                    entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);

                }
                else if (entry.IsCredit || entry.IsLoan)
                {
                    if (Decimal.TryParse(MonthlyPaymentTextBox.Text, out tmpDec)) entry.MonthlyPayment = tmpDec;
                    else return false;
                    if (Decimal.TryParse(AbsoluteMinimumMonthlyTextBox.Text, out tmpDec)) entry.AbsoluteMinimumPayment = tmpDec;
                    else return false;
                    if (Decimal.TryParse(PercentMinimumMonthlyTextBox.Text, out tmpDec)) entry.MinimumPercent = tmpDec;
                    else return false;
                    if (Decimal.TryParse(InterestRateTextBox.Text, out tmpDec)) entry.InterestRate = tmpDec;
                    else return false;
                    if (Decimal.TryParse(LastStatementBalanceTextBox.Text, out tmpDec)) entry.LastStatementAmount = -tmpDec;
                    else return false;
                    if (UseSecondMonthlyPaymentCheckBox.Checked)
                    {
                        entry.NextPaymentDate2 = DateOnly.FromDateTime(SecondMonthlyPaymentDateTImePicker.Value);
                        entry.LastPaymentDate2 = ((DateOnly)entry.NextPaymentDate2).AddMonths(-1);
                    }

                    entry.LastStatementDate = DateOnly.FromDateTime(LastStatementDateTimePicker.Value);
                    entry.NextPaymentDate = DateOnly.FromDateTime(FirstMonthlyPaymentDateTimePicker.Value);
                    entry.LastPaymentDate = entry.NextPaymentDate.AddMonths(-1);
                    entry.IncludeInterestInMinimumPercent = IncludeInterestToMinPayCheckBox.Checked;



                    //Calculate From User Entries
                    //InterestAccum = LastStatement * (((1+(APR/365))^#DaysPassed)-1)
                    entry.InterestAccumulated = (decimal?)entry.LastStatementAmount * ((decimal?)Math.Pow((1 + ((double)entry.InterestRate / 36500)), DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastStatementDate).DayNumber) - 1);

                    //Calculate Payment Accumulated
                    if (entry.MonthlyPayment < entry.AbsoluteMinimumPayment)
                    {
                        entry.PaymentAccumulated = (decimal)entry.AbsoluteMinimumPayment;
                    }
                    else entry.PaymentAccumulated = entry.MonthlyPayment;
                    if ((bool)entry.IncludeInterestInMinimumPercent)
                    {
                        decimal minPay_PercPlusInt = (decimal)-(
                            (entry.LastStatementAmount * entry.MinimumPercent / 100) +
                            (entry.LastStatementAmount * (
                                (decimal)Math.Pow(
                                    1 + (double)(entry.InterestRate / 36500),
                                    DateTime.DaysInMonth(
                                        ((DateOnly)entry.LastStatementDate).Year,
                                        ((DateOnly)entry.LastStatementDate).Month)
                                    ) - 1
                                )
                            )
                        );

                        if (entry.PaymentAccumulated < minPay_PercPlusInt) entry.PaymentAccumulated = -minPay_PercPlusInt;
                    }
                    else if (entry.PaymentAccumulated < -entry.LastStatementAmount * entry.MinimumPercent / 100)
                        entry.PaymentAccumulated = (decimal)entry.LastStatementAmount * (decimal)entry.MinimumPercent / 100;
                    if (entry.NextPaymentDate2 != null)
                    {
                        entry.PaymentAccumulated2 = entry.PaymentAccumulated;
                    }
                    entry.PaymentAccumulated = entry.PaymentAccumulated *
                        (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) /
                        (decimal)DateTime.DaysInMonth(
                            DateTime.Now.AddMonths(-1).Year,
                            DateTime.Now.AddMonths(-1).Month);
                    if (entry.NextPaymentDate2 != null)
                    {
                        entry.PaymentAccumulated /= 2;
                        entry.PaymentAccumulated2 = entry.PaymentAccumulated2 * (DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastPaymentDate2).DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                        entry.PaymentAccumulated2 /= 2;
                        entry.PaymentAccumulated2 = Math.Round((decimal)entry.PaymentAccumulated2!, 2);
                    }

                    entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                    entry.InterestAccumulated = Math.Round((decimal)entry.InterestAccumulated, 2);
                    entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                }
                else if (entry.IsPlan)
                {
                    if (Decimal.TryParse(MonthlyPaymentTextBox.Text, out tmpDec)) entry.MonthlyPayment = tmpDec;
                    else return false;
                    entry.NextPaymentDate = DateOnly.FromDateTime(FirstMonthlyPaymentDateTimePicker.Value);
                    entry.LastPaymentDate = DateOnly.FromDateTime(LastStatementDateTimePicker.Value);
                    entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (entry.NextPaymentDate.DayNumber - entry.LastPaymentDate.DayNumber);
                    entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                }
                try
                {
                    context.SaveChanges();
                    saveResult.Message = "Save successful.";
                    saveResult.Title = "Save Successful";
                    saveResult.ShowDialog();
                }
                catch (Exception ex)
                {
                    saveResult.Message = ex.InnerException.ToString();
                    saveResult.ShowDialog();
                    Debug.WriteLine("Trevor Exception: " + ex.Message + Environment.NewLine + ex.InnerException);
                }
                prnt.AccountsListBox.DataSource = context.AccountDetails.ToList();
                prnt.AccountsListBox.DisplayMember = "Name";
                return true;
            }
        }
        private bool UpdateAccounts()
        {
            SaveResult saveResult = new SaveResult();
            using (var context = new FinanceModel())
            {
                var query = context.AccountDetails.ToList();
                for (int i = 0; i < query.Count; i++)
                {
                    AccountDetailsEntry entry = query[i];
                    if (!(entry.IsLoan || entry.IsCredit || entry.IsSubscription || entry.IsPlan)) { return false; }
                    if (entry.IsSubscription)
                    {
                        entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                        entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    }
                    else if (entry.IsCredit || entry.IsLoan)
                    {

                        //Calculate From User Entries
                        //InterestAccum = LastStatement * (((1+(APR/365))^#DaysPassed)-1)
                        entry.InterestAccumulated = (decimal?)entry.LastStatementAmount * ((decimal?)Math.Pow((1 + ((double)entry.InterestRate! / 36500)), DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastStatementDate!).DayNumber) - 1);

                        //Calculate Payment Accumulated
                        if (entry.MonthlyPayment < entry.AbsoluteMinimumPayment)
                        {
                            entry.PaymentAccumulated = (decimal)entry.AbsoluteMinimumPayment;
                        }
                        else entry.PaymentAccumulated = entry.MonthlyPayment;
                        if ((bool)entry.IncludeInterestInMinimumPercent!)
                        {
                            decimal minPay_PercPlusInt = (decimal)-((entry.LastStatementAmount * entry.MinimumPercent / 100) + (entry.LastStatementAmount * ((decimal)Math.Pow((double)1 + (double)(entry.InterestRate / 36500), DateTime.DaysInMonth(((DateOnly)entry.LastStatementDate).Year, ((DateOnly)entry.LastStatementDate).Month)) - 1)))!;
                            if (entry.PaymentAccumulated < minPay_PercPlusInt) entry.PaymentAccumulated = -minPay_PercPlusInt;
                        }
                        else if (entry.PaymentAccumulated < -entry.LastStatementAmount * entry.MinimumPercent / 100) entry.PaymentAccumulated = (decimal)entry.LastStatementAmount! * (decimal)entry.MinimumPercent! / 100;
                        if (entry.NextPaymentDate2 != null)
                        {
                            entry.PaymentAccumulated2 = entry.PaymentAccumulated;
                        }

                        entry.PaymentAccumulated = entry.PaymentAccumulated * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.AddMonths(-1).Year, DateTime.Now.AddMonths(-1).Month);
                        if (entry.NextPaymentDate2 != null)
                        {
                            entry.PaymentAccumulated /= 2;
                            entry.PaymentAccumulated2 = entry.PaymentAccumulated2 * (DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastPaymentDate2!).DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                            entry.PaymentAccumulated2 /= 2;
                            entry.PaymentAccumulated2 = Math.Round((decimal)entry.PaymentAccumulated2!, 2);
                        }

                        entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                        entry.InterestAccumulated = Math.Round((decimal)entry.InterestAccumulated!, 2);
                        entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    }
                    else if (entry.IsPlan)
                    {
                        entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (entry.NextPaymentDate.DayNumber - entry.LastPaymentDate.DayNumber);
                        entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    }
                }
                try
                {
                    context.SaveChanges();
                    saveResult.Message = "Save successful.";
                    saveResult.Title = "Save Successful";
                    saveResult.ShowDialog();
                }
                catch (Exception ex)
                {
                    saveResult.Message = ex.InnerException.ToString();
                    saveResult.ShowDialog();
                    Debug.WriteLine("Trevor Exception: " + ex.Message + Environment.NewLine + ex.InnerException);
                }
                prnt.AccountsListBox.DataSource = context.AccountDetails.ToList();
                prnt.AccountsListBox.DisplayMember = "Name";

                return true;
            }
        }
        private void EnableAppropriateControls()
        {
            if (IsCreditRadio.Checked || IsLoanRadio.Checked)
            {
                LastStatementBalanceTextBox.Enabled = true;
                MonthlyPaymentTextBox.Enabled = true;
                AbsoluteMinimumMonthlyTextBox.Enabled = true;
                PercentMinimumMonthlyTextBox.Enabled = true;
                InterestRateTextBox.Enabled = true;
                LastStatementDateTimePicker.Enabled = true;
                FirstMonthlyPaymentDateTimePicker.Enabled = true;
                UseSecondMonthlyPaymentCheckBox.Enabled = true;
                if (UseSecondMonthlyPaymentCheckBox.Checked)
                {
                    SecondMonthlyPaymentDateTImePicker.Enabled = true;
                }
            }
            else if (IsSubscriptionRadio.Checked)
            {
                LastStatementBalanceTextBox.Enabled = false;
                MonthlyPaymentTextBox.Enabled = true;
                AbsoluteMinimumMonthlyTextBox.Enabled = false;
                PercentMinimumMonthlyTextBox.Enabled = false;
                InterestRateTextBox.Enabled = false;
                LastStatementDateTimePicker.Enabled = false;
                FirstMonthlyPaymentDateTimePicker.Enabled = true;
                UseSecondMonthlyPaymentCheckBox.Enabled = false;
                SecondMonthlyPaymentDateTImePicker.Enabled = false;
            }
        }
    }
}
