﻿
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class AddOrEditTagRuleForm : Form
    {
        enum AddOrEdit
        {
            Add,
            Edit
        }
        private AddOrEdit addOrEdit;
        private FultonTagEntry? TagEntry;
        public AddOrEditTagRuleForm()
        {
            addOrEdit = AddOrEdit.Add;
            InitializeComponent();
            this.Text = "Add Tag Rule";
            this.ConfirmBtn.Text = "Add";
        }
        public AddOrEditTagRuleForm(FultonTagEntry tagEntry)
        {
            addOrEdit = AddOrEdit.Edit;
            TagEntry = tagEntry;

            InitializeComponent();

            this.Text = "Edit Tag Rule";
            this.ConfirmBtn.Text = "Edit";
            this.TagNameTextBox.Enabled = false;
            this.TagNameTextBox.Text = tagEntry.TagName;
            this.MemoContainsTextBox.Text = string.Join(",", tagEntry.Memo_Contains ?? new string[] { "" });
            //this.MemoContainsTextBox.Text = tagEntry.Memo_Contains ?? "";
            this.IsStoreTextBox.Text = string.Join(",", tagEntry.IsStore ?? new string[] { "" });
            this.IsMajorTagTextBox.Text = string.Join(",", tagEntry.IsMajorTag ?? new string[] { "" });
            this.LessThanDebitTextBox.Text = tagEntry.Greater_Than_Amount.ToString();
            this.GreaterThanDebitTextBox.Text = tagEntry.Less_Than_Amount.ToString();
            this.EqualToDebitTextBox.Text = tagEntry.Equal_To_Amount.ToString();
            this.NotEqualToDebitTextBox.Text = tagEntry.Not_Equal_To_Amount.ToString();
            this.SetStoreTextBox.Text = tagEntry.SetStore;
            this.SetMajorTagTextBox.Text = tagEntry.SetMajorTag;
            this.SetMinorTagTextBox.Text = string.Join(",", tagEntry.SetMinorTags ?? new string[] { "" });
            



        }

        private void ConfirmBtn_Click(object sender, EventArgs e)
        {
            if (addOrEdit == AddOrEdit.Add)
            {
                Add();
            }
            else Edit();
               
        }
        private void Add()
        {
            try
            {
                TagEntry = new FultonTagEntry()
                {
                    TagName = this.TagNameTextBox.Text,
                    Memo_Contains = this.MemoContainsTextBox.Text == "" ? null : this.MemoContainsTextBox.Text.Split(","),
                    //Memo_Contains = this.MemoContainsTextBox.Text == "" ? null : this.MemoContainsTextBox.Text,
                    IsStore = this.IsStoreTextBox.Text == "" ? null : this.IsStoreTextBox.Text.Split(","),
                    IsMajorTag = this.IsMajorTagTextBox.Text == "" ? null : this.IsMajorTagTextBox.Text.Split(","),
                    Equal_To_Amount = this.EqualToDebitTextBox.Text == "" ? null : Decimal.Parse(this.EqualToDebitTextBox.Text),
                    Not_Equal_To_Amount = this.NotEqualToDebitTextBox.Text == "" ? null : Decimal.Parse(this.EqualToDebitTextBox.Text),
                    Less_Than_Amount = this.GreaterThanDebitTextBox.Text == "" ? null : Decimal.Parse (this.GreaterThanDebitTextBox.Text),
                    Greater_Than_Amount = this.LessThanDebitTextBox.Text == "" ? null : Decimal.Parse(this.LessThanDebitTextBox.Text),
                    SetStore = this.SetStoreTextBox.Text == "" ? null : this.SetStoreTextBox.Text,
                    SetMajorTag = this.SetMajorTagTextBox.Text == "" ? null : this.SetMajorTagTextBox.Text,
                    SetMinorTags = this.SetMinorTagTextBox.Text == "" ? null : this.SetMinorTagTextBox.Text.Split(",")

                };
                using (var context = new FinanceModel())
                {
                    context.FultonTags.Add(TagEntry);
                    context.SaveChanges();
                    foreach (Form form in Application.OpenForms)
                    {
                        if (form is FultonTransactionTaggingRulesForm)
                        {
                            ((FultonTransactionTaggingRulesForm)form).TagRulesListBox.DataSource = context.FultonTags.ToList();           
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                SaveResult failedSave = new SaveResult();
                failedSave.Message = ex.Message;
                failedSave.Title = "Failed Save";
                failedSave.Show();
                return;

            }

            
        }
        private void Edit()
        {
            try
            {
                using (var context = new FinanceModel())
                {
                    TagEntry = context.FultonTags.Where(e => e.TagName == this.TagNameTextBox.Text).ToArray()[0];
                    //TagEntry.TagName = this.TagNameTextBox.Text;
                    TagEntry.Memo_Contains = this.MemoContainsTextBox.Text == "" ? null : this.MemoContainsTextBox.Text.Split(",");
                    //TagEntry.Memo_Contains = this.MemoContainsTextBox.Text == "" ? null : this.MemoContainsTextBox.Text;
                    TagEntry.IsStore = this.IsStoreTextBox.Text == "" ? null : this.IsStoreTextBox.Text.Split(",");
                    TagEntry.IsMajorTag = this.IsMajorTagTextBox.Text == "" ? null : this.IsMajorTagTextBox.Text.Split(",");
                    TagEntry.Equal_To_Amount = this.EqualToDebitTextBox.Text == "" ? null : Decimal.Parse(this.EqualToDebitTextBox.Text);
                    TagEntry.Not_Equal_To_Amount = this.NotEqualToDebitTextBox.Text == "" ? null : Decimal.Parse(this.EqualToDebitTextBox.Text);
                    TagEntry.Less_Than_Amount = this.GreaterThanDebitTextBox.Text == "" ? null : Decimal.Parse(this.GreaterThanDebitTextBox.Text);
                    TagEntry.Greater_Than_Amount = this.LessThanDebitTextBox.Text == "" ? null : Decimal.Parse(this.LessThanDebitTextBox.Text);
                    TagEntry.SetStore = this.SetStoreTextBox.Text == "" ? null : this.SetStoreTextBox.Text;
                    TagEntry.SetMajorTag = this.SetMajorTagTextBox.Text == "" ? null : this.SetMajorTagTextBox.Text;
                    TagEntry.SetMinorTags = this.SetMinorTagTextBox.Text == "" ? null : this.SetMinorTagTextBox.Text.Split(",");
                

                    
                     
                    context.SaveChanges();
                }
            }
            catch (Exception ex)
            {
                SaveResult failedSave = new SaveResult();
                failedSave.Message = ex.Message;
                failedSave.Title = "Failed Save";
                failedSave.Show();
                return;

            }
        }
    }
}
