﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FinanceTrackerApplication
{
    internal class CashAccountEntry : BankAccountEntry
    {
        private decimal _cashAtHome;
        public decimal CashAtHome
        {
            get
            {
                return _cashAtHome;
            }
            set
            {
                _cashAtHome = value;
                Amount = CashAtHome + CashInCar + CashInWallet;
            }
        }
        private decimal _cashInCar;
        public decimal CashInCar
        {
            get
            {
                return _cashInCar;
            }
            set
            {
                _cashInCar = value;
                Amount = CashAtHome + CashInCar + CashInWallet;
            }
        }
        private decimal _cashInWallet;
        public decimal CashInWallet
        {
            get { return _cashInWallet; }
            set
            {
                _cashInWallet = value;
                Amount = CashAtHome + CashInCar + CashInWallet;
            }
        }
        private decimal _amount;
        public override decimal Amount
        {
            get { return _amount; }
            set
            {
                if (CashInWallet == 0 && CashAtHome == 0 && CashInCar == 0) { _amount = value; }
            }
        }
        public CashAccountEntry(decimal amount, DateTime dateOfEntry) : base(amount, dateOfEntry) 
        {
            CashAtHome = 0;
            CashInCar = 0;
            CashInWallet = 0;
        }
        public CashAccountEntry(decimal cashInWallet, decimal cashAtHome, decimal cashInCar, DateTime dateOfEntry) : base(cashAtHome + cashInCar + cashInWallet, dateOfEntry)
        {
            CashAtHome = cashAtHome;
            CashInCar = cashInCar;
            CashInWallet= cashInWallet;
        }

      
    }
}
