﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class ExcelForm : Form
    {
        private int MemoNegativeWidth;
        private DateOnly startDate;
        private DateOnly endDate;
        private string?[] stores;
        private string?[] tags;
        private int rowHeight = 20;
        private int maxRowCount = 500;
        internal FultonTransactionEntry[] ReferenceSheet { get; set; }
        internal FultonTransactionEntry[] CurrentSheet { get; set; }
        internal ExcelForm(FultonTransactionEntry[] sheet)
        {
            InitializeComponent();
            startDate = sheet.Min(e => e.Date)!.Value;
            endDate = sheet.Max(e => e.Date)!.Value;
            startDateTimePicker.Value = startDate.ToDateTime(TimeOnly.MinValue);
            endDateTimePicker.Value = endDate.ToDateTime(TimeOnly.MinValue);
            UpdateStores();


            DayIntervalPicker.Value = 1;
            ReferenceSheet = sheet;
            MemoNegativeWidth = (int)(
                tableLayoutPanel.ColumnStyles[0].Width + 
                tableLayoutPanel.ColumnStyles[2].Width +
                tableLayoutPanel.ColumnStyles[3].Width + 
                tableLayoutPanel.ColumnStyles[4].Width + 
                tableLayoutPanel.ColumnStyles[5].Width);

            UpdateExcel();
        }


        private void ExcelForm_ResizeEnd(object sender, EventArgs e)
        {
            tableLayoutPanel.Width = this.Width - 42;
            panel.Height = this.Height - 101;
            panel.Width = this.Width - 42;
            tableLayoutPanel.ColumnStyles[1].Width = tableLayoutPanel.Width - MemoNegativeWidth;
            for (int i = 0; i < tableLayoutPanel.RowCount; i++)
            {
                tableLayoutPanel.GetControlFromPosition(1, i).Width = tableLayoutPanel.Width - MemoNegativeWidth;
            }
        }
        internal void UpdateExcel()
        {
            CurrentSheet = ReferenceSheet.Where(e => e.Date >= startDate && e.Date <= endDate).Where(e => e.IsStore(stores)).OrderBy(e => e.Store).OrderBy(e => e.Memo).ToArray();

            //for (int i = 0; i < tableLayoutPanel.Controls.Count; i++)
            //{
            //    tableLayoutPanel.Controls.Remove(tableLayoutPanel.Controls[0]);
            //}
            int currentSheetLengthPlusOneOrMaxRowCount = CurrentSheet.Length + 1 < maxRowCount ? CurrentSheet.Length + 1 : maxRowCount;

            //tableLayoutPanel.RowCount = this.CurrentSheet.Length + 1;
            if (CurrentSheet.Length + 1 > tableLayoutPanel.RowCount)
            {
                AddRows(currentSheetLengthPlusOneOrMaxRowCount - tableLayoutPanel.RowCount);
            }

            SetRow(new string[]
            {
                "Date",
                "Memo",
                "Amount",
                "Balance",
                "Store",
                "Tag"
            }, 0);

            for (int row = 1; row < currentSheetLengthPlusOneOrMaxRowCount; row++)
            {
                SetRow(new string[]
                {
                CurrentSheet[row - 1].Date.ToString() ?? "",
                CurrentSheet[row - 1].Memo,
                CurrentSheet[row - 1].Amount.ToString(),
                CurrentSheet[row - 1].Balance.ToString() ?? "",
                CurrentSheet[row - 1].Store ?? "",
                CurrentSheet[row - 1].Major_Tag ?? ""
                }, row);
            }
            for (int row = CurrentSheet.Length + 1; row < tableLayoutPanel.RowCount; row++)
            {
                SetRow(new string[]
                {
                    "",
                    "",
                    "",
                    "",
                    "",
                    ""
                }, row);
            }
            
            
            tableLayoutPanel.Height = (currentSheetLengthPlusOneOrMaxRowCount) * rowHeight;
            
            TableLayoutRowStyleCollection styles = tableLayoutPanel.RowStyles;
            foreach (RowStyle style in styles)
            {
                style.SizeType = SizeType.Absolute;
                style.Height = rowHeight;
            }
        }
        private async void UpdateExcelAsync( )
        {
            await Task.Run(UpdateExcel);
        }
        
        private void AddRows(int numRows)
        {
            tableLayoutPanel.RowCount += numRows;
            int maxColumns = tableLayoutPanel.ColumnCount;
            for (int row = tableLayoutPanel.RowCount - numRows; row < tableLayoutPanel.RowCount; row++) 
            {
                tableLayoutPanel.RowStyles.Add(new RowStyle() { Height = rowHeight, SizeType = SizeType.Absolute });
                for (int column = 0; column < maxColumns; column++)
                {
                    Label label = new Label();
                    tableLayoutPanel.SetCellPosition(label, new TableLayoutPanelCellPosition(column, row));
                    tableLayoutPanel.Controls.Add(label);
                    if (column == 1) { label.Width = tableLayoutPanel.Width - MemoNegativeWidth; }
                    
                }
            }
        }
        private void SetRow(string[] labels, int row)
        {
            if (row < 0 || row >= tableLayoutPanel.RowCount)
            {
                Debug.WriteLine("ExcelForm.SetRow: ROW DOESN'T EXIST IN TABLE");
            }
            else
            {
                //int maxColumns = labels.Length > tableLayoutPanel.ColumnCount ? tableLayoutPanel.ColumnCount : labels.Length;
                //for (int i = 0; i < maxColumns; i++)
                //{
                //    Label label = new Label() { Text = labels[i] };
                //    tableLayoutPanel.Controls.Remove(tableLayoutPanel.GetControlFromPosition(i, row));
                //    tableLayoutPanel.SetCellPosition(label, new TableLayoutPanelCellPosition(i, row));
                //    tableLayoutPanel.Controls.Add(label);
                //    if (i == 1) { label.Width = tableLayoutPanel.Width - MemoNegativeWidth; }
                //}
                int maxColumns = labels.Length > tableLayoutPanel.ColumnCount ? tableLayoutPanel.ColumnCount : labels.Length;
                for (int column = 0; column < maxColumns; column++)
                {
                    Control? control = tableLayoutPanel.GetControlFromPosition(column, row);
                    if (control != null) control.Text = labels[column];
                    else
                    {
                        control = new Label() { Text = labels[column] };
                        tableLayoutPanel.Controls.Add(control);
                        tableLayoutPanel.SetCellPosition(control, new TableLayoutPanelCellPosition(column, row));
                        if (column == 1) { control.Width = tableLayoutPanel.Width - MemoNegativeWidth; }
                    }
                }
            }
            

        }

        private void StoreTextBox_TextChanged(object sender, EventArgs e)
        {
            UpdateStores();
            UpdateExcel();
            //UpdateExcelAsync();
                
           
        }

        private void RefreshBtn_Click(object sender, EventArgs e)
        {
            UpdateExcel();
        }

        private void startDateTimePicker_ValueChanged(object sender, EventArgs e)
        {
            startDate = DateOnly.FromDateTime(startDateTimePicker.Value);
        }

        private void endDateTimePicker_ValueChanged(object sender, EventArgs e)
        {
            endDate = DateOnly.FromDateTime(endDateTimePicker.Value);
        }

        private void TagsTextBox_TextChanged(object sender, EventArgs e)
        {
            UpdateTags();
            UpdateExcel();
        }

        private void EditTagRulesBtn_Click(object sender, EventArgs e)
        {
            FultonTransactionTaggingRulesForm tagRulesForm = new();
            tagRulesForm.Show();
        }
        private void UpdateStores()
        {
            stores = StoreTextBox.Text.Split(",");
            for (int i = 0; i < stores.Length; i++)
            {
                if (stores[i] == "null") stores[i] = null;
            }
        }
        private void UpdateTags()
        {
            tags = TagsTextBox.Text.Split(",");
            
            for (int i = 0; i < tags.Length; i++)
            {
                if (tags[i] != null) tags[i] = tags[i]!.Trim();
                if (tags[i] == "null") tags[i] = null;
            }
        }
    }
}
