﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class FinancialTrackerForm : Form
    {
        public static readonly string[] cashList = new string[] { "Fulton", "Cash" };
        public static readonly string[] stocksList = new string[] { "Robinhood", "ETrade", "FirstTrade", "Coinbase" };
        public static readonly string[] quickWithdrawalList = new string[] { "Uber", "Lyft", "GrubHub", "DoorDash", "Stripe", "Venmo", "PayPal", "CashApp", "Fiverr"}.Concat(stocksList).ToArray();
        public static readonly string[] creditList = new string[] { "PNC", "Discover", "Citi" };
        public static readonly string[] difficultCreditList = new string[] { "PayPal Credit", "DFS", "Drive"  };
        public static readonly string[] loanList = new string[] { "Aidvantage", "IRS", "PA Tax" };
        public static readonly string[] otherList = new string[] { "Other" };
        public static readonly string[] fromList = cashList.Concat(quickWithdrawalList).Concat(difficultCreditList).Concat(otherList).ToArray();
        public static readonly string[] toList = cashList.Concat(stocksList).Concat(creditList).Concat(difficultCreditList).Concat(loanList).Concat(otherList).ToArray();

        private decimal fulton;
        private decimal pnc;
        private decimal discover;
        private decimal citi;
        private decimal cash;
        private decimal aidvantage;
        private decimal dfs;
        private decimal drive;
        private decimal paypal;
        private decimal dad;
        private decimal uber;
        private decimal lyft;
        private decimal stripe;
        private decimal irs;
        private decimal grubhub;
        private decimal doordash;
        private decimal venmo;
        private decimal cashapp;
        private decimal fiverr;
        private decimal patax;
        private decimal etrade;
        private decimal firsttrade;
        private decimal robinhood;
        private decimal coinbase;

        private decimal YTDTaxes = 0;
        private decimal Taxes2022 = -10656.27M;

        private string? notes;

        internal decimal totalCash = 0;
        internal decimal totalCashQuickWithdrawal = 0;
        internal decimal totalCashQuickWithdrawalPlusCredit = 0;
        internal decimal totalCashQuickWithdrawalPlusDifficultCredit = 0;
        internal decimal total = 0;
        internal decimal totalCashWithdrawalPlusCredit = 0;

        internal decimal adjustedTotalCashQuickWithdrawal = 0;
        internal decimal adjustedTotal = 0;
        internal decimal accumulatedSubscriptionPayment = 0;
        internal decimal accumulatedCreditPayment = 0;
        internal decimal accumulatedPlanPayment = 0;
        internal decimal accumulatedInterest = 0;

        internal UnpostedTransaction UPT1;
        internal UnpostedTransaction UPT2;
        internal UnpostedTransaction UPT3;

        private DateTime now = DateTime.Now;

        public FinancialTrackerForm()
        {
            InitializeComponent();
        }

        //Only allow digits and a single '.' in TextBoxes
        private void NumberTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsControl(e.KeyChar) && !char.IsDigit(e.KeyChar) && (e.KeyChar != '.'))
            {
                e.Handled = true;
            }

            // only allow one decimal point
            if ((e.KeyChar == '.') && ((sender as TextBox).Text.IndexOf('.') > -1))
            {
                e.Handled = true;
            }
            if (char.IsControl(e.KeyChar))
            {
                Debug.WriteLine("KEY CHAR CONTROL: " + e.KeyChar);
            }
        }

        //Initialize Unposted Transactions to Work as Group
        private void FinancialTrackerForm_Load(object sender, EventArgs e)
        {   
            UPT1 = new UnpostedTransaction(this, UPT1CheckBox, UPT1Amount, UPT1FromBox, UPT1ToBox, UPT1FromButton, UPT1ToButton);
            UPT2 = new UnpostedTransaction(this, UPT2CheckBox, UPT2Amount, UPT2FromBox, UPT2ToBox, UPT2FromButton, UPT2ToButton);
            UPT3 = new UnpostedTransaction(this, UPT3CheckBox, UPT3Amount, UPT3FromBox, UPT3ToBox, UPT3FromButton, UPT3ToButton);
            UnpostedTransaction.Initialize(UPT1, UPT2, UPT3);

            System.Diagnostics.Debug.WriteLine(this.FultonTextBox.Focus());
            //System.Diagnostics.Debug.WriteLine((UIElement)this.FultonTextBox.Focusable);
        }

        //Try To Save Data to the SQL Table
        private void LoadSQL()
        {
            AccountDetailsEntry.UpdateAccounts();
            
            SaveResult failedSave = new SaveResult();
            FailParse failParse = new FailParse(this);
            

            bool[] parseSuccessful = new bool[] { false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false };


            
            totalCash = 0;
            totalCashQuickWithdrawal = 0;
            totalCashQuickWithdrawalPlusCredit = 0;
            totalCashQuickWithdrawalPlusDifficultCredit = 0;
            total = 0;

            notes = NotesTextBox.Text;
            if (notes == "") notes = null;
            
            parseSuccessful[0] = Decimal.TryParse(FultonTextBox.Text, out fulton);
            parseSuccessful[1] = Decimal.TryParse(pncTextBox.Text, out pnc);
            parseSuccessful[2] = Decimal.TryParse(discoverTextBox.Text, out discover);
            parseSuccessful[3] = Decimal.TryParse(citiTextBox.Text, out citi);
            parseSuccessful[4] = Decimal.TryParse(cashTextBox.Text, out cash);
            parseSuccessful[5] = Decimal.TryParse(aidvantageTextBox.Text, out aidvantage);
            parseSuccessful[6] = Decimal.TryParse(dfsTextBox.Text, out dfs);
            parseSuccessful[7] = Decimal.TryParse(driveTextBox.Text, out drive);
            parseSuccessful[8] = Decimal.TryParse(paypalTextBox.Text, out paypal);
            parseSuccessful[9] = Decimal.TryParse(dadTextBox.Text, out dad);
            parseSuccessful[10] = Decimal.TryParse(uberTextBox.Text, out uber);
            parseSuccessful[11] = Decimal.TryParse(lyftTextBox.Text, out lyft);
            parseSuccessful[12] = Decimal.TryParse(stripeTextBox.Text, out stripe);
            parseSuccessful[13] = Decimal.TryParse(irsTextBox.Text, out irs);
            parseSuccessful[14] = Decimal.TryParse(grubHubTextBox.Text, out grubhub);
            parseSuccessful[15] = Decimal.TryParse(doorDashTextBox.Text, out doordash);
            parseSuccessful[16] = Decimal.TryParse(venmoTextBox.Text, out venmo);
            parseSuccessful[17] = Decimal.TryParse(cashAppTextBox.Text, out cashapp);
            parseSuccessful[18] = Decimal.TryParse(fiverrTextBox.Text, out fiverr);
            parseSuccessful[19] = UPT1.TryParse(now);
            parseSuccessful[20] = UPT2.TryParse(now);
            parseSuccessful[21] = UPT3.TryParse(now);
            parseSuccessful[22] = Decimal.TryParse(PATaxTextBox.Text, out patax);
            parseSuccessful[23] = Decimal.TryParse(CoinBaseTextBox.Text, out coinbase);
            parseSuccessful[24] = Decimal.TryParse(ETradeTextBox.Text, out etrade);
            parseSuccessful[25] = Decimal.TryParse(FirstTradeTextBox.Text, out firsttrade);
            parseSuccessful[26] = Decimal.TryParse(RobinHoodTextBox.Text, out robinhood);
            
            //Check that Parse was Successful if not ShowDialog 
            foreach (bool parse in parseSuccessful)
            {
                if (!parse)
                {
                    failParse.ShowDialog(this);
                    return;
                }
            }

            pnc = -pnc;
            discover = -discover;
            citi = -citi;
            aidvantage = -aidvantage;
            dad = -dad;
            dfs = -dfs;
            drive = -drive;
            paypal = -paypal;
            irs = -irs;
            patax = -patax;

            //TODO: Update Total to be current and easily readable Especially when unposted transactions becomes functional and stocks
            string message = "";
            using (var context = new FinanceModel())
            {
                YTDEarningsEntry lastYTD = context.YTDEarnings.OrderByDescending(e => e.Date).ToList()[0];
                decimal sumEarnings = context.Earnings.Where(e => e.Date >= lastYTD.Date).ToList().Sum(e => e.Total);
                List<EarningsEntry> recentEarnings = context.Earnings.Where(e => e.Date >= lastYTD.Date).OrderByDescending(e => e.Date).ToList();
                decimal YTDMiles = 0;
                if (recentEarnings.Count > 0) { YTDMiles = recentEarnings[0].YTDMiles; }
                
                YTDTaxes = CalculateYTDTaxes(lastYTD.TotalEarned + sumEarnings, YTDMiles);


                totalCash += fulton + cash;
                totalCashQuickWithdrawal += totalCash + uber + lyft + stripe + grubhub + doordash + venmo + cashapp + fiverr + robinhood;
                totalCashQuickWithdrawalPlusCredit += totalCashQuickWithdrawal + pnc + discover + citi;
                totalCashWithdrawalPlusCredit += totalCashQuickWithdrawalPlusCredit + coinbase + etrade + firsttrade;
                totalCashQuickWithdrawalPlusDifficultCredit += totalCashQuickWithdrawalPlusCredit + dfs + paypal + drive;
                total += totalCashQuickWithdrawalPlusDifficultCredit + aidvantage + dad + irs + patax + Taxes2022 + YTDTaxes + coinbase + etrade + firsttrade;

            
                List<AccountDetailsEntry> accountDetails = context.AccountDetails.ToList();
                
                accumulatedSubscriptionPayment = accountDetails.Where(e => e.IsSubscription).Sum(e => e.PaymentAccumulated);
                accumulatedCreditPayment = accountDetails.Where(e => e.IsCredit || e.IsLoan).Sum(e => e.PaymentAccumulated + (e.PaymentAccumulated2 != null ? (decimal)e.PaymentAccumulated : 0));
                accumulatedInterest = accountDetails.Where(e => e.IsCredit || e.IsLoan).Sum(e => e.InterestAccumulated != null ? (decimal)e.InterestAccumulated : 0);
                accumulatedPlanPayment = accountDetails.Where(e => e.IsPlan).Sum(e => e.PaymentAccumulated);
                adjustedTotalCashQuickWithdrawal = totalCashQuickWithdrawal + accumulatedSubscriptionPayment + accumulatedCreditPayment + accumulatedPlanPayment;
                adjustedTotal = total + accumulatedInterest + accumulatedSubscriptionPayment;


                //Create message for changes to balances
                //context.Database.Migrate();
                //TODO: UpdateMessage For Adjust Accumulated and Calculated taxes
                FinanceEntry lastEntry = context.Finances.OrderByDescending(f => f.Date).ToList()[0];
                if (fulton != lastEntry.Fulton) message += "Fulton: " + (fulton - lastEntry.Fulton) + "\n";
                if (cash != lastEntry.Cash) message += "Cash: " + (cash - lastEntry.Cash) + "\n";
                if (pnc != lastEntry.PNC) message += "PNC: " + (pnc - lastEntry.PNC) + "\n";
                if (citi != lastEntry.Citi) message += "Citi: " + (citi - lastEntry.Citi) + "\n";
                if (discover != lastEntry.Discover) message += "Discover: " + (discover - lastEntry.Discover) + "\n";
                if (aidvantage != lastEntry.Aidvantage) message += "Aidvantage: " + (aidvantage - lastEntry.Aidvantage) + "\n";
                if (dfs != lastEntry.DFS) message += "DFS: " + (dfs - lastEntry.DFS) + "\n";
                if (dad != lastEntry.Dad) message += "Dad: " + (dad - lastEntry.Dad) + "\n";
                if (paypal != lastEntry.PayPal) message += "PayPal Credit: " + (paypal - lastEntry.PayPal) + "\n";
                if (drive != lastEntry.Drive) message += "Drive: " + (drive - lastEntry.Drive) + "\n";
                if (irs != lastEntry.IRS) message += "IRS: " + (irs - lastEntry.IRS) + "\n";
                if (patax != lastEntry.PATax) message += "PATax: " + (patax - lastEntry.PATax) + "\n";
                if (uber != lastEntry.Uber) message += "Uber: " + (uber - lastEntry.Uber) + "\n";
                if (lyft != lastEntry.Lyft) message += "Lyft: " + (lyft - lastEntry.Lyft) + "\n";
                if (stripe != lastEntry.Stripe) message += "Stripe: " + (stripe - lastEntry.Stripe) + "\n";
                if (grubhub != lastEntry.GrubHub) message += "GrubHub: " + (grubhub - lastEntry.GrubHub) + "\n";
                if (doordash != lastEntry.DoorDash) message += "DoorDash: " + (doordash - lastEntry.DoorDash) + "\n";
                if (venmo != lastEntry.Venmo) message += "Venmo: " + (venmo - lastEntry.Venmo) + "\n";
                if (cashapp != lastEntry.CashApp) message += "CashApp: " + (cashapp - lastEntry.CashApp) + "\n";
                if (fiverr != lastEntry.Fiverr) message += "Fiverr: " + (fiverr - lastEntry.Fiverr) + "\n";
                
                if (etrade != lastEntry.ETrade) message += "ETrade: " + (etrade - lastEntry.ETrade) + "\n";
                if (firsttrade != lastEntry.FirstTrade) message += "FirstTrade: " + (firsttrade - lastEntry.FirstTrade) + "\n";
                if (robinhood != lastEntry.Robinhood) message += "Robinhood: " + (robinhood - lastEntry.Robinhood) + "\n";
                if (coinbase != lastEntry.CoinBase) message += "CoinBase: " + (coinbase - lastEntry.CoinBase) + "\n";

                if (Taxes2022 != lastEntry.Taxes_2022) message += "2022 Taxes: " + (Taxes2022 - lastEntry.Taxes_2022) + "\n";
                if (YTDTaxes != lastEntry.YTDTaxes) message += "YTD Taxes: " + (YTDTaxes - lastEntry.YTDTaxes) + "\n";

                if (accumulatedSubscriptionPayment != lastEntry.Accumulated_Subscription_Payment) message += "Accum. Subscriptions: " + (accumulatedSubscriptionPayment - lastEntry.Accumulated_Subscription_Payment) + "\n";
                if (accumulatedCreditPayment != lastEntry.Accumulated_Credit_Payment) message += "Accum. Credit Payments: " + (accumulatedCreditPayment - lastEntry.Accumulated_Credit_Payment) + "\n";
                if (accumulatedInterest != lastEntry.Accumulated_Interest) message += "Accumulated Interest: " + (accumulatedInterest - lastEntry.Accumulated_Interest) + "\n";
                if (accumulatedPlanPayment != lastEntry.Accumulated_Plan_Payment) message += "Accumulated Plan: " + (accumulatedPlanPayment - lastEntry.Accumulated_Plan_Payment) + "\n";
                

                if (totalCash != lastEntry.Total_Cash) message += "Total Cash: " + (totalCash - lastEntry.Total_Cash) + "\n";
                if (totalCashQuickWithdrawal != lastEntry.Total_Cash_QuickWithdrawal) message += "Total Cash + QuickWithdrawal: " + (totalCashQuickWithdrawal - lastEntry.Total_Cash_QuickWithdrawal) + "\n";
                if (total != lastEntry.Total) message += "Total: " + (total - lastEntry.Total) + "\n";

                if (adjustedTotalCashQuickWithdrawal != lastEntry.Adjusted_Total_Cash_QuickWithdrawal) message += "Adjusted Total Cash QuickWithdrawal: " + (adjustedTotalCashQuickWithdrawal - lastEntry.Adjusted_Total_Cash_QuickWithdrawal) + "\n";
                if (adjustedTotal != lastEntry.Adjusted_Total) message += "Adjusted Total: " + (adjustedTotal - lastEntry.Adjusted_Total) + "\n";
                
                if (UPT1.Amount != lastEntry.UnpostedTransaction_One || UPT1.To != lastEntry.UPT_One_To || UPT1.From != lastEntry.UPT_One_From) message += "Unposted Transaction 1:\n";
                if (UPT1.Amount != lastEntry.UnpostedTransaction_One) message += "Amount: " + ((UPT1.Amount == null ? 0 : UPT1.Amount) - (lastEntry.UnpostedTransaction_One == null ? 0 : lastEntry.UnpostedTransaction_One)) + "\n";
                if (UPT1.From != lastEntry.UPT_One_From) message += "From: " + lastEntry.UPT_One_From + " => " + UPT1.From + "\n";
                if (UPT1.To != lastEntry.UPT_One_To) message += "To: " + lastEntry.UPT_One_To + " => " + UPT1.To + "\n";
                
                if (UPT2.Amount != lastEntry.UnpostedTransaction_Two || UPT2.To != lastEntry.UPT_Two_To || UPT2.From != lastEntry.UPT_Two_From) message += "Unposted Transaction 1:\n";
                if (UPT2.Amount != lastEntry.UnpostedTransaction_Two) message += "Amount: " + ((UPT2.Amount == null ? 0 : UPT2.Amount) - (lastEntry.UnpostedTransaction_Two == null ? 0 : lastEntry.UnpostedTransaction_Two)) + "\n";
                if (UPT2.From != lastEntry.UPT_Two_From) message += "From: " + lastEntry.UPT_Two_From + " => " + UPT2.From + "\n";
                if (UPT2.To != lastEntry.UPT_Two_To) message += "To: " + lastEntry.UPT_Two_To + " => " + UPT2.To + "\n";
               
                if (UPT3.Amount != lastEntry.UnpostedTransaction_Three || UPT3.To != lastEntry.UPT_Three_To || UPT3.From != lastEntry.UPT_Three_From) message += "Unposted Transaction 1:\n";
                if (UPT3.Amount != lastEntry.UnpostedTransaction_Three) message += "Amount: " + ((UPT3.Amount == null ? 0 : UPT3.Amount) - (lastEntry.UnpostedTransaction_Three == null ? 0 : lastEntry.UnpostedTransaction_Three)) + "\n";
                if (UPT3.From != lastEntry.UPT_Three_From) message += "From: " + lastEntry.UPT_Three_From + " => " + UPT3.From + "\n";
                if (UPT3.To != lastEntry.UPT_Three_To) message += "To: " + lastEntry.UPT_Three_To + " => " + UPT3.To + "\n";


                

            }

            AreYouSureForm areYouSureForm = new AreYouSureForm(this);
            areYouSureForm.Message = message;
            DialogResult dialogResult = areYouSureForm.ShowDialog();

            if (dialogResult == DialogResult.Yes) SaveSQL();
            //Try To Save
            //SaveSQL();


            

        }

        private void SaveSQL()
        {
            SaveResult saveResult = new SaveResult();
            DateTime now = DateTime.Now;
            using (var context = new FinanceModel())
            {

                //TODO: Add Difficult Credit Functionality
                //TODO: Add Interest Functionality


                //var newEntry = new FinanceEntry { Date = DateOnly.FromDateTime(this.monthCalendar.SelectionStart), Cash = cash, Cash_Date = now, Fulton = fulton, Fulton_Date = now, PNC = pnc, PNC_Date = now, Discover = discover, Discover_Date = now, Citi = citi, Citi_Date = now, Aidvantage = aidvantage, Aidvantage_Date = now, PayPal = paypal, PayPal_Date = now, Drive = drive, Drive_Date = now, DFS = dfs, DFS_Date = now, Dad = dad, Dad_Date = now, Uber = uber, Uber_Date = now, Lyft = lyft, Lyft_Date = now, Stripe = stripe, Stripe_Date = now, Venmo = venmo, Venmo_Date = now, CashApp = cashapp, CashApp_Date = now, IRS = irs, IRS_Date = now, GrubHub = grubhub, GrubHub_Date = now, DoorDash = doordash, DoorDash_Date = now, Fiverr = fiverr, Fivver_Date = now, Total_Cash = totalCash, Total_Cash_QuickWithdrawal = totalCashQuickWithdrawal, Total = total, UnpostedTransaction_One = UPT1.Amount, UPT_One_Date = UPT1.DateTimeofEntry, UPT_One_From = UPT1.From, UPT_One_To = UPT1.To, UnpostedTransaction_Two = UPT2.Amount, UPT_Two_Date = UPT2.DateTimeofEntry, UPT_Two_From = UPT2.From, UPT_Two_To = UPT2.To, UnpostedTransaction_Three = UPT3.Amount, UPT_Three_Date = UPT3.DateTimeofEntry, UPT_Three_From = UPT3.From, UPT_Three_To = UPT3.To };
                var newEntry = new FinanceEntry
                { Date = DateOnly.FromDateTime(this.monthCalendar.SelectionStart),
                    Cash = cash,
                    Cash_Date = now,
                    Fulton = fulton,
                    Fulton_Date = now,
                    PNC = pnc,
                    PNC_Date = now,
                    Discover = discover,
                    Discover_Date = now,
                    Citi = citi,
                    Citi_Date = now,
                    Aidvantage = aidvantage,
                    Aidvantage_Date = now,
                    PayPal = paypal,
                    PayPal_Date = now,
                    Drive = drive,
                    Drive_Date = now,
                    DFS = dfs,
                    DFS_Date = now,
                    Dad = dad,
                    Dad_Date = now,
                    Uber = uber,
                    Uber_Date = now,
                    Lyft = lyft,
                    Lyft_Date = now,
                    Stripe = stripe,
                    Stripe_Date = now,
                    Venmo = venmo,
                    Venmo_Date = now,
                    CashApp = cashapp,
                    CashApp_Date = now,
                    IRS = irs,
                    IRS_Date = now,
                    GrubHub = grubhub,
                    GrubHub_Date = now,
                    DoorDash = doordash,
                    DoorDash_Date = now,
                    Fiverr = fiverr,
                    Fiverr_Date = now,
                    Total_Cash = totalCash,
                    Total_Cash_QuickWithdrawal = totalCashQuickWithdrawal,
                    Total = total,
                    UnpostedTransaction_One = UPT1.Amount,
                    UPT_One_Date = UPT1.DateTimeofEntry,
                    UPT_One_From = UPT1.From,
                    UPT_One_To = UPT1.To,
                    UnpostedTransaction_Two = UPT2.Amount,
                    UPT_Two_Date = UPT2.DateTimeofEntry,
                    UPT_Two_From = UPT2.From,
                    UPT_Two_To = UPT2.To,
                    UnpostedTransaction_Three = UPT3.Amount,
                    UPT_Three_Date = UPT3.DateTimeofEntry,
                    UPT_Three_From = UPT3.From,
                    UPT_Three_To = UPT3.To,
                    PATax = patax,
                    PATax_Date = now,
                    Taxes_2022 = Taxes2022,
                    YTDTaxes = YTDTaxes,
                    ETrade = etrade, 
                    ETrade_Date = now, 
                    FirstTrade = firsttrade, 
                    FirstTrade_Date = now, 
                    CoinBase = coinbase, 
                    CoinBase_Date = now, 
                    Robinhood = robinhood, 
                    Robinhood_Date = now, 
                    Notes = notes, 
                    Accumulated_Plan_Payment = accumulatedPlanPayment,
                    Accumulated_Credit_Payment = accumulatedCreditPayment, 
                    Accumulated_Interest = accumulatedInterest, 
                    Accumulated_Subscription_Payment = accumulatedSubscriptionPayment, 
                    Adjusted_Total = adjustedTotal, 
                    Adjusted_Total_Cash_QuickWithdrawal = adjustedTotalCashQuickWithdrawal };

                context.Finances.Add(newEntry);

                int? entriesSaved = null;

                try
                {
                    entriesSaved = context.SaveChanges();
                    saveResult.Message = "Save successful.";
                    saveResult.Title = "Save Successful";
                    saveResult.ShowDialog();
                }
                catch (Exception ex)
                {
                    saveResult.Message = ex.InnerException.ToString();
                    saveResult.ShowDialog();
                    System.Diagnostics.Debug.WriteLine("Trevor Exception: " + ex.Message + Environment.NewLine + ex.InnerException);
                }
               
            }
        }

        private void submitButton_Click(object sender, EventArgs e)
        {
            LoadSQL();
        }

        public static bool TryParse(string str, out Decimal? dec)
        {
            decimal tmp;
            if (Decimal.TryParse(str, out tmp)) 
            {
                dec = tmp;
                return true;
            }
            else 
            {
                dec = null;
                return false; 
            }
        }

        //Enable and Disable Unposted Transaction Groups based on checkbox
        private void UPTCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox checkBox = (CheckBox)sender;
            UnpostedTransaction UPT = (UnpostedTransaction)checkBox.Tag;
            if (checkBox.Checked) { UPT.Enable(); }
            else { UPT.Disable(); }
        }

        private decimal CalculateYTDTaxes(decimal grossIncome, decimal mileage)
        {
            //For Year 2022 (using this calculation for 2023 as well until the updated forms come out)
            //On Schedule C
                //[GrossIncome => line 1 => line 5 => line 7]
                //[mileage => line 9 => line 28]
                //[Line 29(profit) = Line 7(GrossIncome) - Line 28(mileage)
                //Line 29(profit) => line 31 => (Schedule 1 Line 3) & (Schedule SE Line 2)
            //Schedule 1
                //Line 3 => Line 10 => 1040 Line 8(Profit)
            //Schedule SE
                //Line 2 => Line 3
                //Line 4a = Line 3 * 0.9235
                //Line 4a => Line 4c => Line 6
                //Line 7 = 147,000 (Maximum Amount Subject to Social Security Tax)
                //Line 10(Social Security Tax) = Line 6 * 0.124
                //Line 11 = Line 6 * 0.029
                //Line 12 = Line 10 + Line 11
                //Line 12 => Schedule 2 Line 4
                //Line 13 = Line 12 * 0.5
                //Line 13 => Schedule 1 Line 15
            //Schedule 1 Part II
                //Line 15 => Line 26 => 1040 Line 10(Self Employment Deduction)
            //Schedule 2
                //Line 4 => Line 21 => 1040 Line 23(Self Employment Tax)
            //1040
                //Line 8 (Profit) => Line 9
                //Line 10 (Self Employment Deduction)
                //Line 11 = Line 8 - Line 10 (Adjusted Gross Income)
                //Line 12 (Standard Deduction(Single)) = 12,950
                //Line 12 => Line 14
                //Line 15 (Taxable Income) = Line 11 - Line 14 (If less Than zero just zero)
                //Line 16 (Tax) = Line 15 * [Tax Table]
                //Line 16 => Line 18 => Line 22
                //Line 23 (Self Employment Tax)
                //Line 24 (Total Tax) = Line 16 + Line 23
            decimal profit = grossIncome - mileage;
            decimal SELine4a = profit * (decimal)0.9235;
            decimal SocialSecurityTax = SELine4a * (decimal)0.124;
            decimal SELine11 = SELine4a * (decimal)0.029;
            decimal SelfEmploymentTax = SocialSecurityTax + SELine11;
            decimal SelfEmploymentTaxDeductions = SelfEmploymentTax * (decimal)0.5;
            decimal adjustedGrossIncome = profit - SelfEmploymentTaxDeductions;
            decimal taxableIncome = adjustedGrossIncome - 12950 >= 0 ? adjustedGrossIncome - 12950 : 0;
            decimal tax;
            if (taxableIncome <= 10275) { tax = taxableIncome * (decimal)0.1; }
            else if (taxableIncome <= 41775 && taxableIncome > 10275) { tax = (decimal)1027.5 + (taxableIncome * (decimal)0.12); }
            else if (taxableIncome <= 89075 && taxableIncome > 41775) { tax = (decimal)4807.5 + (taxableIncome * (decimal)0.22); }
            else if (taxableIncome <= 170050 && taxableIncome > 89075) { tax = (decimal)15213.5 + (taxableIncome * (decimal)0.24); }
            else if (taxableIncome <= 215950 && taxableIncome > 170050) { tax = (decimal)34647.5 + (taxableIncome * (decimal)0.32); }
            else if (taxableIncome <= 539900 && taxableIncome > 215950) { tax = (decimal)49335.5 + (taxableIncome * (decimal)0.35); }
            else  { tax = (decimal)162718.5 + (taxableIncome * (decimal)0.37); }
            decimal federalTax = tax + SelfEmploymentTax;

            decimal paTax = profit * (decimal)0.0307;
            decimal localTax = profit * (decimal)0.0175;
            return -Math.Round(federalTax + paTax + localTax, 2);
        }   
    }
}
