﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class FultonTransactionTaggingRulesForm : Form
    {
        public FultonTransactionTaggingRulesForm()
        {
            InitializeComponent();
            using (var context = new FinanceModel())
            {

                var query = context.FultonTags.ToList();
                TagRulesListBox.DataSource = query;
                TagRulesListBox.DisplayMember = "TagName";
            }
        }

        private void AddTagRuleBtn_Click(object sender, EventArgs e)
        {
            AddOrEditTagRuleForm addTag = new AddOrEditTagRuleForm();
            addTag.Show();
        }

        private void EditTagRuleBtn_Click(object sender, EventArgs e)
        {
            if(TagRulesListBox.SelectedValue != null) 
            {
                AddOrEditTagRuleForm editTag = new AddOrEditTagRuleForm((FultonTagEntry)TagRulesListBox.SelectedValue);
                editTag.Show();
            }
            
        }

        private void DeleteTagRuleBtn_Click(object sender, EventArgs e)
        {
            if(TagRulesListBox.SelectedValue != null)
            {
                using (var context = new FinanceModel())
                {
                    context.FultonTags.Remove((FultonTagEntry)TagRulesListBox.SelectedValue);
                    context.SaveChanges();
                    TagRulesListBox.DataSource = context.FultonTags.ToList();
                }
            }
            
        }

        private void ApplyRulesBtn_Click(object sender, EventArgs e)
        {
            using (var context = new FinanceModel())
            {
                var rules = context.FultonTags.ToArray();
                var transactions = context.FultonTransactions.ToList();
                for (int index = 0; index < transactions.Count; index++)
                {
                    transactions[index].SetTags(rules);
                }
                context.SaveChanges();
                foreach(Form form in Application.OpenForms)
                {
                    if (form is ExcelForm)
                    {
                        ((ExcelForm)form).ReferenceSheet = context.FultonTransactions.ToArray();
                        ((ExcelForm)form).UpdateExcel();
                    }
                }

            }
        }
    }
}
