﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    public partial class FultonTransactionsAddForm : Form
    {
        enum FultonColumns
        {
            Date,
            Memo,
            Amount,
            Balance

        }
        public FultonTransactionsAddForm()
        {
            InitializeComponent();
        }

        private void AddBtn_Click(object sender, EventArgs e)
        {
            AddFultonTransactions();
        }

        private bool AddFultonTransactions()
        {
            //Get Text and put into a array

            string fultonString = AddFultonTransactionsTextBox.Text;
            string[] fultonSplit = fultonString.Split("\n");



            //Parse the array into a List of FultonTransactionEntries

            List<FultonTransactionEntry> parsedFultonList = new List<FultonTransactionEntry> { };
            FultonColumns fultonColumns = FultonColumns.Date;
            int j = 0;
            DateOnly datetimeTmp;
            decimal decTmp;
            for (int i = 0; i < fultonSplit.Length; i++)
            {
                fultonSplit[i] = fultonSplit[i].Trim();
                switch (fultonColumns)
                {
                    case FultonColumns.Date:
                        parsedFultonList.Add(new FultonTransactionEntry());
                        if (fultonSplit[i] == "Pending")
                        {
                            parsedFultonList[j].Date = null;
                        }
                        else if (DateOnly.TryParse(fultonSplit[i], out datetimeTmp))
                        {
                            parsedFultonList[j].Date = datetimeTmp;
                        }
                        else return false;
                        fultonColumns++;
                        break;
                    case FultonColumns.Memo:
                        parsedFultonList[j].Memo = fultonSplit[i];
                        fultonColumns++;
                        break;
                    case FultonColumns.Amount:
                        while (fultonSplit[i].Contains(","))
                        {
                            fultonSplit[i] = fultonSplit[i].Remove(fultonSplit[i].IndexOf(","), 1);
                        }
                        while (fultonSplit[i].Contains("$"))
                        {
                            fultonSplit[i] = fultonSplit[i].Remove(fultonSplit[i].IndexOf("$"), 1);
                        }
                        if (Decimal.TryParse(fultonSplit[i], out decTmp))
                        {
                            parsedFultonList[j].Amount = decTmp;
                            fultonColumns++;
                            break;
                        }
                        else return false;
                    case FultonColumns.Balance:
                        if (fultonSplit[i] == "Pending" || DateOnly.TryParse(fultonSplit[i], out datetimeTmp))
                        {
                            fultonColumns = FultonColumns.Date;
                            j++;
                            i--;
                            break;
                        }
                        while (fultonSplit[i].Contains(","))
                        {
                            fultonSplit[i] = fultonSplit[i].Remove(fultonSplit[i].IndexOf(","), 1);
                        }
                        while (fultonSplit[i].Contains("$"))
                        {
                            fultonSplit[i] = fultonSplit[i].Remove(fultonSplit[i].IndexOf("$"), 1);
                        }
                        if (Decimal.TryParse(fultonSplit[i], out decTmp))
                        {
                            parsedFultonList[j].Balance = decTmp;
                            fultonColumns = FultonColumns.Date;
                            j++;
                            break;
                        }
                        else return false;
                }
            }



            //Separate fultonlist into pending transactions and transactions that have posted

            int lastPendingIndex = parsedFultonList.FindLastIndex(e => e.Date == null);
            List<FultonTransactionEntry> pendingList = parsedFultonList.GetRange(0, lastPendingIndex + 1);
            parsedFultonList = parsedFultonList.GetRange((lastPendingIndex + 1), (parsedFultonList.Count - lastPendingIndex - 1));
            


            using (var context = new FinanceModel())
            {
                Debug.WriteLine("Change tracker, tracking {0} entities", context.ChangeTracker.Entries().Count());
                if (context.FultonTransactions.Any())
                {
                    var recordFultonList = context.FultonTransactions.OrderByDescending(e => e.Id).ToList();
                    FultonTransactionEntry latestFultonEntry = recordFultonList[0];
                    FultonTransactionEntry earliestFultonEntry = recordFultonList[recordFultonList.Count-1];
                    if (parsedFultonList[parsedFultonList.Count-1].Date > earliestFultonEntry.Date && parsedFultonList[parsedFultonList.Count-1].Date <= latestFultonEntry.Date)
                    {
                        int startIndex = 0;
                        int nextIndex = latestFultonEntry.Id + 1;
                        nextIndex = nextIndex <= 0 ? nextIndex + 1 : nextIndex; //SQLite Entity Framework doesn't like zero for Key (Why? Idk)
                        for (int recordIndex = 0; recordIndex < recordFultonList.Count; recordIndex++)
                        {
                            if (this.checkIfSame(recordFultonList[recordIndex], parsedFultonList[parsedFultonList.Count-1]))
                            {
                                startIndex = recordIndex;
                                break;
                            }
                        }
                        for (int parsedIndex = parsedFultonList.Count - 1; parsedIndex >= 0; parsedIndex--)
                        {
                            if (startIndex < 0)
                            {
                                parsedFultonList[parsedIndex].Id = nextIndex;
                                context.FultonTransactions.Add(parsedFultonList[parsedIndex]);
                                nextIndex++;
                            }
                            else
                            {
                                if (this.checkIfSame(parsedFultonList[parsedIndex], recordFultonList[startIndex]))
                                {
                                    startIndex--;
                                }
                                else
                                {
                                    return false;
                                }
                            }

                        }
                    }
                    else if (parsedFultonList[0].Date >= earliestFultonEntry.Date && parsedFultonList[0].Date < latestFultonEntry.Date)
                    {
                        int startIndex = 0;
                        int nextIndex = earliestFultonEntry.Id - 1;
                        nextIndex = nextIndex >= 0 ? nextIndex - 1 : nextIndex; //SQLite Entity Framework doesn't like zero for Key (Why? Idk)
                        for (int recordIndex = recordFultonList.Count - 1; recordIndex >= 0; recordIndex--)
                        {
                            if (this.checkIfSame(recordFultonList[recordIndex], parsedFultonList[0]))
                            {
                                startIndex = recordIndex;
                                break;
                            }
                        }
                        for (int parsedIndex = 0; parsedIndex < parsedFultonList.Count; parsedIndex++)
                        {
                            if (startIndex >= recordFultonList.Count)
                            {
                                parsedFultonList[parsedIndex].Id = nextIndex;
                                context.FultonTransactions.Add(parsedFultonList[parsedIndex]);
                                nextIndex--;
                            }
                            else
                            {
                                if (this.checkIfSame(parsedFultonList[parsedIndex], recordFultonList[startIndex]))
                                {
                                    startIndex++;
                                }
                                else
                                {
                                    return false;
                                }
                            }

                        }
                    }
                }
                else
                {
                    int nextIndex = 1;
                    for (int i = parsedFultonList.Count - 1; i >= 0; i--)
                    {
                        parsedFultonList[i].Id = nextIndex;
                        context.FultonTransactions.Add(parsedFultonList[i]);
                        nextIndex++;
                    }
                }
                SaveResult failedSave = new SaveResult();
                try
                {
                    context.SaveChanges();
                    failedSave.Message = "Save successful.";
                    failedSave.Title = "Save Successful";
                    failedSave.ShowDialog();
                    return true;
                }
                catch (Exception ex)
                {
                    failedSave.Message = ex.InnerException.ToString();
                    failedSave.ShowDialog();
                    Debug.WriteLine("Trevor Exception: " + ex.Message + Environment.NewLine + ex.InnerException);
                    return false;
                }
            }
        }
        internal bool checkIfSame(FultonTransactionEntry entry1, FultonTransactionEntry entry2)
        {
            if (entry1.Date != entry2.Date) return false;
            if (entry1.Memo != entry2.Memo) return false;
            if (entry1.Amount != entry2.Amount) return false;
            if (entry1.Balance != entry2.Balance) return false;
            return true;
        }
    }
}
