﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    internal interface IAccount
    {
        public LambdaExpression LambdaGetColumn { get; set; }
        public decimal YesterdaysAmount { get; set; }
        public decimal TodaysAmount { get; set; }
        public TextBox AmountTextBox { get; set; }
        public enum AccountTypes
        {
            Cash,
            QuickWithdrawal,
            Credit,
            Loan
        }
        public AccountTypes AccountType { get; set; }
        public bool TryParse(string stringToParse, out decimal number);
        public string AlertChanges();
        public decimal GetColumn(FinanceEntry entry);
    }
}
