﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

#nullable disable

namespace FinanceTrackerApplication.Migrations
{
    /// <inheritdoc />
    public partial class InitialCreate : Migration
    {
        /// <inheritdoc />
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.CreateTable(
                name: "Finances",
                columns: table => new
                {
                    Date = table.Column<DateOnly>(type: "TEXT", nullable: false),
                    Cash = table.Column<decimal>(type: "TEXT", nullable: true),
                    CashInWallet = table.Column<decimal>(type: "TEXT", nullable: true),
                    CashInCar = table.Column<decimal>(type: "TEXT", nullable: true),
                    CashAtHome = table.Column<decimal>(type: "TEXT", nullable: true),
                    CashDate = table.Column<DateTime>(name: "Cash_Date", type: "TEXT", nullable: true),
                    Fulton = table.Column<decimal>(type: "TEXT", nullable: true),
                    FultonDate = table.Column<DateTime>(name: "Fulton_Date", type: "TEXT", nullable: true),
                    PNC = table.Column<decimal>(type: "TEXT", nullable: true),
                    PNCDate = table.Column<DateTime>(name: "PNC_Date", type: "TEXT", nullable: true),
                    Citi = table.Column<decimal>(type: "TEXT", nullable: true),
                    CitiDate = table.Column<DateTime>(name: "Citi_Date", type: "TEXT", nullable: true),
                    Discover = table.Column<decimal>(type: "TEXT", nullable: true),
                    DiscoverDate = table.Column<DateTime>(name: "Discover_Date", type: "TEXT", nullable: true),
                    Aidvantage = table.Column<decimal>(type: "TEXT", nullable: true),
                    AidvantageDate = table.Column<DateTime>(name: "Aidvantage_Date", type: "TEXT", nullable: true),
                    DFS = table.Column<decimal>(type: "TEXT", nullable: true),
                    DFSDate = table.Column<DateTime>(name: "DFS_Date", type: "TEXT", nullable: true),
                    PayPal = table.Column<decimal>(type: "TEXT", nullable: true),
                    PayPalDate = table.Column<DateTime>(name: "PayPal_Date", type: "TEXT", nullable: true),
                    Dad = table.Column<decimal>(type: "TEXT", nullable: true),
                    DadDate = table.Column<DateTime>(name: "Dad_Date", type: "TEXT", nullable: true),
                    Drive = table.Column<decimal>(type: "TEXT", nullable: true),
                    DriveDate = table.Column<DateTime>(name: "Drive_Date", type: "TEXT", nullable: true),
                    Uber = table.Column<decimal>(type: "TEXT", nullable: true),
                    UberDate = table.Column<DateTime>(name: "Uber_Date", type: "TEXT", nullable: true),
                    Lyft = table.Column<decimal>(type: "TEXT", nullable: true),
                    LyftDate = table.Column<DateTime>(name: "Lyft_Date", type: "TEXT", nullable: true),
                    Stripe = table.Column<decimal>(type: "TEXT", nullable: true),
                    StripeDate = table.Column<DateTime>(name: "Stripe_Date", type: "TEXT", nullable: true),
                    GrubHub = table.Column<decimal>(type: "TEXT", nullable: true),
                    GrubHubDate = table.Column<DateTime>(name: "GrubHub_Date", type: "TEXT", nullable: true),
                    DoorDash = table.Column<decimal>(type: "TEXT", nullable: true),
                    DoorDashDate = table.Column<DateTime>(name: "DoorDash_Date", type: "TEXT", nullable: true),
                    Venmo = table.Column<decimal>(type: "TEXT", nullable: true),
                    VenmoDate = table.Column<DateTime>(name: "Venmo_Date", type: "TEXT", nullable: true),
                    CashApp = table.Column<decimal>(type: "TEXT", nullable: true),
                    CashAppDate = table.Column<DateTime>(name: "CashApp_Date", type: "TEXT", nullable: true),
                    Fiverr = table.Column<decimal>(type: "TEXT", nullable: true),
                    FivverDate = table.Column<DateTime>(name: "Fivver_Date", type: "TEXT", nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_Finances", x => x.Date);
                });
        }

        /// <inheritdoc />
        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropTable(
                name: "Finances");
        }
    }
}
