﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

#nullable disable

namespace FinanceTrackerApplication.Migrations
{
    /// <inheritdoc />
    public partial class AddedAccountDetails : Migration
    {
        /// <inheritdoc />
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.CreateTable(
                name: "AccountDetails",
                columns: table => new
                {
                    Name = table.Column<string>(type: "TEXT", nullable: false),
                    PaymentAccumulated = table.Column<decimal>(type: "TEXT", nullable: false),
                    InterestAccumulated = table.Column<decimal>(type: "TEXT", nullable: true),
                    InterestRate = table.Column<decimal>(type: "TEXT", nullable: true),
                    LastStatementAmount = table.Column<decimal>(type: "TEXT", nullable: true),
                    MonthlyPayment = table.Column<decimal>(type: "TEXT", nullable: false),
                    NextPaymentDate = table.Column<DateOnly>(type: "TEXT", nullable: false),
                    LastPaymentDate = table.Column<DateOnly>(type: "TEXT", nullable: false),
                    MonthlyPayment2 = table.Column<decimal>(type: "TEXT", nullable: true),
                    NextPaymentDate2 = table.Column<DateOnly>(type: "TEXT", nullable: true),
                    LastPaymentDate2 = table.Column<DateOnly>(type: "TEXT", nullable: true),
                    LastStatementDate = table.Column<DateOnly>(type: "TEXT", nullable: true),
                    IsCredit = table.Column<bool>(type: "INTEGER", nullable: false),
                    IsLoan = table.Column<bool>(type: "INTEGER", nullable: false),
                    IsSubscription = table.Column<bool>(type: "INTEGER", nullable: false),
                    AbsoluteMinimumPayment = table.Column<decimal>(type: "TEXT", nullable: true),
                    MinimumPercent = table.Column<decimal>(type: "TEXT", nullable: true),
                    LastUpdated = table.Column<DateOnly>(type: "TEXT", nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_AccountDetails", x => x.Name);
                });
        }

        /// <inheritdoc />
        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropTable(
                name: "AccountDetails");
        }
    }
}
