﻿using Microsoft.EntityFrameworkCore.Migrations;

#nullable disable

namespace FinanceTrackerApplication.Migrations
{
    /// <inheritdoc />
    public partial class AddedAccumulatedInterestPaymentColumns : Migration
    {
        /// <inheritdoc />
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal_PlusCredit",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 70)
                .OldAnnotation("Relational:ColumnOrder", 66);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 68)
                .OldAnnotation("Relational:ColumnOrder", 65);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 67)
                .OldAnnotation("Relational:ColumnOrder", 64);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 72)
                .OldAnnotation("Relational:ColumnOrder", 67);

            migrationBuilder.AlterColumn<string>(
                name: "Notes",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(string),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 73)
                .OldAnnotation("Relational:ColumnOrder", 68);

            migrationBuilder.AddColumn<decimal>(
                name: "Accumulated_Credit_Payment",
                table: "Finances",
                type: "TEXT",
                nullable: true)
                .Annotation("Relational:ColumnOrder", 65);

            migrationBuilder.AddColumn<decimal>(
                name: "Accumulated_Interest",
                table: "Finances",
                type: "TEXT",
                nullable: true)
                .Annotation("Relational:ColumnOrder", 66);

            migrationBuilder.AddColumn<decimal>(
                name: "Accumulated_Subscription_Payment",
                table: "Finances",
                type: "TEXT",
                nullable: true)
                .Annotation("Relational:ColumnOrder", 64);

            migrationBuilder.AddColumn<decimal>(
                name: "Adjusted_Total",
                table: "Finances",
                type: "TEXT",
                nullable: true)
                .Annotation("Relational:ColumnOrder", 71);

            migrationBuilder.AddColumn<decimal>(
                name: "Adjusted_Total_Cash_QuickWithdrawal",
                table: "Finances",
                type: "TEXT",
                nullable: true)
                .Annotation("Relational:ColumnOrder", 69);
        }

        /// <inheritdoc />
        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropColumn(
                name: "Accumulated_Credit_Payment",
                table: "Finances");

            migrationBuilder.DropColumn(
                name: "Accumulated_Interest",
                table: "Finances");

            migrationBuilder.DropColumn(
                name: "Accumulated_Subscription_Payment",
                table: "Finances");

            migrationBuilder.DropColumn(
                name: "Adjusted_Total",
                table: "Finances");

            migrationBuilder.DropColumn(
                name: "Adjusted_Total_Cash_QuickWithdrawal",
                table: "Finances");

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal_PlusCredit",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 66)
                .OldAnnotation("Relational:ColumnOrder", 70);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 65)
                .OldAnnotation("Relational:ColumnOrder", 68);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 64)
                .OldAnnotation("Relational:ColumnOrder", 67);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 67)
                .OldAnnotation("Relational:ColumnOrder", 72);

            migrationBuilder.AlterColumn<string>(
                name: "Notes",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(string),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 68)
                .OldAnnotation("Relational:ColumnOrder", 73);
        }
    }
}
