﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

#nullable disable

namespace FinanceTrackerApplication.Migrations
{
    /// <inheritdoc />
    public partial class AddedEarningsTables : Migration
    {
        /// <inheritdoc />
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.CreateTable(
                name: "Earnings",
                columns: table => new
                {
                    Date = table.Column<DateOnly>(type: "TEXT", nullable: false),
                    Uber = table.Column<decimal>(type: "TEXT", nullable: false),
                    Lyft = table.Column<decimal>(type: "TEXT", nullable: false),
                    Stripe = table.Column<decimal>(type: "TEXT", nullable: false),
                    GrubHub = table.Column<decimal>(type: "TEXT", nullable: false),
                    DoorDash = table.Column<decimal>(type: "TEXT", nullable: false),
                    Venmo = table.Column<decimal>(type: "TEXT", nullable: false),
                    CashApp = table.Column<decimal>(type: "TEXT", nullable: false),
                    Fiverr = table.Column<decimal>(type: "TEXT", nullable: false),
                    Total = table.Column<decimal>(type: "TEXT", nullable: false),
                    YTDMiles = table.Column<decimal>(type: "TEXT", nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_Earnings", x => x.Date);
                });

            migrationBuilder.CreateTable(
                name: "YTDEarnings",
                columns: table => new
                {
                    Date = table.Column<DateOnly>(type: "TEXT", nullable: false),
                    Uber = table.Column<decimal>(type: "TEXT", nullable: false),
                    Lyft = table.Column<decimal>(type: "TEXT", nullable: false),
                    Stripe = table.Column<decimal>(type: "TEXT", nullable: false),
                    GrubHub = table.Column<decimal>(type: "TEXT", nullable: false),
                    DoorDash = table.Column<decimal>(type: "TEXT", nullable: false),
                    Venmo = table.Column<decimal>(type: "TEXT", nullable: false),
                    CashApp = table.Column<decimal>(type: "TEXT", nullable: false),
                    Fiverr = table.Column<decimal>(type: "TEXT", nullable: false),
                    Total = table.Column<decimal>(type: "TEXT", nullable: false),
                    Miles = table.Column<decimal>(type: "TEXT", nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_YTDEarnings", x => x.Date);
                });
        }

        /// <inheritdoc />
        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropTable(
                name: "Earnings");

            migrationBuilder.DropTable(
                name: "YTDEarnings");
        }
    }
}
