﻿using Microsoft.EntityFrameworkCore.Migrations;

#nullable disable

namespace FinanceTrackerApplication.Migrations
{
    /// <inheritdoc />
    public partial class AddedPlanAccount : Migration
    {
        /// <inheritdoc />
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal_PlusCredit",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 73)
                .OldAnnotation("Relational:ColumnOrder", 72);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 71)
                .OldAnnotation("Relational:ColumnOrder", 70);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 70)
                .OldAnnotation("Relational:ColumnOrder", 69);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 75)
                .OldAnnotation("Relational:ColumnOrder", 74);

            migrationBuilder.AlterColumn<string>(
                name: "Notes",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(string),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 76)
                .OldAnnotation("Relational:ColumnOrder", 75);

            migrationBuilder.AlterColumn<decimal>(
                name: "Adjusted_Total_Cash_QuickWithdrawal",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 72)
                .OldAnnotation("Relational:ColumnOrder", 71);

            migrationBuilder.AlterColumn<decimal>(
                name: "Adjusted_Total",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 74)
                .OldAnnotation("Relational:ColumnOrder", 73);

            migrationBuilder.AlterColumn<decimal>(
                name: "Accumulated_Subscription_Payment",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 67)
                .OldAnnotation("Relational:ColumnOrder", 66);

            migrationBuilder.AlterColumn<decimal>(
                name: "Accumulated_Interest",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 69)
                .OldAnnotation("Relational:ColumnOrder", 68);

            migrationBuilder.AlterColumn<decimal>(
                name: "Accumulated_Credit_Payment",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 68)
                .OldAnnotation("Relational:ColumnOrder", 67);

            migrationBuilder.AddColumn<decimal>(
                name: "Accumulated_Plan_Payment",
                table: "Finances",
                type: "TEXT",
                nullable: true)
                .Annotation("Relational:ColumnOrder", 66);

            migrationBuilder.AddColumn<bool>(
                name: "IsPlan",
                table: "AccountDetails",
                type: "INTEGER",
                nullable: false,
                defaultValue: false);
        }

        /// <inheritdoc />
        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropColumn(
                name: "Accumulated_Plan_Payment",
                table: "Finances");

            migrationBuilder.DropColumn(
                name: "IsPlan",
                table: "AccountDetails");

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal_PlusCredit",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 72)
                .OldAnnotation("Relational:ColumnOrder", 73);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash_QuickWithdrawal",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 70)
                .OldAnnotation("Relational:ColumnOrder", 71);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total_Cash",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 69)
                .OldAnnotation("Relational:ColumnOrder", 70);

            migrationBuilder.AlterColumn<decimal>(
                name: "Total",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 74)
                .OldAnnotation("Relational:ColumnOrder", 75);

            migrationBuilder.AlterColumn<string>(
                name: "Notes",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(string),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 75)
                .OldAnnotation("Relational:ColumnOrder", 76);

            migrationBuilder.AlterColumn<decimal>(
                name: "Adjusted_Total_Cash_QuickWithdrawal",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 71)
                .OldAnnotation("Relational:ColumnOrder", 72);

            migrationBuilder.AlterColumn<decimal>(
                name: "Adjusted_Total",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 73)
                .OldAnnotation("Relational:ColumnOrder", 74);

            migrationBuilder.AlterColumn<decimal>(
                name: "Accumulated_Subscription_Payment",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 66)
                .OldAnnotation("Relational:ColumnOrder", 67);

            migrationBuilder.AlterColumn<decimal>(
                name: "Accumulated_Interest",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 68)
                .OldAnnotation("Relational:ColumnOrder", 69);

            migrationBuilder.AlterColumn<decimal>(
                name: "Accumulated_Credit_Payment",
                table: "Finances",
                type: "TEXT",
                nullable: true,
                oldClrType: typeof(decimal),
                oldType: "TEXT",
                oldNullable: true)
                .Annotation("Relational:ColumnOrder", 67)
                .OldAnnotation("Relational:ColumnOrder", 68);
        }
    }
}
