﻿using Microsoft.EntityFrameworkCore.Migrations;

#nullable disable

namespace FinanceTrackerApplication.Migrations
{
    /// <inheritdoc />
    public partial class AddedTaggingRules : Migration
    {
        /// <inheritdoc />
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.CreateTable(
                name: "FultonTags",
                columns: table => new
                {
                    TagName = table.Column<string>(type: "TEXT", nullable: false),
                    Memo_Contains = table.Column<string>(type: "TEXT", nullable: true),
                    IsStore = table.Column<string>(type: "TEXT", nullable: true),
                    IsMajorTag = table.Column<string>(type: "TEXT", nullable: true),
                    Debit_Greater_Than = table.Column<decimal>(type: "TEXT", nullable: true),
                    Debit_Equal_To = table.Column<decimal>(type: "TEXT", nullable: true),
                    Debit_Less_Than = table.Column<decimal>(type: "TEXT", nullable: true),
                    Debit_Not_Equal_To = table.Column<decimal>(type: "TEXT", nullable: true),
                    SetStore = table.Column<string>(type: "TEXT", nullable: true),
                    SetMajorTag = table.Column<string>(type: "TEXT", nullable: true),
                    SetMinorTags = table.Column<string>(type: "TEXT", nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_FultonTags", x => x.TagName);
                });
        }

        /// <inheritdoc />
        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropTable(
                name: "FultonTags");
        }
    }
}
