﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Diagnostics;

namespace FinanceTrackerApplication
{
    public partial class AccountDetailsEntry
    {
        [Key]
        public string Name { get; set; }
        public decimal? InterestAccumulated { get; set; }
        public decimal? InterestRate { get; set; }
        public decimal? LastStatementAmount { get; set; }
        public decimal PaymentAccumulated { get; set; }
        public DateOnly NextPaymentDate { get; set; }
        public DateOnly LastPaymentDate { get; set; }
        public decimal? PaymentAccumulated2 { get; set; }
        public DateOnly? NextPaymentDate2 { get; set; }
        public DateOnly? LastPaymentDate2 { get; set; }
        public DateOnly? LastStatementDate { get; set; }
        public bool IsCredit { get; set; }
        public bool IsLoan { get; set; }
        public bool IsSubscription { get; set; }
        public bool IsPlan { get; set; }
        public decimal MonthlyPayment { get; set; }
        public decimal? AbsoluteMinimumPayment { get; set; }
        public decimal? MinimumPercent { get; set; }
        public bool? IncludeInterestInMinimumPercent { get; set; }
        public DateOnly LastUpdated { get; set; }
    }
    public partial class AccountDetailsEntry
    {
        public decimal CalculateFullPayment()
        {
            if (IsSubscription) { return MonthlyPayment; }
            if (IsCredit || IsLoan)
            {

                decimal tmpPayment;
                if (MonthlyPayment < AbsoluteMinimumPayment)
                {
                    tmpPayment = (decimal)AbsoluteMinimumPayment;
                }
                else tmpPayment = MonthlyPayment;
                if ((bool)IncludeInterestInMinimumPercent)
                {
                    decimal minPay_PercPlusInt = (decimal)-((LastStatementAmount * MinimumPercent / 100) + (LastStatementAmount * ((decimal)Math.Pow((double)1 + (double)(InterestRate / 36500)!, DateTime.DaysInMonth(((DateOnly)LastStatementDate!).Year, ((DateOnly)LastStatementDate).Month)) - 1)))!;
                    if (tmpPayment < minPay_PercPlusInt) tmpPayment = -minPay_PercPlusInt;
                }
                else if (tmpPayment < -LastStatementAmount * MinimumPercent / 100) tmpPayment = (decimal)LastStatementAmount * (decimal)MinimumPercent / 100;
                if (NextPaymentDate2 != null)
                {
                    tmpPayment /= 2;
                }
                tmpPayment = Math.Round(tmpPayment, 2);
                return tmpPayment;
            }
            return -9999999999;
        }
        public static bool UpdateAccounts()
        {
            SaveResult saveResult = new SaveResult();
            using (var context = new FinanceModel())
            {
                var query = context.AccountDetails.ToList();
                for (int i = 0; i < query.Count; i++)
                {
                    AccountDetailsEntry entry = query[i];
                    if (!(entry.IsLoan || entry.IsCredit || entry.IsSubscription || entry.IsPlan)) { return false; }
                    if (entry.IsSubscription)
                    {
                        entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                        entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                        entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                    }
                    else if (entry.IsCredit || entry.IsLoan)
                    {

                        //Calculate From User Entries
                        //InterestAccum = LastStatement * (((1+(APR/365))^#DaysPassed)-1)
                        entry.InterestAccumulated = (decimal?)entry.LastStatementAmount * ((decimal?)Math.Pow((1 + ((double)entry.InterestRate! / 36500)), DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastStatementDate!).DayNumber) - 1);

                        //Calculate Payment Accumulated
                        if (entry.MonthlyPayment < entry.AbsoluteMinimumPayment)
                        {
                            entry.PaymentAccumulated = (decimal)entry.AbsoluteMinimumPayment;
                        }
                        else entry.PaymentAccumulated = entry.MonthlyPayment;
                        if ((bool)entry.IncludeInterestInMinimumPercent!)
                        {
                            decimal minPay_PercPlusInt = (decimal)-((entry.LastStatementAmount * entry.MinimumPercent / 100) + (entry.LastStatementAmount * ((decimal)Math.Pow((double)1 + (double)(entry.InterestRate / 36500), DateTime.DaysInMonth(((DateOnly)entry.LastStatementDate).Year, ((DateOnly)entry.LastStatementDate).Month)) - 1)))!;
                            if (entry.PaymentAccumulated < minPay_PercPlusInt) entry.PaymentAccumulated = minPay_PercPlusInt;
                        }
                        else if (entry.PaymentAccumulated < -entry.LastStatementAmount * entry.MinimumPercent / 100) entry.PaymentAccumulated = (decimal)-entry.LastStatementAmount! * (decimal)entry.MinimumPercent! / 100;
                        entry.PaymentAccumulated *= -1;
                        if (entry.NextPaymentDate2 != null)
                        {
                            entry.PaymentAccumulated2 = entry.PaymentAccumulated;
                        }

                        entry.PaymentAccumulated = entry.PaymentAccumulated * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.AddMonths(-1).Year, DateTime.Now.AddMonths(-1).Month);
                        if (entry.NextPaymentDate2 != null)
                        {
                            entry.PaymentAccumulated /= 2;
                            entry.PaymentAccumulated2 = entry.PaymentAccumulated2 * (DateOnly.FromDateTime(DateTime.Now).DayNumber - ((DateOnly)entry.LastPaymentDate2!).DayNumber) / (decimal)DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.AddMonths(-1).Month);
                            entry.PaymentAccumulated2 /= 2;
                            entry.PaymentAccumulated2 = Math.Round((decimal)entry.PaymentAccumulated2!, 2);
                        }

                        entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                        entry.InterestAccumulated = Math.Round((decimal)entry.InterestAccumulated!, 2);
                        entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                    }
                    else if (entry.IsPlan)
                    {
                        entry.PaymentAccumulated = -entry.MonthlyPayment * (DateOnly.FromDateTime(DateTime.Now).DayNumber - entry.LastPaymentDate.DayNumber) / (entry.NextPaymentDate.DayNumber - entry.LastPaymentDate.DayNumber);
                        entry.LastUpdated = DateOnly.FromDateTime(DateTime.Now);
                        entry.PaymentAccumulated = Math.Round(entry.PaymentAccumulated, 2);
                    }
                }
                try
                {
                    context.SaveChanges();
                    saveResult.Message = "Save successful.";
                    saveResult.Title = "Save Successful";
                    saveResult.ShowDialog();
                }
                catch (Exception ex)
                {
                    saveResult.Message = ex.InnerException.ToString();
                    saveResult.ShowDialog();
                    Debug.WriteLine("Trevor Exception: " + ex.Message + Environment.NewLine + ex.InnerException);
                }

                return true;
            }
        }
    }
}
