﻿using Microsoft.EntityFrameworkCore;
//using Microsoft.EntityFrameworkCore.Relational; 
using System.ComponentModel.DataAnnotations;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;

namespace FinanceTrackerApplication
{
    internal class FinanceModel : DbContext
    {
        public DbSet<FinanceEntry> Finances { get; set; }
        public DbSet<FultonTransactionEntry> FultonTransactions { get; set; }
        public DbSet<AccountDetailsEntry> AccountDetails { get; set; }
        public DbSet<YTDEarningsEntry> YTDEarnings { get; set; }
        public DbSet<EarningsEntry> Earnings { get; set; }
        public DbSet<FultonTagEntry> FultonTags { get; set; }

        public string DbPath { get; }

        public FinanceModel()
        {
            var folder = Environment.SpecialFolder.LocalApplicationData;
            var localPath = Environment.GetFolderPath(folder);
            var appPath = System.IO.Path.Join(localPath, "FinanceTracker");
            System.IO.Directory.CreateDirectory(appPath);
            DbPath = System.IO.Path.Join(appPath, "FinanceModel.db");
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder) => optionsBuilder.UseSqlite($"Data Source={DbPath}");


        //protected override void OnModelCreating(ModelBuilder modelBuilder)
        //{
        //    modelBuilder.Entity<FultonTagEntry>().Has;
        //}
        protected override void ConfigureConventions(ModelConfigurationBuilder builder)
        {
            builder.Properties<string[]>().HaveConversion <StringArrayValueConverter>();
            
        }
    }
    internal class StringArrayValueConverter : ValueConverter<string[], string>
    {
        public StringArrayValueConverter() : base(
            t => string.Join(",", t),
            t => t.Split(",", StringSplitOptions.None).ToArray()) 
        { }
    }

}
