﻿using Microsoft.EntityFrameworkCore.ChangeTracking;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel.DataAnnotations;

namespace FinanceTrackerApplication
{
    public class FultonTagEntry : IComparable<FultonTagEntry>
    {
        [Key]
        public string TagName { get; set; }
        public string[]? Memo_Contains { get; set; }
        public string?[]? IsStore { get; set; }
        public string?[]? IsMajorTag { get; set; }
        public decimal? Less_Than_Amount { get; set; }
        public decimal? Equal_To_Amount { get; set; }
        public decimal? Greater_Than_Amount { get; set; }
        public decimal? Not_Equal_To_Amount { get; set; }
        public string? SetStore { get; set; }
        public string? SetMajorTag { get; set; }
        public string[]? SetMinorTags { get; set; }

        public int CompareTo(FultonTagEntry? e)
        {
            return GiveValue(this) - GiveValue(e);
        }
        private int GiveValue(FultonTagEntry? e)
        {
            if (e == null) return 3;
            if (e.SetStore != null)
            {
                return 0;
            }
            if (e.SetMajorTag != null)
            { return 1; }
            return 2;
        }


    }
    public class TagValueComparer : IComparer<FultonTagEntry>
    {
        public int Compare(FultonTagEntry x, FultonTagEntry y)
        {
            return GiveValue(x) - GiveValue(y);
        }
        public int GiveValue(FultonTagEntry e)
        {
            if(e.SetStore != null)
            {
                return 0;
            }
            if(e.SetMajorTag != null) 
            { return 1; }
            return 2;
        }
    }
    

}
