﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel.DataAnnotations;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore.Metadata.Internal;
using Microsoft.EntityFrameworkCore.Query.Internal;

namespace FinanceTrackerApplication
{
    internal partial class FultonTransactionEntry
    {
        [Key]
        public int Id { get; set; }
        public DateOnly? Date { get; set; }
        public string Memo { get; set; }
        public decimal Amount { get; set; }
        public decimal? Balance { get; set; }
        public string? Store { get; set; }
        public string? Major_Tag { get; set; }
        public string[]? Minor_Tags { get; set; }
        internal void AddStore(string identifier, string store)
        {
            if (this.Memo.ToLower().Contains(identifier.ToLower())) { this.Store = store; }
        }
        internal void AddTag(Func<FultonTransactionEntry, bool> expression, string tag)
        {
            if (expression(this))
            {
                this.Major_Tag = tag;
            }
        }
        internal void AddTag(Func<FultonTransactionEntry, string?> expression)
        {
            string? temp = expression(this);
            if (temp != null) { return; }
            else this.Major_Tag = temp;
        }
        internal void Rules()
        {
            AddStore("SHEETZ", "Sheetz");
            AddTag(e =>
            {
                if (e.Store == "Sheetz")
                {
                    if (e.Amount > 20)
                    {
                        return "Miscellaneous";
                    }
                    return "Gas";
                }
                return null;
            });
        }
        internal bool MemoContains(string str)
        {
            if (str == "*") return true;
            return this.Memo.Contains(str);
           
        }
        internal bool MemoContains(string[] strings)
        {
            if (strings.Contains("*")) return true;
            foreach(string str in strings)
            {
                if (this.Memo.Contains(str)) return true;
            }
            return false;
        }
        internal bool IsStore(string? store)
        {
            if (store == "*") return true;
            return this.Store == store ;
        }
        internal bool IsStore(string?[] stores)
        {
            if (stores.Contains("*")) return true;
            return stores.Contains(this.Store);
        }
        internal bool IsMajorTag(string? tag)
        {
            if (tag == "*") return true;
            return this.Major_Tag == tag;
        }
        internal bool IsMajorTag(string?[] tags)
        {
            if (tags.Contains("*")) return true;
            return tags.Contains(this.Major_Tag);
        }
        internal bool IsMinorTag(string? tag)
        {
            if (tag == "*") return true;
            if (tag == null)
            {
                if (this.Minor_Tags == null) return true;
                return false;
            }
            else if (this.Minor_Tags == null) return false;
            
            return this.Minor_Tags.Contains(tag);
        }
        internal bool IsMinorTag(string?[] tags)
        {
            if (tags.Contains("*")) return true;
            foreach (string? tag in tags)
            {
                if(tag == null)
                {
                    if (this.Minor_Tags == null) return true;
                    else continue;
                }
                else if(this.Minor_Tags == null) continue;
                if(this.Minor_Tags.Contains(tag)) return true;
            }
            return false;
        }
        internal void SetTags(FultonTagEntry[] tags)
        {
            tags = tags.Order().ToArray();
            foreach (FultonTagEntry tag in tags)
            {
                if(tag.Memo_Contains == null || this.MemoContains(tag.Memo_Contains))
                {
                    if (tag.IsStore == null || this.IsStore(tag.IsStore))
                    {
                        if(tag.IsMajorTag == null || this.IsMajorTag(tag.IsMajorTag))
                        {
                            if(tag.Less_Than_Amount == null || (tag.Less_Than_Amount < this.Amount && this.Amount < 0))
                            {
                                if(tag.Equal_To_Amount == null || (tag.Equal_To_Amount == this.Amount && this.Amount < 0))
                                {
                                    if(tag.Greater_Than_Amount == null || (tag.Greater_Than_Amount > this.Amount && this.Amount < 0))
                                    {
                                        if(tag.Not_Equal_To_Amount == null || (tag.Not_Equal_To_Amount != this.Amount && this.Amount < 0))
                                        {
                                            ApplyTags(tag);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        private void ApplyTags(FultonTagEntry tag)
        {
            if(tag.SetStore != null) { this.Store = tag.SetStore; }
            if(tag.SetMajorTag != null) { this.Major_Tag = tag.SetMajorTag; }
            if(tag.SetMinorTags != null)
            {
                if(this.Minor_Tags == null)
                {
                    this.Minor_Tags = tag.SetMinorTags;
                }
                else
                {
                    List<string> minorTagsToAdd = this.Minor_Tags.ToList();
                    foreach (string minortag in tag.SetMinorTags)
                    {
                        if (!minorTagsToAdd.Contains(minortag))
                        {
                            minorTagsToAdd.Add(minortag);
                        }
                    }
                    this.Minor_Tags = this.Minor_Tags.Concat(minorTagsToAdd).ToArray();
                }
            }
        }
        

        

    }

    
}
