﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FinanceTrackerApplication
{
    internal class PaymentInThePast
    {
        public enum TypeOfPast
        {
            Statement,
            FirstPayment,
            SecondPayment
        }
        public AccountDetailsEntry AccountDetails { get; set; }
        public TypeOfPast Type { get; set; }
        public CheckBox PaidCheckBox { get; set; }
        public Label NameLbl { get; set; }
        public Label AmountLbl { get; set; }
        public Label DateLbl { get; set; }
        internal PaymentInThePast(AccountDetailsEntry details, TypeOfPast type) 
        {
            AccountDetails = details;
            Type = type;
            PaidCheckBox = new CheckBox();
            NameLbl = new Label();
            AmountLbl = new Label();
            DateLbl = new Label();

            PaidCheckBox.Checked = false;
            PaidCheckBox.Text = string.Empty;
            NameLbl.Text =  details.Name;
            if (details.IsSubscription)
            {
                AmountLbl.Text = details.MonthlyPayment.ToString("C");
                DateLbl.Text = details.NextPaymentDate.ToString();
            }
            if (details.IsLoan || details.IsCredit)
            {
                if (Type == TypeOfPast.Statement)
                {
                    AmountLbl.Text = ((decimal)details.LastStatementAmount!).ToString("C");
                    DateLbl.Text = ((DateOnly)details.LastStatementDate!).AddMonths(1).ToString();
                }
                if (Type == TypeOfPast.FirstPayment)
                {
                    AmountLbl.Text = details.CalculateFullPayment().ToString("C");
                    DateLbl.Text = ((DateOnly)details.NextPaymentDate!).ToString();
                }
                if (Type == TypeOfPast.SecondPayment)
                {
                    AmountLbl.Text = details.CalculateFullPayment().ToString("C");
                    DateLbl.Text = ((DateOnly)details.NextPaymentDate2!).ToString();
                }
            }

            
        }
        public void AddControls(Control control)
        {
            control.Controls.Add(PaidCheckBox);
            control.Controls.Add(NameLbl);
            control.Controls.Add(AmountLbl);
            control.Controls.Add(DateLbl);
        }
    }
}
