﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using OxyPlot;
using OxyPlot.Axes;
using OxyPlot.Series;
using OxyPlot.Annotations;
using Google.Cloud.Storage.V1;
using static Microsoft.EntityFrameworkCore.DbLoggerCategory;
using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using Microsoft.Data.Sqlite;

namespace FinanceTrackerApplication
{
    public partial class StartForm : Form
    {
        public StartForm()
        {
            InitializeComponent();
            MakePlot();
            using (var context = new FinanceModel())
            {
                DateOnly today = DateOnly.FromDateTime(DateTime.Now);
                DateOnly lastMonth = DateOnly.FromDateTime(DateTime.Now).AddMonths(-1);
                var query1 = context.AccountDetails.Where(e => e.NextPaymentDate <= today).ToList();
                var query2 = context.AccountDetails.Where(e => e.NextPaymentDate2 != null && e.NextPaymentDate2 <= today).ToList();
                var query3 = context.AccountDetails.Where(e => e.LastStatementDate != null && e.LastStatementDate <= lastMonth).ToList();
                PaymentsInThePastTable.RowCount = query1.Count + query2.Count + query3.Count;
                PaymentsInThePastTable.Height = PaymentsInThePastTable.RowCount * 30;
                TableLayoutRowStyleCollection styles = PaymentsInThePastTable.RowStyles;
                List<PaymentInThePast> pastPayList = new List<PaymentInThePast>();
                foreach (RowStyle style in styles)
                {
                    style.SizeType = SizeType.Absolute;
                    style.Height = 30;
                }
                int count = 0;
                foreach (var entry in query1)
                {
                    pastPayList.Add(new PaymentInThePast(entry, PaymentInThePast.TypeOfPast.FirstPayment));
                    pastPayList[count].AddControls(PaymentsInThePastTable);
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].PaidCheckBox, 
                        new TableLayoutPanelCellPosition(0, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].NameLbl, 
                        new TableLayoutPanelCellPosition(1, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].AmountLbl, 
                        new TableLayoutPanelCellPosition(2, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].DateLbl, 
                        new TableLayoutPanelCellPosition(3, count));

                    count++;
                }
                foreach (var entry in query2)
                {
                    pastPayList.Add(new PaymentInThePast(entry, PaymentInThePast.TypeOfPast.SecondPayment));
                    pastPayList[count].AddControls(PaymentsInThePastTable);
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].PaidCheckBox, 
                        new TableLayoutPanelCellPosition(0, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].NameLbl, 
                        new TableLayoutPanelCellPosition(1, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].AmountLbl, 
                        new TableLayoutPanelCellPosition(2, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].DateLbl, 
                        new TableLayoutPanelCellPosition(3, count));

                    count++;
                }
                foreach (var entry in query3)
                {
                    pastPayList.Add(new PaymentInThePast(entry, PaymentInThePast.TypeOfPast.Statement));
                    pastPayList[count].AddControls(PaymentsInThePastTable);
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].PaidCheckBox, 
                        new TableLayoutPanelCellPosition(0, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].NameLbl, 
                        new TableLayoutPanelCellPosition(1, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].AmountLbl, 
                        new TableLayoutPanelCellPosition(2, count));
                    PaymentsInThePastTable.SetCellPosition(pastPayList[pastPayList.Count - 1].DateLbl, 
                        new TableLayoutPanelCellPosition(3, count));

                    count++;
                }
            }
            
            
        }

        private void AddNewEntryButton_Click(object sender, EventArgs e)
        {
            FinancialTrackerForm form = new FinancialTrackerForm();
            form.Show();
        }
        /// <summary>
        /// Makes OxyPlot
        /// </summary>
        /// <remarks>
        /// Make sure to yadadadada
        /// </remarks>
        private void MakePlot()
        {
            using (var context = new FinanceModel()) 
            {
                int numDays = (int)DaysInThePastNumeric.Value;
                DateOnly startDate = DateOnly.FromDateTime(DateTime.Now).AddDays(-numDays);
                //var query = context.Finances.Where(elem => elem.Date > DateOnly.FromDateTime(DateTime.Now).AddDays(-numDays)).OrderBy(elem => elem.Date).ToList();
                var query = context.Finances.Where(elem => elem.Date >= startDate).OrderBy(elem => elem.Date).ToList();
                
                var dates = query.Select(entry => entry.Date).ToList();
                var values = query.Select(entry => entry.Adjusted_Total).ToList();
                if (IsCashQuickWithdrawalRadio.Checked)
                {
                    if (IsAdjustedRadio.Checked) { values = query.Select(entry => entry.Adjusted_Total_Cash_QuickWithdrawal).ToList(); }
                    else { values = query.Select(entry => entry.Total_Cash_QuickWithdrawal).ToList(); }
                }
                else
                {
                    if (IsAdjustedRadio.Checked) { values = query.Select(entry => entry.Adjusted_Total).ToList(); }
                    else { values = query.Select(entry => entry.Total).ToList(); }
                }

                PlotModel progressModel = new PlotModel { Title = "Progress" };
                
                var graphLine = new LineSeries()
                {
                    Title = "Cash Quick Withdrawal",
                    StrokeThickness = 10,
                    MarkerSize = 2,
                    MarkerType = MarkerType.Circle

                };
                for (int i = 0; i < values.Count; i++)
                {
                    if (values[i] != null) 
                    { 
                        graphLine.Points.Add(new DataPoint(DateTimeAxis.ToDouble(dates[i].ToDateTime(TimeOnly.MinValue)), (double)values[i]!));
                        if (query[i].Notes != null) 
                        {
                            progressModel.Annotations.Add(new ArrowAnnotation {
                                EndPoint = new DataPoint(
                                    DateTimeAxis.ToDouble(dates[i].ToDateTime(TimeOnly.MinValue)),
                                    (double)values[i]!),
                                ArrowDirection = new ScreenVector(30, 30),
                                Text = query[i].Notes,
                                ToolTip = "This is a ToolTip" }) ; 
                        }
                    }
                    
                }


                
                progressModel.Series.Add(graphLine);
                progressModel.Axes.Add(new DateTimeAxis() { Position = AxisPosition.Bottom, Minimum = DateTimeAxis.ToDouble(startDate.ToDateTime(TimeOnly.MinValue)), Maximum = DateTimeAxis.ToDouble(DateTime.Now), StringFormat = "M/d" });
                plotView1.Model = progressModel;
                //plotView1.Model = Rotations();
            }
            
        }

        private void AddFultonTransactionsBtn_Click(object sender, EventArgs e)
        {
            FultonTransactionsAddForm fultonAdd = new FultonTransactionsAddForm();
            fultonAdd.Show();
        }

        private void EditAccountDetailsBtn_Click(object sender, EventArgs e)
        {
            AccountDetailsForm accountDetailsForm = new AccountDetailsForm();
            accountDetailsForm.Show();
        }

        private void EarningsBtn_Click(object sender, EventArgs e)
        {
            EarningsForm earnings = new();
            earnings.Show();
        }

        private void GraphRadios_CheckedChange(object sender, EventArgs e)
        {
            MakePlot();
        }

        private void DaysInThePastNumeric_ValueChanged(object sender, EventArgs e)
        {
            MakePlot();
        }

        private void UploadBtn_Click(object sender, EventArgs e)
        {
            string bucketname = "sql-finances";
            string objectname = "FinanceModel.db";

            var folder = Environment.SpecialFolder.LocalApplicationData;
            var localPath = Environment.GetFolderPath(folder);
            var appPath = Path.Join(localPath, "FinanceTracker");
            Directory.CreateDirectory(appPath);
            string filelocation = Path.Join(appPath, "FinanceModel.db");

            var storage = StorageClient.Create();
            SqliteConnection.ClearAllPools();

            try
            {
                using var fileStream = File.OpenRead(filelocation);
                storage.UploadObject(bucketname, objectname, null, fileStream);
                SaveResult message = new();
                message.Title = "Upload successful";
                message.Message = "Upload succesful!";
                message.Show();
            }
            catch (Exception ex)
            {
                SaveResult failedUpload = new();
                failedUpload.Title = "Upload Failed";
                failedUpload.Message = ex.Message;
                failedUpload.Show();
            }
           
            

            
        }

        private void ClearPoolsBtn_Click(object sender, EventArgs e)
        {
            SqliteConnection.ClearAllPools();
        }
        
        public static PlotModel ArrowAnnotation()
        {
            var model = new PlotModel { Title = "ArrowAnnotations" };
            model.Axes.Add(new LinearAxis { Position = AxisPosition.Bottom, Minimum = -40, Maximum = 60 });
            model.Axes.Add(new LinearAxis { Position = AxisPosition.Left, Minimum = -10, Maximum = 10 });
            model.Annotations.Add(
                new ArrowAnnotation
                {
                    StartPoint = new DataPoint(8, 4),
                    EndPoint = new DataPoint(0, 0),
                    Color = OxyColors.Green,
                    Text = "StartPoint and EndPoint"
                });

            model.Annotations.Add(
                new ArrowAnnotation
                {
                    ArrowDirection = new ScreenVector(30, 70),
                    EndPoint = new DataPoint(40, -3),
                    Color = OxyColors.Blue,
                    Text = "ArrowDirection and EndPoint"
                });

            model.Annotations.Add(
                new ArrowAnnotation
                {
                    ArrowDirection = new ScreenVector(30, -70),
                    EndPoint = new DataPoint(10, -3),
                    HeadLength = 14,
                    HeadWidth = 6,
                    Veeness = 4,
                    Color = OxyColors.Red,
                    Text = "HeadLength = 20, HeadWidth = 10, Veeness = 4"
                });

            return model;
        }

        
        public static PlotModel Rotations()
        {
            var model = new PlotModel { Title = "ArrowAnnotation Rotations" };
            model.Axes.Add(
                new LinearAxis
                {
                    Position = AxisPosition.Bottom,
                    Minimum = -5,
                    Maximum = 45,
                    MajorGridlineStyle = LineStyle.Solid
                });

            model.Axes.Add(
                new LinearAxis
                {
                    Position = AxisPosition.Left,
                    StartPosition = 1,
                    EndPosition = 0,
                    Minimum = -1,
                    Maximum = 8,
                    MajorGridlineStyle = LineStyle.Solid
                });

            for (var i = 0; i < 360; i += 5)
            {
                var rad = i / 360d * Math.PI * 2;
                model.Annotations.Add(
                    new ArrowAnnotation
                    {
                        EndPoint = new DataPoint(i % 45, i / 45),
                        Text = $"{i}°",
                        ArrowDirection = new ScreenVector(Math.Cos(rad), Math.Sin(rad)) * 25,
                        HeadLength = 5
                    });
            }

            return model;
        }
        public static PlotModel ToolTips()
        {
            var model = new PlotModel { Title = "Tool tips" };
            model.Axes.Add(new LinearAxis { Position = AxisPosition.Bottom });
            model.Axes.Add(new LinearAxis { Position = AxisPosition.Left });
            model.Annotations.Add(new LineAnnotation { Slope = 0.1, Intercept = 1, Text = "LineAnnotation", ToolTip = "This is a tool tip for the LineAnnotation" });
            model.Annotations.Add(new RectangleAnnotation { MinimumX = 20, MaximumX = 70, MinimumY = 10, MaximumY = 40, TextRotation = 10, Text = "RectangleAnnotation", ToolTip = "This is a tooltip for the RectangleAnnotation", Fill = OxyColor.FromAColor(99, OxyColors.Blue), Stroke = OxyColors.Black, StrokeThickness = 2 });
            model.Annotations.Add(new EllipseAnnotation { X = 20, Y = 60, Width = 20, Height = 15, Text = "EllipseAnnotation", ToolTip = "This is a tool tip for the EllipseAnnotation", TextRotation = 10, Fill = OxyColor.FromAColor(99, OxyColors.Green), Stroke = OxyColors.Black, StrokeThickness = 2 });
            model.Annotations.Add(new PointAnnotation { X = 50, Y = 50, Text = "P1", ToolTip = "This is a tool tip for the PointAnnotation" });
            model.Annotations.Add(new ArrowAnnotation { StartPoint = new DataPoint(8, 4), EndPoint = new DataPoint(0, 0), Color = OxyColors.Green, Text = "ArrowAnnotation", ToolTip = "This is a tool tip for the ArrowAnnotation" });
            model.Annotations.Add(new TextAnnotation { TextPosition = new DataPoint(60, 60), Text = "TextAnnotation", ToolTip = "This is a tool tip for the TextAnnotation" });
            return model;
        }

        private void ViewFultonBtn_Click(object sender, EventArgs e)
        {
            using(var context = new FinanceModel())
            {
                FultonTransactionEntry[] query = context.FultonTransactions.OrderBy(e => e.Memo).ToArray();

                ExcelForm fulton = new ExcelForm(query);
                fulton.Show();
            }
          
        }


    }
}
