﻿using Microsoft.EntityFrameworkCore;
using Microsoft.SqlServer.Management.Smo;
using Microsoft.VisualBasic.ApplicationServices;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Security.Policy;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static System.Runtime.InteropServices.JavaScript.JSType;

#nullable enable

namespace FinanceTrackerApplication
{
    internal class UnpostedTransaction
    {
        private FinancialTrackerForm prntForm;
        private CheckBox checkBox;
        private TextBox amountBox;
        private ComboBox fromBox;
        private ComboBox toBox;
        private RadioButton fromButton;
        private RadioButton toButton;
        private decimal? amount;
        public decimal? Amount
        {
            get
            {
                return amount;
            }
            set
            {
                amount = value;
            }
        }
        public DateTime? DateTimeofEntry { get; set; }
        public string? From { get; set; }
        public string? To { get; set; }
        public string? Unposted { get; set; }
        public UnpostedTransaction(FinancialTrackerForm prntForm, CheckBox checkBox, TextBox amountBox, ComboBox fromBox, ComboBox toBox, RadioButton fromButton, RadioButton toButton)
        {
            this.prntForm = prntForm;
            this.checkBox = checkBox;
            this.amountBox = amountBox;
            this.fromBox = fromBox;
            this.toBox = toBox;
            this.fromButton = fromButton;
            this.toButton = toButton;
            this.checkBox.Tag = this;
            Amount = null;
            DateTimeofEntry = null;
            From = null;
            To = null;
            Unposted = null;
            this.Disable();
            this.fromBox.Items.AddRange(FinancialTrackerForm.fromList);
            this.toBox.Items.AddRange(FinancialTrackerForm.toList);

        }

        public void Enable()
        {
            amountBox.Enabled = true;
            fromBox.Enabled = true;
            toBox.Enabled = true;
            fromButton.Enabled = true;
            toButton.Enabled = true;

        }
        public void Disable()
        {
            amountBox.Enabled = false;
            fromBox.Enabled = false;
            toBox.Enabled = false;
            toButton.Enabled = false;
            fromButton.Enabled = false;
        }
        public bool TryParse(DateTime now)
        {
            bool parseSuccessful = false;
            if (checkBox.Checked)
            {
                if (FinancialTrackerForm.TryParse(amountBox.Text, out amount))
                {

                    From = fromBox.Text;
                    To = toBox.Text;


                    if (From != "" && To != "")
                    {
                        parseSuccessful = true;
                        DateTimeofEntry = now;
                        if (fromButton.Checked)
                        {
                            Amount = -Amount;
                            Unposted = From;
                        }
                        else if (toButton.Checked) Unposted = To;
                        else parseSuccessful = false;




                    }

                    if (Array.Exists(FinancialTrackerForm.cashList, element => element == Unposted)) prntForm.totalCash += Amount.Value;
                    if (Array.Exists(FinancialTrackerForm.quickWithdrawalList, element => element == Unposted)) prntForm.totalCashQuickWithdrawal += Amount.Value;
                    if (Array.Exists(FinancialTrackerForm.creditList, element => element == Unposted)) prntForm.totalCashQuickWithdrawalPlusCredit += Amount.Value;
                    if (Array.Exists(FinancialTrackerForm.difficultCreditList, element => element == Unposted)) prntForm.totalCashQuickWithdrawalPlusDifficultCredit += Amount.Value;
                    if (Array.Exists(FinancialTrackerForm.loanList, element => element == Unposted)) prntForm.total += Amount.Value;

                }

            }
            else parseSuccessful = true;
            return parseSuccessful;
        }
        public static void Initialize(UnpostedTransaction UPT1, UnpostedTransaction UPT2, UnpostedTransaction UPT3) 
        {
            using (var context = new FinanceModel())
            {

                DateOnly yesterday = DateOnly.FromDateTime(DateTime.Now.AddDays(-1));
                context.Database.Migrate();
                List<FinanceEntry> yesterdayEntry = context.Finances.Where(f => f.Date == yesterday).ToList();
                if (yesterdayEntry.Count == 1)
                {
                    if (yesterdayEntry[0].UnpostedTransaction_One.HasValue)
                    {
                        UPT1.checkBox.Checked = true;
                        UPT1.fromBox.Text = yesterdayEntry[0].UPT_One_From;
                        UPT1.toBox.Text = yesterdayEntry[0].UPT_One_To;
                        UPT1.amountBox.Text = Math.Abs((decimal)yesterdayEntry[0].UnpostedTransaction_One!).ToString();

                        if (yesterdayEntry[0].UnpostedTransaction_One > 0) 
                            UPT1.toButton.Checked = true;
                        else UPT1.fromButton.Checked = true;
                    }
                    if (yesterdayEntry[0].UnpostedTransaction_Two.HasValue)
                    {
                        UPT2.checkBox.Checked = true;
                        UPT2.fromBox.Text = yesterdayEntry[0].UPT_Two_From;
                        UPT2.toBox.Text = yesterdayEntry[0].UPT_Two_To;
                        UPT2.amountBox.Text = Math.Abs((decimal)yesterdayEntry[0].UnpostedTransaction_Two!).ToString();

                        if (yesterdayEntry[0].UnpostedTransaction_Two > 0)
                            UPT2.toButton.Checked = true;
                        else UPT2.fromButton.Checked = true;
                    }
                    if (yesterdayEntry[0].UnpostedTransaction_Three.HasValue)
                    {
                        UPT3.checkBox.Checked = true;
                        UPT3.fromBox.Text = yesterdayEntry[0].UPT_Three_From;
                        UPT3.toBox.Text = yesterdayEntry[0].UPT_Three_To;
                        UPT3.amountBox.Text = Math.Abs((decimal)yesterdayEntry[0].UnpostedTransaction_Three!).ToString();

                        if (yesterdayEntry[0].UnpostedTransaction_Three > 0)
                            UPT3.toButton.Checked = true;
                        else UPT3.fromButton.Checked = true;
                    }
                    
                }
            }
        }
    }
}
