﻿using FinanceTrackerMobile.Services;
using FinanceTrackerMobile.Views;
using System;
using Xamarin.Forms;
using Xamarin.Forms.Xaml;
using Google.Cloud.Storage.V1;
using System.IO;
using System.Reflection;
using Xamarin.Essentials;
using System.Diagnostics;

namespace FinanceTrackerMobile
{
    public partial class App : Application
    {

        public App()
        {
            InitializeComponent();

            DependencyService.Register<MockDataStore>();
            MainPage = new AppShell();
        }

        protected override void OnStart()
        {
            var cacheFile = Path.Combine(FileSystem.CacheDirectory, "application_default_credentials.json");
            if (File.Exists(cacheFile))
                File.Delete(cacheFile);
            using (var resource = Assembly.GetExecutingAssembly().GetManifestResourceStream("FinanceTrackerMobile.application_default_credentials.json"))
            using (var file = new FileStream(cacheFile, FileMode.Create, FileAccess.Write))
            {
                resource.CopyTo(file);
            }

            Environment.SetEnvironmentVariable("GOOGLE_APPLICATION_CREDENTIALS", cacheFile);
            string bucketname = "sql-finances";
            string objectname = "FinanceModel.db";

            var folder = Environment.SpecialFolder.LocalApplicationData;
            var localPath = Environment.GetFolderPath(folder);
            var appPath = Path.Join(localPath, "FinanceTracker");
            Directory.CreateDirectory(appPath);
            string filelocation = Path.Join(appPath, "FinanceModel.db");

            var storage = StorageClient.Create();
            using var fileStream = File.OpenWrite(filelocation);
            storage.DownloadObject(bucketname, objectname, fileStream);
            //try
            //{
            //    storage.DownloadObject(bucketname, objectname, fileStream);

            //    //Some risky client call that will call parallell code / async /TPL or in some way cause an AggregateException 

            //}
            //catch (AggregateException err)
            //{
            //    foreach (var errInner in err.InnerExceptions)
            //    {
            //        Debug.WriteLine(errInner); //this will call ToString() on the inner execption and get you message, stacktrace and you could perhaps drill down further into the inner exception of it if necessary 
            //    }
            //}

        }

        protected override void OnSleep()
        {
        }

        protected override void OnResume()
        {
        }
    }
}
