﻿using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FinanceTrackerApplication
{
    internal class FinanceEntry
    {
        // HACK: Column Orders 
        [Key]
        [Column(Order = 0)]
        public DateOnly Date { get; set; }
        [Column(Order = 1)]
        public decimal? Cash { get; set; }
        [Column(Order = 2)]
        public decimal? CashInWallet { get; set; }
        [Column(Order = 3)]
        public decimal? CashInCar { get; set; }
        [Column(Order = 4)]
        public decimal? CashAtHome { get; set; }
        [Column(Order = 5)]
        public DateTime? Cash_Date { get; set; }
        [Column(Order = 6)]
        public decimal? Fulton { get; set; }
        [Column(Order = 7)]
        public DateTime? Fulton_Date { get; set; }
        [Column(Order = 8)]
        public decimal? Uber { get; set; }
        [Column(Order = 9)]
        public DateTime? Uber_Date { get; set; }
        [Column(Order = 10)]
        public decimal? Lyft { get; set; }
        [Column(Order = 11)]
        public DateTime? Lyft_Date { get; set; }
        [Column(Order = 12)]
        public decimal? Stripe { get; set; }
        [Column(Order = 13)]
        public DateTime? Stripe_Date { get; set; }
        [Column(Order = 14)]
        public decimal? GrubHub { get; set; }
        [Column(Order = 15)]
        public DateTime? GrubHub_Date { get; set; }
        [Column(Order = 16)]
        public decimal? DoorDash { get; set; }
        [Column(Order = 17)]
        public DateTime? DoorDash_Date { get; set; }
        [Column(Order = 18)]
        public decimal? Venmo { get; set; }
        [Column(Order = 19)]
        public DateTime? Venmo_Date { get; set; }
        [Column(Order = 20)]
        public decimal? CashApp { get; set; }
        [Column(Order = 21)]
        public DateTime? CashApp_Date { get; set; }
        [Column(Order = 22)]
        public decimal? Fiverr { get; set; }
        [Column(Order = 23)]
        public DateTime? Fiverr_Date { get; set; }
        [Column(Order = 24)]
        public decimal? Robinhood { get; set; }
        [Column(Order = 25)]
        public DateTime? Robinhood_Date { get; set; }
        [Column(Order = 26)]
        public decimal? ETrade { get; set; }
        [Column(Order = 27)]
        public DateTime? ETrade_Date { get; set; }
        [Column(Order = 28)]
        public decimal? CoinBase { get; set; }
        [Column(Order = 29)]
        public DateTime? CoinBase_Date { get; set; }
        [Column(Order = 30)]
        public decimal? FirstTrade { get; set; }
        [Column(Order = 31)]
        public DateTime? FirstTrade_Date { get; set; }
        [Column(Order = 32)]
        public decimal? PNC { get; set; }
        [Column(Order = 33)]
        public DateTime? PNC_Date { get; set; }
        [Column(Order = 34)]
        public decimal? Citi { get; set; }
        [Column(Order = 35)]
        public DateTime? Citi_Date { get; set; }
        [Column(Order = 36)]
        public decimal? Discover { get; set; }
        [Column(Order = 37)]
        public DateTime? Discover_Date { get; set; }
        [Column(Order = 38)]
        public decimal? PayPal { get; set; }
        [Column(Order = 39)]
        public DateTime? PayPal_Date { get; set; }
        [Column(Order = 40)]
        public decimal? DFS { get; set; }
        [Column(Order = 41)]
        public DateTime? DFS_Date { get; set; }
        [Column(Order = 42)]
        public decimal? Drive { get; set; }
        [Column(Order = 43)]
        public DateTime? Drive_Date { get; set; }
        [Column(Order = 44)]
        public decimal? Aidvantage { get; set; }
        [Column(Order = 45)]
        public DateTime? Aidvantage_Date { get; set; }
        [Column(Order = 46)]
        public decimal? Dad { get; set; }
        [Column(Order = 47)]
        public DateTime? Dad_Date { get; set; }
        [Column(Order = 48)]
        public decimal? IRS { get; set; }
        [Column(Order = 49)]
        public DateTime? IRS_Date { get; set; }
        [Column(Order = 50)]
        public decimal? PATax { get; set; }
        [Column(Order = 51)]
        public DateTime? PATax_Date { get; set; }
        [Column(Order = 52)]
        public decimal? Taxes_2022 { get; set; }
        [Column(Order = 53)]
        public decimal? YTDTaxes { get; set; }
        [Column(Order = 54)]
        public decimal? UnpostedTransaction_One { get; set; }
        [Column(Order = 55)]
        public string? UPT_One_From { get; set; }
        [Column(Order = 56)]
        public string? UPT_One_To { get; set; }
        [Column(Order = 57)]
        public DateTime? UPT_One_Date { get; set; }
        [Column(Order = 58)]
        public decimal? UnpostedTransaction_Two { get; set; }
        [Column(Order = 59)]
        public string? UPT_Two_From { get; set; }
        [Column(Order = 60)]
        public string? UPT_Two_To { get; set; }
        [Column(Order = 61)]
        public DateTime? UPT_Two_Date { get; set; }
        [Column(Order = 62)]
        public decimal? UnpostedTransaction_Three { get; set; }
        [Column(Order = 63)]
        public string? UPT_Three_From { get; set; }
        [Column(Order = 64)]
        public string? UPT_Three_To { get; set; }
        [Column(Order = 65)]
        public DateTime? UPT_Three_Date { get; set; }
        [Column(Order = 66)]
        public decimal? Accumulated_Plan_Payment { get; set; }
        [Column(Order = 67)]
        public decimal? Accumulated_Subscription_Payment { get; set; }
        [Column(Order = 68)]
        public decimal? Accumulated_Credit_Payment { get; set; }
        [Column(Order = 69)]
        public decimal? Accumulated_Interest { get; set; }
        [Column(Order = 70)]
        public decimal? Total_Cash { get; set; }
        [Column(Order = 71)]
        public decimal? Total_Cash_QuickWithdrawal { get; set; }
        [Column(Order = 72)]
        public decimal? Adjusted_Total_Cash_QuickWithdrawal { get; set; }
        [Column(Order = 73)]
        public decimal? Total_Cash_QuickWithdrawal_PlusCredit { get; set; }
        [Column(Order = 74)]
        public decimal? Adjusted_Total { get; set; }
        [Column(Order = 75)]
        public decimal? Total { get; set; }
        [Column(Order = 76)]
        public string? Notes { get; set; }
        public static void ConfigureProperties(ModelBuilder modelBuilder)
        {
            EntityTypeBuilder<FinanceEntry> entityBuilder = modelBuilder.Entity<FinanceEntry>();
            entityBuilder
                .Property(e => e.Date)
                .HasConversion<FinanceModel.DateOnlyConverter>()
                .HasColumnType("TEXT");

        }
    }
}