﻿using Microsoft.EntityFrameworkCore;
//using Microsoft.EntityFrameworkCore.Relational; 
using System.ComponentModel.DataAnnotations;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace FinanceTrackerApplication
{
    internal class FinanceModel : DbContext
    {
        public DbSet<FinanceEntry> Finances { get; set;}
        //public DbSet<FultonTransactionEntry> FultonTransactions { get; set;}
        //public DbSet<AccountDetailsEntry> AccountDetails { get; set;}
        //public DbSet<YTDEarningsEntry> YTDEarnings { get; set;}
        //public DbSet<EarningsEntry> Earnings { get; set;}

        public string DbPath { get; }

        public FinanceModel()
        {
            var folder = Environment.SpecialFolder.LocalApplicationData;
            var localPath = Environment.GetFolderPath(folder);
            var appPath = System.IO.Path.Join(localPath, "FinanceTracker");
            System.IO.Directory.CreateDirectory(appPath);
            DbPath = System.IO.Path.Join(appPath, "FinanceModel.db");
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder) => optionsBuilder.UseSqlite($"Data Source={DbPath}");

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            DateOnlyConverter converter = new DateOnlyConverter();
            modelBuilder
                .Entity<FinanceEntry>()
                .Property(e => e.Date)
                .HasConversion(converter);

            //modelBuilder
            //    .Entity<AccountDetailsEntry>()
            //    .Property(e => e.NextPaymentDate)
            //    .HasConversion<DateOnlyConverter>()
            //    .HasColumnType("TEXT");
            //modelBuilder
            //    .Entity<AccountDetailsEntry>()
            //    .Property(e => e.LastPaymentDate)
            //    .HasConversion<DateOnlyConverter>()
            //    .HasColumnType("TEXT");

            //EntityTypeBuilder<AccountDetailsEntry> entityBuilder = modelBuilder.Entity<AccountDetailsEntry>();
            //entityBuilder
            //    .Property(e => e.NextPaymentDate)
            //    .HasConversion<FinanceModel.DateOnlyConverter>()
            //    .HasColumnType("TEXT");
            //entityBuilder
            //    .Property(e => e.LastPaymentDate)
            //    .HasConversion<FinanceModel.DateOnlyConverter>()
            //    .HasColumnType("TEXT");
            //entityBuilder
            //    .Property(e => e.NextPaymentDate2)
            //    .HasConversion<FinanceModel.DateOnlyConverter>()
            //    .HasColumnType("TEXT");
            //entityBuilder
            //    .Property(e => e.LastPaymentDate2)
            //    .HasConversion<FinanceModel.DateOnlyConverter>()
            //    .HasColumnType("TEXT");
            //entityBuilder
            //    .Property(e => e.LastStatementDate)
            //    .HasConversion<FinanceModel.DateOnlyConverter>()
            //    .HasColumnType("TEXT");
            //entityBuilder
            //    .Property(e => e.LastUpdated)
            //    .HasConversion<FinanceModel.DateOnlyConverter>()
            //    .HasColumnType("TEXT");
            //AccountDetailsEntry.ConfigureProperties(modelBuilder);
            //EarningsEntry.ConfigureProperties(modelBuilder);
            //FinanceEntry.ConfigureProperties(modelBuilder);
            //FultonTransactionEntry.ConfigureProperties(modelBuilder);
            //YTDEarningsEntry.ConfigureProperties(modelBuilder);

        }
        //public class DateOnlyConverter : ValueConverter<DateOnly, DateTime>
        //{
        //    /// <summary>
        //    /// Creates a new instance of this converter.
        //    /// </summary>
        //    public DateOnlyConverter() : base(
        //            d => d.ToDateTime(TimeOnly.MinValue),
        //            d => DateOnly.FromDateTime(d))
        //    { }
        //}
        public class DateOnlyConverter : ValueConverter<DateOnly, string>
        {
            /// <summary>
            /// Creates a new instance of this converter.
            /// </summary>
            public DateOnlyConverter() : base(
                    d => d.ToString("yyyy-MM-dd"),
                    d => DateOnly.ParseExact(d, "yyyy-MM-dd")
                    )
            { }
        }


    
    }

}
