﻿using System;
using System.IO;
using System.Windows.Input;
using Xamarin.Essentials;
using Xamarin.Forms;

namespace FinanceTrackerMobile.ViewModels
{
    public class AboutViewModel : BaseViewModel
    {
        public string filelocation { get; set; }

        public AboutViewModel()
        {
            Title = "About";
            OpenWebCommand = new Command(async () => await Browser.OpenAsync("https://aka.ms/xamarin-quickstart"));
            string bucketname = "sql-finances";
            string objectname = "FinanceModel.db";

            var folder = Environment.SpecialFolder.LocalApplicationData;
            var localPath = Environment.GetFolderPath(folder);
            var appPath = Path.Join(localPath, "FinanceTracker");

            filelocation = Path.Join(appPath, "FinanceModel.db");
            
        }

        public ICommand OpenWebCommand { get; }
    }
}