﻿using Android.Hardware.Camera2;
using FinanceTrackerApplication;
using OxyPlot;
using OxyPlot.Axes;
using OxyPlot.Series;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;
using Xamarin.Forms;

namespace FinanceTrackerMobile.ViewModels
{
    internal class GraphViewModel : BaseViewModel
    {
        public ICommand RadioUpdate { get; }
        public ICommand EditorUpdate { get; }
        public bool IsTotalChecked { get; set; }
        public static RadioButton Total { get; set; }
        public RadioButton CashQuickWithdrawal { get; set; }
        public static Editor NumDays { get; set; }
        public static PlotModel Model { get; set; }
        public static string Test { get; set; }
        public GraphViewModel() 
        {
            Title = "Progress";
            IsTotalChecked = true;
            UpdateGraph();
            RadioUpdate = new Command(UpdateGraph);
            EditorUpdate = new Command(UpdateGraph);
                
                
                
            

        }
        public void RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            UpdateGraph();
        }
        public void Editor_TextChanged(object sender, EventArgs e)
        {
            UpdateGraph();
        }
        public static void UpdateGraph()
        {
            using (var context = new FinanceModel())
            {
                int numDays = 7;

                if (!int.TryParse(NumDays.Text, out numDays)) return;

                DateOnly startDate = DateOnly.FromDateTime(DateTime.Now).AddDays(-numDays);
                var query = context.Finances.Where(elem => elem.Date >= startDate).OrderBy(elem => elem.Date).ToList();

                var dates = query.Select(entry => entry.Date).ToList();
                var values = query.Select(entry => entry.Adjusted_Total).ToList();
                if (Total.IsChecked)
                {
                    values = query.Select(entry => entry.Adjusted_Total_Cash_QuickWithdrawal).ToList();

                }
                else
                {
                    values = query.Select(entry => entry.Adjusted_Total).ToList();

                }


                PlotModel progressModel = new PlotModel { Title = "Progress" };

                var cashQuickWithdrawalLine = new LineSeries()
                {
                    Title = "Cash Quick Withdrawal",
                    StrokeThickness = 10,
                    MarkerSize = 2,
                    MarkerType = MarkerType.Circle

                };
                for (int i = 0; i < values.Count; i++)
                {
                    if (values[i] != null) { cashQuickWithdrawalLine.Points.Add(new DataPoint(DateTimeAxis.ToDouble(dates[i].ToDateTime(TimeOnly.MinValue)), (double)values[i]!)); }

                }

                Test = dates[0].ToString();

                progressModel.Series.Add(cashQuickWithdrawalLine);
                progressModel.Axes.Add(new DateTimeAxis() { Position = AxisPosition.Bottom, Minimum = DateTimeAxis.ToDouble(startDate.ToDateTime(TimeOnly.MinValue)), Maximum = DateTimeAxis.ToDouble(DateTime.Now), StringFormat = "M/d" });

                Model = progressModel;
            }
            
        }
        public class EditorUpdateBehavior : Behavior<Editor>
        {
            protected override void OnAttachedTo(Editor editor)
            {
                editor.TextChanged += OnEntryTextChanged;
                base.OnAttachedTo(editor);
            }

            protected override void OnDetachingFrom(Editor editor)
            {
                editor.TextChanged -= OnEntryTextChanged;
                base.OnDetachingFrom(editor);
            }

            void OnEntryTextChanged(object sender, TextChangedEventArgs args)
            {
                
                double result;
                bool isValid = double.TryParse(args.NewTextValue, out result);
                if (isValid) UpdateGraph();
            }
        }
        public class RadioUpdateBehavior : Behavior<RadioButton>
        {
            protected override void OnAttachedTo(RadioButton radio)
            {
                radio.CheckedChanged += OnEntryTextChanged;
                base.OnAttachedTo(radio);
            }

            protected override void OnDetachingFrom(RadioButton editor)
            {
                editor.CheckedChanged -= OnEntryTextChanged;
                base.OnDetachingFrom(editor);
            }

            void OnEntryTextChanged(object sender, CheckedChangedEventArgs args)
            {

                UpdateGraph();
            }
        }
    }

}
