﻿using FinanceTrackerApplication;
using OxyPlot.Axes;
using OxyPlot.Series;
using OxyPlot;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Xamarin.Forms;
using Xamarin.Forms.Xaml;
using static System.Net.Mime.MediaTypeNames;

namespace FinanceTrackerMobile.Views
{
	[XamlCompilation(XamlCompilationOptions.Compile)]
	public partial class GraphPage2 : ContentPage
	{
        public PlotModel Model { get; set; }
        //public Editor NumDays { get; set; }
        //public RadioButton Total { get; set; }
		public GraphPage2 ()
		{
			InitializeComponent ();
            UpdateGraph();
		}

        private void RadioButton_CheckedChanged(object sender, CheckedChangedEventArgs e)
        {
            UpdateGraph();
        }

        private void Editor_TextChanged(object sender, TextChangedEventArgs e)
        {
            UpdateGraph();
        }
        public async void UpdateGraph()
        {
            using (var context = new FinanceModel())
            {
                int numDays = 7;

                if (!int.TryParse(NumDays.Text, out numDays)) return;

                DateOnly startDate = DateOnly.FromDateTime(DateTime.Now).AddDays(-numDays);
                var query = context.Finances.Where(elem => elem.Date >= startDate).OrderBy(elem => elem.Date).ToList();

                var dates = query.Select(entry => entry.Date).ToList();
                var values = query.Select(entry => entry.Adjusted_Total).ToList();
                if (Total.IsChecked)
                {
                    values = query.Select(entry => entry.Adjusted_Total).ToList();

                }
                else
                {
                    values = query.Select(entry => entry.Adjusted_Total_Cash_QuickWithdrawal).ToList();

                }


                PlotModel progressModel = new PlotModel { Title = "Progress" };

                var cashQuickWithdrawalLine = new LineSeries()
                {
                    Title = "Cash Quick Withdrawal",
                    StrokeThickness = 10,
                    MarkerSize = 2,
                    MarkerType = MarkerType.Circle

                };
                for (int i = 0; i < values.Count; i++)
                {
                    if (values[i] != null) { cashQuickWithdrawalLine.Points.Add(new DataPoint(DateTimeAxis.ToDouble(dates[i].ToDateTime(TimeOnly.MinValue)), (double)values[i]!)); }

                }



                progressModel.Series.Add(cashQuickWithdrawalLine);
                progressModel.Axes.Add(new DateTimeAxis() { Position = AxisPosition.Bottom, Minimum = DateTimeAxis.ToDouble(startDate.ToDateTime(TimeOnly.MinValue)), Maximum = DateTimeAxis.ToDouble(DateTime.Now), StringFormat = "M/d" });

                Plot.Model = progressModel;
            }

        }
    }
}