﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel.DataAnnotations;

namespace FinanceTrackerApplication
{
    public partial class AccountDetailsEntry
    {
        [Key]
        public string Name { get; set; }
        public decimal? InterestAccumulated { get; set; }
        public decimal? InterestRate { get; set; }
        public decimal? LastStatementAmount { get; set; }
        public decimal PaymentAccumulated { get; set; }
        public DateOnly NextPaymentDate { get; set; }
        public DateOnly LastPaymentDate { get; set; }
        public decimal? PaymentAccumulated2 { get; set; }
        public DateOnly? NextPaymentDate2 { get; set; }
        public DateOnly? LastPaymentDate2 { get; set; }
        public DateOnly? LastStatementDate { get; set; }
        public bool IsCredit { get; set; }
        public bool IsLoan { get; set; }
        public bool IsSubscription { get; set; }
        public bool IsPlan { get; set; }
        public decimal MonthlyPayment { get; set; }
        public decimal? AbsoluteMinimumPayment { get; set; }
        public decimal? MinimumPercent { get; set; }
        public bool? IncludeInterestInMinimumPercent { get; set; }
        public DateOnly LastUpdated { get; set; }
    }
    public partial class AccountDetailsEntry
    {
        public decimal CalculateFullPayment()
        {
            if (IsSubscription) { return MonthlyPayment; }
            if (IsCredit || IsLoan)
            {

                decimal tmpPayment;
                if (MonthlyPayment < AbsoluteMinimumPayment)
                {
                    tmpPayment = (decimal)AbsoluteMinimumPayment;
                }
                else tmpPayment = MonthlyPayment;
                if ((bool)IncludeInterestInMinimumPercent)
                {
                    decimal minPay_PercPlusInt = (decimal)-((LastStatementAmount * MinimumPercent / 100) + (LastStatementAmount * ((decimal)Math.Pow((double)1 + (double)(InterestRate / 36500)!, DateTime.DaysInMonth(((DateOnly)LastStatementDate!).Year, ((DateOnly)LastStatementDate).Month)) - 1)))!;
                    if (tmpPayment < minPay_PercPlusInt) tmpPayment = -minPay_PercPlusInt;
                }
                else if (tmpPayment < -LastStatementAmount * MinimumPercent / 100) tmpPayment = (decimal)LastStatementAmount * (decimal)MinimumPercent / 100;
                if (NextPaymentDate2 != null)
                {
                    tmpPayment /= 2;
                }
                tmpPayment = Math.Round(tmpPayment, 2);
                return tmpPayment;
            }
            return -9999999999;
        }
    }
}
