﻿using Microsoft.EntityFrameworkCore;
//using Microsoft.EntityFrameworkCore.Relational; 
using System.ComponentModel.DataAnnotations;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FinanceTrackerApplication
{
    internal class FinanceModel : DbContext
    {
        public DbSet<FinanceEntry> Finances { get; set;}
        public DbSet<FultonTransactionEntry> FultonTransactions { get; set;}
        public DbSet<AccountDetailsEntry> AccountDetails { get; set;}
        public DbSet<YTDEarningsEntry> YTDEarnings { get; set;}
        public DbSet<EarningsEntry> Earnings { get; set;}

        public string DbPath { get; }

        public FinanceModel()
        {
            var folder = Environment.SpecialFolder.LocalApplicationData;
            var localPath = String.IsNullOrEmpty(Environment.GetFolderPath(folder)) ? "/app" : Environment.GetFolderPath(folder);
            var appPath = System.IO.Path.Join(localPath, "WebFinanceTracker");
            System.IO.Directory.CreateDirectory(appPath);
            DbPath = System.IO.Path.Join(localPath, "FinanceModel.db");
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder) => optionsBuilder.UseSqlite($"Data Source={DbPath}");
    }

}
